/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.sync;

public class RollingChecksum32 {
    protected final int char_offset;
    protected int a;
    protected int b;
    protected int k;
    protected int l;
    protected byte[] block;

    public RollingChecksum32(int char_offset) {
        this.char_offset = char_offset;
        this.b = 0;
        this.a = 0;
        this.k = 0;
    }

    public RollingChecksum32() {
        this(0);
    }

    public int getValue() {
        return this.a & 0xFFFF | this.b << 16;
    }

    public void reset() {
        this.k = 0;
        this.b = 0;
        this.a = 0;
        this.l = 0;
    }

    public void roll(byte bt) {
        this.a -= this.block[this.k] + this.char_offset;
        this.b -= this.l * (this.block[this.k] + this.char_offset);
        this.a += bt + this.char_offset;
        this.b += this.a;
        this.block[this.k] = bt;
        ++this.k;
        if (this.k == this.l) {
            this.k = 0;
        }
    }

    public void check(byte[] buf, int off, int len) {
        this.block = new byte[len];
        System.arraycopy(buf, off, this.block, 0, len);
        this.reset();
        this.l = this.block.length;
        int i = 0;
        while (i < this.block.length - 4) {
            this.b += 4 * (this.a + this.block[i]) + 3 * this.block[i + 1] + 2 * this.block[i + 2] + this.block[i + 3] + 10 * this.char_offset;
            this.a += this.block[i] + this.block[i + 1] + this.block[i + 2] + this.block[i + 3] + 4 * this.char_offset;
            i += 4;
        }
        while (i < this.block.length) {
            this.a += this.block[i] + this.char_offset;
            this.b += this.a;
            ++i;
        }
    }

    public boolean equals(Object o) {
        return ((RollingChecksum32)o).a == this.a && ((RollingChecksum32)o).b == this.b;
    }
}

