/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.ui.FrameUtil;

public class SQLTextComboTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private SQLRequestComboBox comboBox;
    int val = 1;
    boolean addUndefined;
    private IListFrame listFrame = null;

    public SQLTextComboTableCellEditor(final SQLElement elt, boolean addUndefined, boolean chooseInListe) {
        this.addUndefined = addUndefined;
        this.comboBox = new SQLRequestComboBox(addUndefined);
        this.comboBox.getTextComp().setBorder(new EmptyBorder(0, 0, 0, 18));
        this.comboBox.setBorder(new LineBorder(Color.black));
        ((JComponent)this.comboBox.getPulseComponent()).setBorder(null);
        ComboSQLRequest c = elt.getComboRequest(true);
        this.comboBox.uiInit(c);
        if (chooseInListe) {
            this.comboBox.getActions().add(0, new AbstractAction("Tout afficher"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SQLTextComboTableCellEditor.this.listFrame == null) {
                        SQLTextComboTableCellEditor.this.listFrame = new IListFrame(new ListeAddPanel(elt));
                        SQLTextComboTableCellEditor.this.listFrame.getPanel().getListe().getSelection().addPropertyChangeListener("userSelectedID", new PropertyChangeListener(){

                            @Override
                            public void propertyChange(PropertyChangeEvent evt) {
                                int newID = ((Number)evt.getNewValue()).intValue();
                                SQLTextComboTableCellEditor.this.comboBox.setValue(newID == -1 ? null : Integer.valueOf(newID));
                            }
                        });
                        SQLTextComboTableCellEditor.this.listFrame.getPanel().getListe().selectID(SQLTextComboTableCellEditor.this.comboBox.getSelectedId());
                    }
                    FrameUtil.show(SQLTextComboTableCellEditor.this.listFrame);
                }
            });
        }
    }

    public SQLRequestComboBox getCombo() {
        return this.comboBox;
    }

    public void addAction(Action a) {
        this.comboBox.getActions().add(a);
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        if (e instanceof MouseEvent) {
            return ((MouseEvent)e).getClickCount() >= 2;
        }
        return super.isCellEditable(e);
    }

    @Override
    public Object getCellEditorValue() {
        return this.val;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value != null) {
            this.val = (Integer)value;
            this.comboBox.setValue(this.val);
        }
        this.comboBox.grabFocus();
        this.comboBox.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!SQLTextComboTableCellEditor.this.comboBox.isUpdating()) {
                    SQLTextComboTableCellEditor.this.val = SQLTextComboTableCellEditor.this.comboBox.getSelectedId();
                }
            }
        });
        return this.comboBox;
    }

    public int getComboSelectedId() {
        return this.comboBox.getSelectedId();
    }

    public void setWhere(Where w) {
        this.comboBox.getRequest().setWhere(w);
    }

    public void addSelectionListener(PropertyChangeListener l) {
        this.comboBox.addValueListener(l);
    }
}

