/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.VirtualMenu;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.IPredicate;

public interface IListeAction {
    public ButtonsBuilder getHeaderButtons();

    public Action getDefaultAction(IListeEvent var1);

    public PopupBuilder getPopupContent(PopupEvent var1);

    public static class ButtonsBuilder {
        private static final ButtonsBuilder NO_BUTTONS = new ButtonsBuilder(Collections.<JButton, IPredicate<IListeEvent>>emptyMap());
        private final Map<JButton, IPredicate<IListeEvent>> map;
        private String defaultGroup;

        public static final ButtonsBuilder emptyInstance() {
            return NO_BUTTONS;
        }

        public ButtonsBuilder() {
            this(new LinkedHashMap<JButton, IPredicate<IListeEvent>>());
        }

        private ButtonsBuilder(Map<JButton, IPredicate<IListeEvent>> map) {
            this.map = map;
            this.defaultGroup = null;
        }

        public final String getDefaultGroup() {
            return this.defaultGroup;
        }

        public final ButtonsBuilder add(JButton btn, IPredicate<IListeEvent> pred) {
            return this.add(btn, pred, this.getDefaultGroup());
        }

        public final ButtonsBuilder add(JButton btn, IPredicate<IListeEvent> pred, String group) {
            btn.putClientProperty("GROUPNAME", group);
            this.map.put(btn, pred);
            return this;
        }

        Map<JButton, IPredicate<IListeEvent>> getContent() {
            return this.map;
        }
    }

    public static class IListeEvent {
        private static final IPredicate<IListeEvent> emptyTotalRowCountPredicate = IListeEvent.createTotalRowCountPredicate(0, 0);
        private static final IPredicate<IListeEvent> singleSelectionPredicate = IListeEvent.createSelectionCountPredicate(1, 1);
        private static final IPredicate<IListeEvent> nonEmptySelectionPredicate = IListeEvent.createNonEmptySelectionPredicate(Integer.MAX_VALUE);
        private final IListe list;
        private final List<SQLRowAccessor> selection;

        public static final IPredicate<IListeEvent> createTotalRowCountPredicate(final int min, final int max) {
            return new IPredicate<IListeEvent>(){

                @Override
                public boolean evaluateChecked(IListeEvent e) {
                    return e.getTotalRowCount() >= min && e.getTotalRowCount() <= max;
                }
            };
        }

        public static final IPredicate<IListeEvent> getSingleSelectionPredicate() {
            return singleSelectionPredicate;
        }

        public static final IPredicate<IListeEvent> getNonEmptySelectionPredicate() {
            return nonEmptySelectionPredicate;
        }

        public static final IPredicate<IListeEvent> createNonEmptySelectionPredicate(int max) {
            return IListeEvent.createSelectionCountPredicate(1, max);
        }

        public static final IPredicate<IListeEvent> createSelectionCountPredicate(final int min, final int max) {
            return new IPredicate<IListeEvent>(){

                @Override
                public boolean evaluateChecked(IListeEvent e) {
                    List<SQLRowAccessor> selectedIDs = e.getSelectedRows();
                    return selectedIDs.size() >= min && selectedIDs.size() <= max;
                }
            };
        }

        IListeEvent(IListe list) {
            this.list = list;
            this.selection = list.getSelectedRows();
        }

        public final SQLRowAccessor getSelectedRow() {
            return CollectionUtils.getFirst(this.getSelectedRows());
        }

        public final List<SQLRowAccessor> getSelectedRows() {
            return this.selection;
        }

        public final int getTotalRowCount() {
            return this.list.getTotalRowCount();
        }
    }

    public static class PopupBuilder {
        private static final PopupBuilder EmptyInstance = new PopupBuilder(VirtualMenu.EMPTY);
        private final VirtualMenu rootMenu;

        public static final PopupBuilder emptyInstance() {
            return EmptyInstance;
        }

        public PopupBuilder() {
            this((String)null);
        }

        public PopupBuilder(String defaultGroup) {
            this(VirtualMenu.createRoot(defaultGroup));
        }

        private PopupBuilder(VirtualMenu rootMenu) {
            this.rootMenu = rootMenu;
        }

        public final VirtualMenu getMenu() {
            return this.rootMenu;
        }

        final JMenuItem getRootMenuItem(Action defaultAction) {
            String actionCommand = (String)defaultAction.getValue("ActionCommandKey");
            if (actionCommand == null) {
                actionCommand = (String)defaultAction.getValue("Name");
            }
            if (actionCommand == null) {
                return null;
            }
            for (JMenuItem mi : this.getMenu().getItemsAndPath(false).keySet()) {
                if (!actionCommand.equals(mi.getActionCommand())) continue;
                return mi;
            }
            return null;
        }
    }

    public static class PopupEvent
    extends IListeEvent {
        private final boolean clickOnRows;

        PopupEvent(IListe list, boolean clickOnRows) {
            super(list);
            this.clickOnRows = clickOnRows;
        }

        public final boolean isClickOnRows() {
            return this.clickOnRows;
        }
    }
}

