/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.request.BaseFillSQLRequest;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.sql.view.list.UpdateRunnable;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.cc.ITransformer;

abstract class AbstractUpdateOneRunnable
extends UpdateRunnable {
    public AbstractUpdateOneRunnable(ITableModel model, SQLTable table, int id) {
        super(model, table, id);
        if (this.getID() < 0) {
            throw new IllegalArgumentException("id is not valid : " + this.getID());
        }
    }

    protected final CollectionMap<Path, ListSQLLine> getAffectedPaths() {
        return this.getSearchQ().getAffectedPaths(this.getTable(), this.getID());
    }

    protected final void updateLines(CollectionMap<Path, ListSQLLine> paths) {
        for (Map.Entry<Path, Collection<ListSQLLine>> e : paths.entrySet()) {
            Path p = e.getKey();
            List lines = (List)e.getValue();
            if (lines.isEmpty()) continue;
            SQLRowValues proto = this.getModel().getLinesSource().getParent().getMaxGraph().followPath(p).deepCopy();
            proto.retainAll(this.getModifedFields());
            SQLRowValuesListFetcher fetcher = new SQLRowValuesListFetcher(proto);
            BaseFillSQLRequest.setupForeign(fetcher);
            ITransformer<SQLSelect, SQLSelect> transf = new ITransformer<SQLSelect, SQLSelect>(){

                @Override
                public SQLSelect transformChecked(SQLSelect input) {
                    if (ListSQLRequest.lockSelect) {
                        input.addWaitPreviousWriteTXTable(AbstractUpdateOneRunnable.this.getTable().getName());
                    }
                    return input.setWhere(new Where((FieldRef)AbstractUpdateOneRunnable.this.getTable().getKey(), "=", AbstractUpdateOneRunnable.this.getID()));
                }
            };
            fetcher.setSelTransf(transf);
            List<SQLRowValues> fetched = fetcher.fetch();
            if (fetched.size() > 1) {
                throw new IllegalStateException("more than one row fetched for " + this + " with " + fetcher.getReq() + " :\n" + fetched);
            }
            if (fetched.size() == 0) {
                Log.get().fine("no row fetched for " + this + ", lines have been changed without the TableModel knowing : " + lines + " req :\n" + fetcher.getReq());
                this.getModel().updateAll();
                continue;
            }
            SQLRowValues soleFetched = fetched.get(0);
            for (ListSQLLine line : lines) {
                line.loadAt(soleFetched.deepCopy(), p);
            }
        }
    }

    protected abstract Collection<String> getModifedFields();
}

