/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLType;
import org.openconcerto.utils.StringUtils;

public class CSVHandler
implements ResultSetHandler {
    private final List<String> names;
    private final List<SQLType> types;

    public CSVHandler(Collection<SQLField> fields) {
        int size = fields.size();
        this.names = new ArrayList<String>(size);
        this.types = new ArrayList<SQLType>(size);
        for (SQLField field : fields) {
            this.names.add(field.getName());
            this.types.add(field.getType());
        }
    }

    @Override
    public String handle(ResultSet rs) throws SQLException {
        int colCount = this.names.size();
        StringBuilder sb = new StringBuilder(16384);
        int i = 0;
        while (i < colCount) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(StringUtils.doubleQuote(this.names.get(i)));
            ++i;
        }
        sb.append('\n');
        while (rs.next()) {
            i = 0;
            while (i < colCount) {
                if (i > 0) {
                    sb.append(',');
                }
                Object obj = rs.getObject(i + 1);
                sb.append(this.types.get(i).toCSV(obj));
                ++i;
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.names.hashCode();
        result = 31 * result + this.types.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CSVHandler other = (CSVHandler)obj;
        return this.names.equals(other.names) && this.types.equals(other.types);
    }
}

