/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model.graph;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBStructureItem;
import org.openconcerto.sql.model.DBStructureItemJDBC;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.CollectionMap2;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.SetMap;

public final class TablesMap
extends SetMap<String, String> {
    public static TablesMap createFromTables(String rootName, Collection<String> tables) {
        return TablesMap.create(Collections.singletonMap(rootName, tables));
    }

    public static TablesMap createFromKeys(Collection<String> keys) {
        return TablesMap.create(keys == null ? null : CollectionUtils.createMap(keys));
    }

    public static TablesMap create(Map<? extends String, ? extends Collection<String>> m) {
        if (m == null) {
            return null;
        }
        TablesMap res = new TablesMap();
        res.putAllCollections(m);
        return res;
    }

    public static final TablesMap createByRootFromChildren(DBStructureItemJDBC parent, Set<String> children) {
        return TablesMap.createFromChildren(parent, children, DBRoot.class);
    }

    private static final <AT extends DBStructureItem<?>> TablesMap createFromChildren(DBStructureItemJDBC parent, Set<String> children, Class<AT> aboveTable) {
        TablesMap res;
        assert (parent.getServer().getSQLSystem().getHops(aboveTable, SQLTable.class) == 1);
        if (parent == null) {
            throw new NullPointerException("Null parent");
        }
        int hopsToRoot = parent.getHopsTo(aboveTable);
        if (hopsToRoot > 1) {
            if (children != null && children.size() == 1) {
                return null;
            }
            throw new IllegalArgumentException("Parent is too high, " + hopsToRoot + " levels above " + aboveTable + " : " + parent);
        }
        if (hopsToRoot == 1) {
            if (children == null) {
                res = null;
            } else {
                res = new TablesMap(children.size());
                for (String s : children) {
                    res.put(s, null);
                }
            }
        } else {
            AT root = parent.getAnc(aboveTable);
            assert (root != null);
            int hopsToTable = parent.getHopsTo(SQLTable.class);
            Set<String> tables = hopsToTable <= 0 ? Collections.singleton(parent.getAncestor(SQLTable.class).getName()) : (hopsToTable == 1 ? children : null);
            res = TablesMap.createFromTables(((DBStructureItem)root).getName(), tables);
        }
        return res;
    }

    public TablesMap() {
        this(3);
    }

    public TablesMap(int initialCapacity) {
        super(initialCapacity, CollectionMap2.Mode.NULL_MEANS_ALL, true);
    }

    @Override
    protected Set<String> createCollection(Collection<? extends String> v) {
        HashSet<String> res = new HashSet<String>(Math.max(8, v.size()));
        res.addAll(v);
        return res;
    }
}

