/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.HashMap;
import java.util.Map;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;

public class UndefinedRowValuesCache {
    private static final UndefinedRowValuesCache instance = new UndefinedRowValuesCache();
    private final Map<SQLTable, SQLRowValues> map = new HashMap<SQLTable, SQLRowValues>();

    public static synchronized UndefinedRowValuesCache getInstance() {
        return instance;
    }

    private final SQLElementDirectory getDirectory() {
        return Configuration.getInstance().getDirectory();
    }

    public SQLRowValues getDefaultRowValues(SQLTable t) {
        SQLRowValues rv = this.map.get(t);
        if (rv == null) {
            rv = new SQLRowValues(t);
            SQLRow undefRow = t.getRow(t.getUndefinedID());
            if (undefRow == null) {
                throw new IllegalStateException(t.getSQLName() + " doesn't contain undef ID " + t.getUndefinedID());
            }
            this.getDirectory().getElement(t).loadAllSafe(rv, undefRow);
            this.map.put(t, rv);
        }
        return rv;
    }
}

