/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.model;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JTable;
import org.openconcerto.erp.core.finance.accounting.model.PlanComptableEModel;
import org.openconcerto.erp.core.finance.accounting.ui.GestionPlanComptableEFrame;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.component.combo.ISearchableCombo;
import org.openconcerto.ui.component.combo.SearchMode;

public class ISQLCompteSelector
extends ElementComboBox {
    private static GestionPlanComptableEFrame frame = null;
    private static ISQLCompteSelector ref = null;
    private static final SQLElement compteElt = Configuration.getInstance().getDirectory().getElement("COMPTE_PCE");
    private boolean addButtonVisible = false;
    JButton selectCompte = new JButton("S\u00e9lection Compte");

    public ISQLCompteSelector() {
    }

    public ISQLCompteSelector(boolean addButtonVisible) {
        this();
        this.addButtonVisible = addButtonVisible;
    }

    @Override
    protected void uiLayout() {
        super.uiLayout();
        this.setButtonsVisible(false);
        this.setAddIconVisible(this.addButtonVisible);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = 13;
        this.add((Component)this.selectCompte, c);
        this.combo.setCompletionMode(new SearchMode(){
            private final Pattern pattrn = Pattern.compile("^\\d+$");

            @Override
            public SearchMode.ComboMatcher matcher(String search) {
                boolean onlyDigits = this.pattrn.matcher(search).matches();
                if (onlyDigits) {
                    return new SearchMode.ComboMatcher(search){

                        @Override
                        public boolean match(String item) {
                            return item.startsWith(this.getSearch());
                        }
                    };
                }
                return ISearchableCombo.MODE_CONTAINS.matcher(search);
            }
        });
        this.selectCompte.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ref = ISQLCompteSelector.this;
                if (frame == null) {
                    frame = new GestionPlanComptableEFrame();
                    Vector v = frame.getPanelPCE().getTables();
                    int i = 0;
                    while (i < v.size()) {
                        final JTable tab = (JTable)v.get(i);
                        tab.addMouseListener(new MouseAdapter(){

                            @Override
                            public void mouseClicked(MouseEvent e) {
                                System.err.println("Mouse clicked");
                                if (e.getButton() == 1) {
                                    PlanComptableEModel model = (PlanComptableEModel)tab.getModel();
                                    ref.setValue(model.getId(tab.getSelectedRow()));
                                }
                            }
                        });
                        ++i;
                    }
                    frame.pack();
                } else {
                    Vector v = frame.getPanelPCE().getTables();
                    int i = 0;
                    while (i < v.size()) {
                        final JTable tab = (JTable)v.get(i);
                        tab.addMouseListener(new MouseAdapter(){

                            @Override
                            public void mouseClicked(MouseEvent e) {
                                System.err.println("Mouse clicked");
                                if (e.getButton() == 1) {
                                    PlanComptableEModel model = (PlanComptableEModel)tab.getModel();
                                    ref.setValue(model.getId(tab.getSelectedRow()));
                                }
                            }
                        });
                        ++i;
                    }
                    frame.pack();
                }
                frame.setVisible(true);
            }
        });
    }

    public void init() {
        this.init(compteElt);
    }
}

