/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.math.BigDecimal;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProvider;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.sql.model.SQLRowAccessor;

public class QteTotalProvider
implements SpreadSheetCellValueProvider {
    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLRowAccessor row = context.getRow();
        int qte = row.getInt("QTE");
        BigDecimal qteUV = row.getBigDecimal("QTE_UNITAIRE");
        BigDecimal result = qteUV.multiply(new BigDecimal(qte));
        BigDecimal pv = row.getBigDecimal("PV_HT");
        if (pv.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        return result;
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("supplychain.element.qte", new QteTotalProvider());
    }
}

