/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.erp.generationDoc.provider.AdresseClientProvider;
import org.openconcerto.map.model.Ville;
import org.openconcerto.sql.model.SQLRowAccessor;

public class AdresseFullClientValueProvider
extends AdresseClientProvider {
    private int type;

    public AdresseFullClientValueProvider(int type) {
        this.type = type;
    }

    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLRowAccessor r = this.getAdresse(context.getRow(), this.type);
        Ville v = Ville.getVilleFromVilleEtCode((String)r.getString("VILLE"));
        String result = r.getString("RUE");
        if (v != null) {
            result = String.valueOf(result) + "\n" + v.getCodepostal();
            result = String.valueOf(result) + " ";
            result = String.valueOf(result) + v.getName();
            if (r.getBoolean("HAS_CEDEX").booleanValue()) {
                result = String.valueOf(result) + " Cedex";
                String cedex = r.getString("CEDEX");
                if (cedex != null && cedex.trim().length() > 0) {
                    result = String.valueOf(result) + " " + cedex;
                }
            }
        }
        return result;
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("address.customer.invoice.full", new AdresseFullClientValueProvider(ADRESSE_FACTURATION));
        SpreadSheetCellValueProviderManager.put("address.customer.shipment.full", new AdresseFullClientValueProvider(ADRESSE_LIVRAISON));
    }
}

