/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import com.lowagie.text.Document;
import com.lowagie.text.PageSize;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jopendocument.model.OpenDocument;
import org.jopendocument.renderer.ODTRenderer;
import org.openconcerto.erp.preferences.GenerationDocGlobalPreferencePanel;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.utils.ExceptionHandler;

public class SheetUtils {
    public static File convertToOldFile(DBRoot root, String fileName, File pathDest, File fDest) {
        return SheetUtils.convertToOldFile(root, fileName, pathDest, fDest, ".ods");
    }

    public static File convertToOldFile(DBRoot root, String fileName, File pathDest, File fDest, String extension) {
        SQLPreferences prefs = new SQLPreferences(root);
        if (prefs.getBoolean(GenerationDocGlobalPreferencePanel.HISTORIQUE, true) && fDest.exists()) {
            int i = 0;
            String destName = fileName;
            File pathOld = new File(pathDest, "Historique");
            pathOld.mkdirs();
            while (fDest.exists()) {
                destName = String.valueOf(fileName) + "_" + i;
                fDest = new File(pathOld, String.valueOf(destName) + extension);
                ++i;
            }
            File fTmp = new File(pathDest, String.valueOf(fileName) + extension);
            if (!fTmp.renameTo(fDest)) {
                final File finalFile = fDest;
                System.err.println("Unable to rename:" + fTmp.getAbsolutePath());
                System.err.println("To:" + fDest.getAbsolutePath());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            JOptionPane.showMessageDialog(null, "Le fichier " + finalFile.getCanonicalPath() + " n'a pu \u00eatre cr\u00e9\u00e9. \n Impossible de d\u00e9placer le fichier existant dans l'historique.\n V\u00e9rifier que le document n'est pas d\u00e9j\u00e0 ouvert.");
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
                return fTmp;
            }
            fDest = new File(pathDest, String.valueOf(fileName) + extension);
        }
        return fDest;
    }

    public static void convert2PDF(OpenDocument doc, File pdfFileToCreate) throws Exception {
        assert (!SwingUtilities.isEventDispatchThread());
        Document document = new Document(PageSize.A4, 50.0f, 50.0f, 50.0f, 50.0f);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(pdfFileToCreate);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)fileOutputStream);
            writer.setPdfVersion('6');
            writer.setFullCompression();
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            ODTRenderer renderer = new ODTRenderer(doc);
            renderer.setIgnoreMargins(false);
            renderer.setPaintMaxResolution(true);
            renderer.setResizeFactor(renderer.getPrintWidth() / (double)document.getPageSize().getWidth());
            int i = 0;
            while (i < renderer.getPrintedPagesNumber()) {
                Graphics2D g2 = cb.createGraphics(PageSize.A4.getWidth(), PageSize.A4.getHeight());
                renderer.setCurrentPage(i);
                renderer.paintComponent((Graphics)g2);
                g2.dispose();
                if (i < renderer.getPrintedPagesNumber() - 1) {
                    document.newPage();
                }
                ++i;
            }
            document.close();
            fileOutputStream.close();
        }
        catch (Exception originalExn) {
            ExceptionHandler.handle("Impossible de cr\u00e9er le PDF " + pdfFileToCreate.getAbsolutePath(), originalExn);
        }
    }

    static File getFileWithExtension(File file, String extension) {
        if (!extension.startsWith(".")) {
            extension = "." + extension;
        }
        String name = file.getName();
        int i = name.lastIndexOf(".");
        name = String.valueOf(name.substring(0, i)) + extension;
        File f = new File(file.getParent(), name);
        return f;
    }
}

