/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.ui.touch.ScrollableList;
import org.openconcerto.utils.Pair;

public class TicketCellRenderer
implements ListCellRenderer {
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Pair item = (Pair)value;
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        JLabel l1 = new JLabel(((Integer)item.getSecond()).toString(), 4);
        p.add((Component)l1, c);
        ++c.gridx;
        c.weightx = 1.0;
        Article article = (Article)item.getFirst();
        JLabel l2 = new JLabel(article.getName().toUpperCase(), 2);
        p.add((Component)l2, c);
        ++c.gridx;
        c.weightx = 0.0;
        Float tauxFromId = TaxeCache.getCache().getTauxFromId(article.getIdTaxe());
        BigDecimal tauxTVA = new BigDecimal(tauxFromId.floatValue()).movePointLeft(2).add(BigDecimal.ONE);
        BigDecimal multiply = article.getPriceHTInCents().multiply(new BigDecimal((Integer)item.getSecond()), MathContext.DECIMAL128).multiply(tauxTVA, MathContext.DECIMAL128);
        JLabel l3 = new JLabel(TicketCellRenderer.centsToString(multiply.movePointRight(2).setScale(0, RoundingMode.HALF_UP).intValue()), 4);
        p.add((Component)l3, c);
        l1.setOpaque(false);
        l2.setOpaque(false);
        l3.setOpaque(false);
        if (isSelected) {
            p.setOpaque(true);
            p.setBackground(new Color(232, 242, 254));
        } else {
            p.setOpaque(false);
        }
        l1.setFont(new Font("Arial", 0, 18));
        l2.setFont(new Font("Arial", 0, 18));
        l3.setFont(new Font("Arial", 0, 18));
        return p;
    }

    public void paint(Graphics g, ScrollableList list, Object value, int index, boolean isSelected) {
        Pair item = (Pair)value;
        if (isSelected) {
            g.setColor(new Color(232, 242, 254));
            g.fillRect(0, 0, list.getWidth(), list.getCellHeight());
        }
        g.setColor(Color.BLACK);
        int inset = 5;
        g.setFont(new Font("Arial", 0, 18));
        int height = g.getFontMetrics().getMaxAscent() + g.getFontMetrics().getMaxDescent() + 5;
        String s1 = ((Integer)item.getSecond()).toString();
        g.drawString(s1, 5, height);
        int width1 = (int)g.getFontMetrics().getStringBounds("999 ", g).getWidth() + 10;
        Article article = (Article)item.getFirst();
        String s2 = article.getName().toUpperCase();
        int maxLength = 13;
        if (s2.length() > 13) {
            s2 = String.valueOf(s2.substring(0, 14)) + '\u2026';
        }
        g.drawString(s2, width1 + 5, height);
        Float tauxFromId = TaxeCache.getCache().getTauxFromId(article.getIdTaxe());
        BigDecimal tauxTVA = new BigDecimal(tauxFromId.floatValue()).movePointLeft(2).add(BigDecimal.ONE);
        BigDecimal multiply = article.getPriceHTInCents().multiply(new BigDecimal((Integer)item.getSecond()), MathContext.DECIMAL128).multiply(tauxTVA, MathContext.DECIMAL128);
        String s3 = TicketCellRenderer.centsToString(multiply.movePointRight(2).setScale(0, RoundingMode.HALF_UP).intValue());
        int width3 = (int)g.getFontMetrics().getStringBounds(s3, g).getWidth() + 10;
        g.drawString(s3, list.getWidth() - width3, height);
    }

    public static String centsToString(int cents) {
        int c = cents % 100;
        String sc = String.valueOf(c);
        if (c < 10) {
            sc = "0" + sc;
        }
        return String.valueOf(cents / 100) + "." + sc;
    }
}

