/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.order.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.core.common.component.TransfertBaseSQLComponent;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.common.ui.TotalPanel;
import org.openconcerto.erp.core.sales.order.element.CommandeClientSQLElement;
import org.openconcerto.erp.core.sales.order.report.CommandeClientXmlSheet;
import org.openconcerto.erp.core.sales.order.ui.CommandeClientItemTable;
import org.openconcerto.erp.panel.PanelOOSQLComponent;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.JUniqueTextField;
import org.openconcerto.sql.sqlobject.SQLTextCombo;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.ui.preferences.DefaultProps;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ExceptionHandler;

public class CommandeClientSQLComponent
extends TransfertBaseSQLComponent {
    private CommandeClientItemTable table;
    private JUniqueTextField numeroUniqueCommande;
    private final SQLTable tableNum = this.getTable().getBase().getTable("NUMEROTATION_AUTO");
    private final ITextArea infos = new ITextArea(3, 3);
    private ElementComboBox comboCommercial;
    private ElementComboBox comboDevis;
    private ElementComboBox comboClient;
    private PanelOOSQLComponent panelOO;
    private final SQLTextCombo textObjet = new SQLTextCombo();

    public CommandeClientSQLComponent() {
        super(Configuration.getInstance().getDirectory().getElement("COMMANDE_CLIENT"));
    }

    @Override
    public void addViews() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = 0;
        this.add((Component)new JLabel(this.getLabelFor("NUMERO"), 4), c);
        this.numeroUniqueCommande = new JUniqueTextField(16);
        c.fill = 0;
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.numeroUniqueCommande, c);
        JLabel labelDate = new JLabel(this.getLabelFor("DATE"));
        labelDate.setHorizontalAlignment(4);
        c.gridx = 2;
        c.fill = 2;
        c.weightx = 0.0;
        this.add((Component)labelDate, c);
        JDate dateCommande = new JDate(true);
        ++c.gridx;
        c.fill = 0;
        this.add((Component)((Object)dateCommande), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        JPanel addP = ComptaSQLConfElement.createAdditionalPanel();
        this.setAdditionalFieldsPanel(new FormLayouter(addP, 2));
        c.fill = 2;
        c.weightx = 1.0;
        this.add((Component)addP, c);
        ++c.gridy;
        c.gridwidth = 1;
        this.comboDevis = new ElementComboBox();
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 2;
        JLabel labelObjet = new JLabel(this.getLabelFor("NOM"));
        labelObjet.setHorizontalAlignment(4);
        c.weightx = 0.0;
        this.add((Component)labelObjet, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 1;
        this.add((Component)this.textObjet, c);
        String field = "ID_COMMERCIAL";
        c.fill = 2;
        JLabel labelCommercial = new JLabel(this.getLabelFor(field));
        labelCommercial.setHorizontalAlignment(4);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)labelCommercial, c);
        this.comboCommercial = new ElementComboBox(false, 25);
        this.comboCommercial.setListIconVisible(false);
        ++c.gridx;
        c.fill = 0;
        c.weightx = 1.0;
        this.add((Component)this.comboCommercial, c);
        this.addRequiredSQLObject(this.comboCommercial, field);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel(this.getLabelFor("ID_CLIENT"), 4), c);
        this.comboClient = new ElementComboBox();
        c.gridx = -1;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.add((Component)this.comboClient, c);
        final ElementComboBox boxTarif = new ElementComboBox();
        this.comboClient.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Integer id;
                if (!CommandeClientSQLComponent.this.isFilling() && CommandeClientSQLComponent.this.comboClient.getValue() != null && (id = CommandeClientSQLComponent.this.comboClient.getValue()) > 1) {
                    SQLRow row = CommandeClientSQLComponent.this.comboClient.getElement().getTable().getRow(id);
                    if (CommandeClientSQLComponent.this.comboClient.getElement().getTable().getFieldsName().contains("ID_TARIF")) {
                        SQLRow foreignRow = row.getForeignRow("ID_TARIF");
                        if (!(foreignRow.isUndefined() || boxTarif.getSelectedRow() != null && boxTarif.getSelectedId() == ((SQLRowAccessor)foreignRow).getID() || JOptionPane.showConfirmDialog(null, "Appliquer les tarifs associ\u00e9s au client?") != 0)) {
                            boxTarif.setValue(((SQLRowAccessor)foreignRow).getID());
                        } else {
                            boxTarif.setValue(((SQLRowAccessor)foreignRow).getID());
                        }
                    }
                }
            }
        });
        if (this.getTable().getFieldsName().contains("ID_TARIF")) {
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            this.add((Component)new JLabel("Tarif \u00e0 appliquer"), c);
            ++c.gridx;
            c.gridwidth = 0;
            c.weightx = 1.0;
            this.add((Component)boxTarif, c);
            this.addView(boxTarif, "ID_TARIF");
            boxTarif.addModelListener("wantedID", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SQLRow selectedRow = boxTarif.getRequest().getPrimaryTable().getRow(boxTarif.getWantedID());
                    CommandeClientSQLComponent.this.table.setTarif(selectedRow, false);
                }
            });
        }
        this.table = new CommandeClientItemTable();
        c.fill = 1;
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        this.add((Component)this.table, c);
        DeviseField textPortHT = new DeviseField();
        DeviseField textRemiseHT = new DeviseField();
        c.gridx = 0;
        ++c.gridy;
        c.gridheight = 1;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.anchor = 17;
        c.gridwidth = 2;
        this.add((Component)new TitledSeparator(this.getLabelFor("INFOS")), c);
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 1;
        JScrollPane scrollPane = new JScrollPane(this.infos);
        scrollPane.setBorder(null);
        this.add((Component)scrollPane, c);
        c.gridwidth = 1;
        DefaultProps props = DefaultNXProps.getInstance();
        Boolean b = props.getBooleanValue("ArticleShowPoids");
        final JTextField textPoidsTotal = new JTextField(8);
        if (b.booleanValue()) {
            JPanel panel = new JPanel();
            panel.add((Component)new JLabel(this.getLabelFor("T_POIDS")), c);
            textPoidsTotal.setEnabled(false);
            textPoidsTotal.setHorizontalAlignment(4);
            textPoidsTotal.setDisabledTextColor(Color.BLACK);
            panel.add((Component)textPoidsTotal, c);
            panel.setOpaque(false);
            DefaultGridBagConstraints.lockMinimumSize(panel);
            c.gridx = 2;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.fill = 0;
            c.anchor = 12;
            this.add((Component)panel, c);
        }
        DeviseField fieldHT = new DeviseField();
        DeviseField fieldTVA = new DeviseField();
        DeviseField fieldTTC = new DeviseField();
        DeviseField fieldDevise = new DeviseField();
        DeviseField fieldService = new DeviseField();
        DeviseField fieldHA = new DeviseField();
        fieldHT.setOpaque(false);
        fieldHA.setOpaque(false);
        fieldTVA.setOpaque(false);
        fieldTTC.setOpaque(false);
        fieldService.setOpaque(false);
        this.addSQLObject(fieldDevise, "T_DEVISE");
        this.addRequiredSQLObject(fieldHT, "T_HT");
        this.addRequiredSQLObject(fieldTVA, "T_TVA");
        this.addRequiredSQLObject(fieldTTC, "T_TTC");
        this.addRequiredSQLObject(fieldService, "T_SERVICE");
        if (this.getTable().contains("PREBILAN")) {
            this.addSQLObject(fieldHA, "PREBILAN");
        } else if (this.getTable().contains("T_HA")) {
            this.addSQLObject(fieldHA, "T_HA");
        }
        JTextField poids = new JTextField();
        final TotalPanel totalTTC = new TotalPanel(this.table, fieldHT, fieldTVA, fieldTTC, textPortHT, textRemiseHT, fieldService, fieldHA, fieldDevise, poids, null);
        c.gridx = -1;
        --c.gridy;
        c.gridwidth = 0;
        c.gridheight = 2;
        c.anchor = 12;
        c.fill = 0;
        c.weighty = 0.0;
        this.add((Component)totalTTC, c);
        this.panelOO = new PanelOOSQLComponent(this);
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 13;
        c.gridx = 0;
        c.gridy += 3;
        c.weightx = 0.0;
        c.gridwidth = 0;
        this.add((Component)this.panelOO, c);
        textPortHT.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }
        });
        textRemiseHT.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }
        });
        this.addRequiredSQLObject(this.comboClient, "ID_CLIENT");
        this.addSQLObject(this.textObjet, "NOM");
        this.addSQLObject(textPoidsTotal, "T_POIDS");
        this.addRequiredSQLObject((JComponent)((Object)dateCommande), "DATE");
        this.addRequiredSQLObject(this.numeroUniqueCommande, "NUMERO");
        this.addSQLObject(this.infos, "INFOS");
        this.addSQLObject(this.comboDevis, "ID_DEVIS");
        this.numeroUniqueCommande.setText(NumerotationAutoSQLElement.getNextNumero(CommandeClientSQLElement.class, new Date()));
        this.table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                textPoidsTotal.setText(String.valueOf(CommandeClientSQLComponent.this.table.getPoidsTotal()));
            }
        });
        DefaultGridBagConstraints.lockMinimumSize(this.comboClient);
        DefaultGridBagConstraints.lockMinimumSize(this.comboCommercial);
        DefaultGridBagConstraints.lockMinimumSize(this.comboDevis);
        DefaultGridBagConstraints.lockMinimumSize(totalTTC);
        DefaultGridBagConstraints.lockMaximumSize(totalTTC);
        DefaultGridBagConstraints.lockMinimumSize(this.numeroUniqueCommande);
    }

    @Override
    public int insert(SQLRow order) {
        int idCommande;
        if (this.numeroUniqueCommande.checkValidation()) {
            idCommande = super.insert(order);
            this.table.updateField("ID_COMMANDE_CLIENT", idCommande);
            this.table.createArticle(idCommande, this.getElement());
            try {
                CommandeClientXmlSheet sheet = new CommandeClientXmlSheet(this.getTable().getRow(idCommande));
                sheet.createDocumentAsynchronous();
                sheet.showPrintAndExportAsynchronous(this.panelOO.isVisualisationSelected(), this.panelOO.isImpressionSelected(), true);
            }
            catch (Exception e) {
                ExceptionHandler.handle("Impossible de cr\u00e9er la commande", e);
            }
            if (NumerotationAutoSQLElement.getNextNumero(CommandeClientSQLElement.class, new Date()).equalsIgnoreCase(this.numeroUniqueCommande.getText().trim())) {
                SQLRowValues rowVals = new SQLRowValues(this.tableNum);
                int val = this.tableNum.getRow(2).getInt("COMMANDE_CLIENT_START");
                rowVals.put("COMMANDE_CLIENT_START", new Integer(++val));
                try {
                    rowVals.update(2);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        } else {
            idCommande = this.getSelectedID();
            ExceptionHandler.handle("Impossible d'ajouter, num\u00e9ro de commande client existant.");
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
        }
        return idCommande;
    }

    @Override
    public void select(SQLRowAccessor r) {
        if (r != null) {
            this.numeroUniqueCommande.setIdSelected(r.getID());
        }
        if (r == null || r.getIDNumber() == null) {
            super.select(r);
        } else {
            System.err.println(r);
            SQLRowValues rVals = r.asRowValues();
            SQLRowValues vals = new SQLRowValues(r.getTable());
            vals.load(rVals, CollectionUtils.createSet("ID_CLIENT"));
            vals.setID(rVals.getID());
            System.err.println("Select CLIENT");
            super.select(vals);
            rVals.remove("ID_CLIENT");
            super.select(rVals);
        }
        if (r != null) {
            this.table.insertFrom("ID_COMMANDE_CLIENT", r.getID());
        }
    }

    @Override
    public void update() {
        if (!this.numeroUniqueCommande.checkValidation()) {
            ExceptionHandler.handle("Impossible d'ajouter, num\u00e9ro de commande client existant.");
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
            return;
        }
        super.update();
        this.table.updateField("ID_COMMANDE_CLIENT", this.getSelectedID());
        this.table.createArticle(this.getSelectedID(), this.getElement());
        try {
            CommandeClientXmlSheet sheet = new CommandeClientXmlSheet(this.getTable().getRow(this.getSelectedID()));
            sheet.createDocumentAsynchronous();
            sheet.showPrintAndExportAsynchronous(this.panelOO.isVisualisationSelected(), this.panelOO.isImpressionSelected(), true);
        }
        catch (Exception e) {
            ExceptionHandler.handle("Impossible de cr\u00e9er la commande", e);
        }
    }

    public void setDefaults() {
        this.resetValue();
        this.numeroUniqueCommande.setText(NumerotationAutoSQLElement.getNextNumero(CommandeClientSQLElement.class, new Date()));
        this.table.getModel().clearRows();
    }

    public void loadDevis(int idDevis) {
        SQLElement devis = Configuration.getInstance().getDirectory().getElement("DEVIS");
        SQLElement devisElt = Configuration.getInstance().getDirectory().getElement("DEVIS_ELEMENT");
        if (idDevis > 1) {
            SQLInjector injector = SQLInjector.getInjector(devis.getTable(), this.getTable());
            SQLRowValues createRowValuesFrom = injector.createRowValuesFrom(idDevis);
            SQLRow rowDevis = devis.getTable().getRow(idDevis);
            String string = rowDevis.getString("OBJET");
            createRowValuesFrom.put("NOM", String.valueOf(string) + (string.trim().length() == 0 ? "" : ",") + rowDevis.getString("NUMERO"));
            this.select(createRowValuesFrom);
        }
        this.loadItem(this.table, devis, idDevis, devisElt);
    }

    @Override
    protected SQLRowValues createDefaults() {
        SQLRowValues rowVals = new SQLRowValues(this.getTable());
        rowVals.put("T_POIDS", Float.valueOf(0.0f));
        rowVals.put("NUMERO", NumerotationAutoSQLElement.getNextNumero(CommandeClientSQLElement.class, new Date()));
        SQLElement eltComm = Configuration.getInstance().getDirectory().getElement("COMMERCIAL");
        int idUser = UserManager.getInstance().getCurrentUser().getId();
        SQLRow rowsComm = SQLBackgroundTableCache.getInstance().getCacheForTable(eltComm.getTable()).getFirstRowContains(idUser, eltComm.getTable().getField("ID_USER_COMMON"));
        if (rowsComm != null) {
            rowVals.put("ID_COMMERCIAL", rowsComm.getID());
        }
        return rowVals;
    }
}

