/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableControlPanel;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.RowValuesTableRenderer;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.table.XTableColumnModel;

public abstract class AbstractArticleItemTable
extends JPanel {
    protected RowValuesTable table;
    protected SQLTableElement totalHT;
    protected SQLTableElement totalHA;
    protected SQLTableElement tableElementTVA;
    protected SQLTableElement tableElementTotalTTC;
    protected SQLTableElement tableElementTotalDevise;
    protected SQLTableElement service;
    protected SQLTableElement qte;
    protected SQLTableElement ha;
    protected SQLTableElement tableElementPoidsTotal;
    protected SQLTableElement prebilan;
    protected RowValuesTableModel model;
    private List<JButton> buttons = null;
    protected RowValuesTableControlPanel control = null;
    private SQLRowAccessor tarif = null;

    public AbstractArticleItemTable() {
        this.init();
        this.uiInit();
    }

    public AbstractArticleItemTable(List<JButton> buttons) {
        this.buttons = buttons;
        this.init();
        this.uiInit();
    }

    protected abstract void init();

    protected File getConfigurationFile() {
        return new File(Configuration.getInstance().getConfDir(), "Table/" + this.getConfigurationFileName());
    }

    protected void uiInit() {
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        this.control = new RowValuesTableControlPanel(this.table, this.buttons);
        this.control.setOpaque(false);
        this.add((Component)this.control, c);
        ++c.gridy;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        JScrollPane comp = new JScrollPane(this.table);
        comp.setVerticalScrollBarPolicy(22);
        this.add((Component)comp, c);
        this.table.setDefaultRenderer(Long.class, new RowValuesTableRenderer());
    }

    protected abstract String getConfigurationFileName();

    public abstract SQLElement getSQLElement();

    public void updateField(String field, int id) {
        this.table.updateField(field, id);
    }

    public RowValuesTable getRowValuesTable() {
        return this.table;
    }

    public void insertFrom(String field, int id) {
        this.table.insertFrom(field, id);
    }

    public RowValuesTableModel getModel() {
        return this.table.getRowValuesTableModel();
    }

    public SQLTableElement getPrebilanElement() {
        return this.prebilan;
    }

    public SQLTableElement getPrixTotalHTElement() {
        return this.totalHT;
    }

    public SQLTableElement getPoidsTotalElement() {
        return this.tableElementPoidsTotal;
    }

    public SQLTableElement getPrixTotalTTCElement() {
        return this.tableElementTotalTTC;
    }

    public SQLTableElement getQteElement() {
        return this.qte;
    }

    public SQLTableElement getHaElement() {
        return this.ha;
    }

    public SQLTableElement getTotalHaElement() {
        return this.totalHA;
    }

    public SQLTableElement getTableElementTotalDevise() {
        return this.tableElementTotalDevise;
    }

    public float getPoidsTotal() {
        float poids = 0.0f;
        int poidsTColIndex = this.model.getColumnIndexForElement(this.tableElementPoidsTotal);
        if (poidsTColIndex >= 0) {
            int i = 0;
            while (i < this.table.getRowCount()) {
                Number tmp = (Number)this.model.getValueAt(i, poidsTColIndex);
                if (tmp != null) {
                    poids += tmp.floatValue();
                }
                ++i;
            }
        }
        return poids;
    }

    public void createArticle(int id, SQLElement eltSource) {
        SQLElement eltArticleTable = this.getSQLElement();
        SQLTable tableArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ARTICLE");
        boolean modeAvance = DefaultNXProps.getInstance().getBooleanValue("ArticleModeVenteAvance", false);
        SQLPreferences prefs = SQLPreferences.getMemCached(tableArticle.getDBRoot());
        boolean createArticle = prefs.getBoolean(GestionArticleGlobalPreferencePanel.CREATE_ARTICLE_AUTO, true);
        Collection listElts = eltSource.getTable().getRow(id).getReferentRows(eltArticleTable.getTable());
        SQLRowValues rowArticle = new SQLRowValues(tableArticle);
        Set<SQLField> fields = tableArticle.getFields();
        for (SQLRow rowElt : listElts) {
            Set<String> fieldsName = rowElt.getTable().getFieldsName();
            for (SQLField field : fields) {
                String name = field.getName();
                if (!fieldsName.contains(name) || field.isPrimaryKey()) continue;
                rowArticle.put(name, rowElt.getObject(name));
            }
            if (modeAvance) {
                ReferenceArticleSQLElement.getIdForCNM(rowArticle, createArticle);
                continue;
            }
            ReferenceArticleSQLElement.getIdForCN(rowArticle, createArticle);
        }
    }

    public SQLRowAccessor getTarif() {
        return this.tarif;
    }

    public void setTarif(SQLRowAccessor idTarif, boolean ask) {
        this.tarif = idTarif;
    }

    protected void setColumnVisible(int col, boolean visible) {
        if (col >= 0) {
            XTableColumnModel columnModel = this.table.getColumnModel();
            columnModel.setColumnVisible(columnModel.getColumnByModelIndex(col), visible);
        }
    }
}

