/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.config;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JSeparator;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.config.NewsUpdater;
import org.openconcerto.erp.core.common.ui.StatusPanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.task.TodoListPanel;
import org.openconcerto.task.config.ComptaBasePropsConfiguration;
import org.openconcerto.ui.AutoHideTabbedPane;
import org.openconcerto.ui.state.WindowStateManager;
import org.openconcerto.utils.JImage;
import org.openconcerto.utils.OSXAdapter;

public class MainFrame
extends JFrame {
    private static final List<Runnable> runnables = new ArrayList<Runnable>();
    private static MainFrame instance = null;
    private final AutoHideTabbedPane tabContainer;
    private TodoListPanel todoPanel;
    private JImage image;

    private static void setInstance(MainFrame f) {
        if (f != null && instance != null) {
            throw new IllegalStateException("More than one main frame");
        }
        instance = f;
        if (f != null) {
            for (Runnable r : runnables) {
                r.run();
            }
            runnables.clear();
        }
    }

    public TodoListPanel getTodoPanel() {
        return this.todoPanel;
    }

    public MainFrame() {
        String confSuffix;
        Dimension minSize;
        this.setIconImage(new ImageIcon(this.getClass().getResource("frameicon.png")).getImage());
        Container co = this.getContentPane();
        co.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.image = new JImage(ComptaBasePropsConfiguration.class.getResource("logo.png"));
        this.image.setBackground(Color.WHITE);
        this.image.check();
        co.add((Component)this.image, c);
        c.weighty = 0.0;
        ++c.gridy;
        c.fill = 1;
        co.add((Component)new JSeparator(0), c);
        ++c.gridy;
        c.weighty = 1.0;
        this.tabContainer = new AutoHideTabbedPane();
        co.add((Component)this.tabContainer, c);
        if (!Gestion.isMinimalMode()) {
            this.todoPanel = new TodoListPanel();
            this.getTabbedPane().addTab("T\u00e2ches", this.todoPanel);
            minSize = new Dimension(800, 600);
            confSuffix = "";
        } else {
            minSize = null;
            confSuffix = "-minimal";
        }
        c.weighty = 0.0;
        ++c.gridy;
        c.fill = 2;
        co.add((Component)StatusPanel.getInstance(), c);
        if (minSize == null) {
            this.pack();
            minSize = new Dimension(this.getSize());
        }
        this.setMinimumSize(minSize);
        File confFile = new File(Configuration.getInstance().getConfDir(), "Configuration" + File.separator + "Frame" + File.separator + "mainFrame" + confSuffix + ".xml");
        new WindowStateManager(this, confFile).loadState();
        this.registerForMacOSXEvents();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                MainFrame.this.quit();
            }
        });
        MainFrame.setInstance(this);
        Image im = ComptaPropsConfiguration.getInstanceCompta().getCustomLogo();
        if (im != null) {
            this.image.setImage(im);
        }
        new NewsUpdater(this.image);
    }

    public void registerForMacOSXEvents() {
        if (Gestion.MAC_OS_X) {
            try {
                OSXAdapter.setQuitHandler(this, this.getClass().getDeclaredMethod("quit", new Class[0]));
                OSXAdapter.setAboutHandler(this, this.getClass().getDeclaredMethod("about", new Class[0]));
                OSXAdapter.setPreferencesHandler(this, this.getClass().getDeclaredMethod("preferences", new Class[0]));
            }
            catch (Exception e) {
                System.err.println("Error while loading the OSXAdapter:");
                e.printStackTrace();
            }
        }
    }

    public boolean quit() {
        if (this.getTodoPanel() != null) {
            this.getTodoPanel().stopUpdate();
        }
        Gestion.askForExit();
        return false;
    }

    public final AutoHideTabbedPane getTabbedPane() {
        return this.tabContainer;
    }
}

