/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.traverse;

import java.util.ArrayList;
import java.util.List;
import org.jgrapht.event.ConnectedComponentTraversalEvent;
import org.jgrapht.event.EdgeTraversalEvent;
import org.jgrapht.event.TraversalListener;
import org.jgrapht.event.VertexTraversalEvent;
import org.jgrapht.traverse.GraphIterator;

public abstract class AbstractGraphIterator<V, E>
implements GraphIterator<V, E> {
    private List<TraversalListener<V, E>> traversalListeners = new ArrayList<TraversalListener<V, E>>();
    private boolean crossComponentTraversal = true;
    private boolean reuseEvents = false;

    public void setCrossComponentTraversal(boolean crossComponentTraversal) {
        this.crossComponentTraversal = crossComponentTraversal;
    }

    public boolean isCrossComponentTraversal() {
        return this.crossComponentTraversal;
    }

    public boolean isReuseEvents() {
        return this.reuseEvents;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected void fireConnectedComponentFinished(ConnectedComponentTraversalEvent e) {
        int len = this.traversalListeners.size();
        int i = 0;
        while (i < len) {
            TraversalListener<V, E> l = this.traversalListeners.get(i);
            l.connectedComponentFinished(e);
            ++i;
        }
    }

    protected void fireConnectedComponentStarted(ConnectedComponentTraversalEvent e) {
        int len = this.traversalListeners.size();
        int i = 0;
        while (i < len) {
            TraversalListener<V, E> l = this.traversalListeners.get(i);
            l.connectedComponentStarted(e);
            ++i;
        }
    }

    protected void fireEdgeTraversed(EdgeTraversalEvent<V, E> e) {
        int len = this.traversalListeners.size();
        int i = 0;
        while (i < len) {
            TraversalListener<V, E> l = this.traversalListeners.get(i);
            l.edgeTraversed(e);
            ++i;
        }
    }

    protected void fireVertexTraversed(VertexTraversalEvent<V> e) {
        int len = this.traversalListeners.size();
        int i = 0;
        while (i < len) {
            TraversalListener<V, E> l = this.traversalListeners.get(i);
            l.vertexTraversed(e);
            ++i;
        }
    }
}

