/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.graph.AbstractGraph;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.EdgeSetFactory;
import org.jgrapht.graph.IntrusiveEdge;
import org.jgrapht.util.ArrayUnenforcedSet;
import org.jgrapht.util.TypeUtil;

public abstract class AbstractBaseGraph<V, E>
extends AbstractGraph<V, E>
implements Graph<V, E>,
Cloneable,
Serializable {
    boolean allowingLoops;
    private EdgeFactory<V, E> edgeFactory;
    private EdgeSetFactory<V, E> edgeSetFactory;
    private Map<E, IntrusiveEdge> edgeMap;
    private transient Set<E> unmodifiableEdgeSet = null;
    private transient Set<V> unmodifiableVertexSet = null;
    private Specifics specifics;
    private boolean allowingMultipleEdges;
    private transient TypeUtil<V> vertexTypeDecl = null;

    public AbstractBaseGraph(EdgeFactory<V, E> ef, boolean allowMultipleEdges, boolean allowLoops) {
        if (ef == null) {
            throw new NullPointerException();
        }
        this.edgeMap = new LinkedHashMap<E, IntrusiveEdge>();
        this.edgeFactory = ef;
        this.allowingLoops = allowLoops;
        this.allowingMultipleEdges = allowMultipleEdges;
        this.specifics = this.createSpecifics();
        this.edgeSetFactory = new ArrayListFactory<V, E>();
    }

    public Set<E> getAllEdges(V sourceVertex, V targetVertex) {
        return this.specifics.getAllEdges(sourceVertex, targetVertex);
    }

    @Override
    public E getEdge(V sourceVertex, V targetVertex) {
        return this.specifics.getEdge(sourceVertex, targetVertex);
    }

    @Override
    public boolean addEdge(V sourceVertex, V targetVertex, E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.containsEdge(e)) {
            return false;
        }
        this.assertVertexExist(sourceVertex);
        this.assertVertexExist(targetVertex);
        if (!this.allowingMultipleEdges && this.containsEdge(sourceVertex, targetVertex)) {
            return false;
        }
        if (!this.allowingLoops && sourceVertex.equals(targetVertex)) {
            throw new IllegalArgumentException("loops not allowed");
        }
        IntrusiveEdge intrusiveEdge = this.createIntrusiveEdge(e, sourceVertex, targetVertex);
        this.edgeMap.put(e, intrusiveEdge);
        this.specifics.addEdgeToTouchingVertices(e);
        return true;
    }

    private IntrusiveEdge createIntrusiveEdge(E e, V sourceVertex, V targetVertex) {
        IntrusiveEdge intrusiveEdge = e instanceof IntrusiveEdge ? (IntrusiveEdge)e : new IntrusiveEdge();
        intrusiveEdge.source = sourceVertex;
        intrusiveEdge.target = targetVertex;
        return intrusiveEdge;
    }

    @Override
    public boolean addVertex(V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        if (this.containsVertex(v)) {
            return false;
        }
        this.specifics.addVertex(v);
        return true;
    }

    @Override
    public V getEdgeSource(E e) {
        return TypeUtil.uncheckedCast(this.getIntrusiveEdge(e).source, this.vertexTypeDecl);
    }

    @Override
    public V getEdgeTarget(E e) {
        return TypeUtil.uncheckedCast(this.getIntrusiveEdge(e).target, this.vertexTypeDecl);
    }

    private IntrusiveEdge getIntrusiveEdge(E e) {
        if (e instanceof IntrusiveEdge) {
            return (IntrusiveEdge)e;
        }
        return this.edgeMap.get(e);
    }

    public Object clone() {
        try {
            TypeUtil typeDecl = null;
            AbstractBaseGraph newGraph = (AbstractBaseGraph)TypeUtil.uncheckedCast(super.clone(), typeDecl);
            newGraph.edgeMap = new LinkedHashMap<E, IntrusiveEdge>();
            newGraph.edgeFactory = this.edgeFactory;
            newGraph.unmodifiableEdgeSet = null;
            newGraph.unmodifiableVertexSet = null;
            newGraph.specifics = newGraph.createSpecifics();
            Graphs.addGraph(newGraph, this);
            return newGraph;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    public boolean containsEdge(E e) {
        return this.edgeMap.containsKey(e);
    }

    @Override
    public boolean containsVertex(V v) {
        return this.specifics.getVertexSet().contains(v);
    }

    @Override
    public Set<E> edgeSet() {
        if (this.unmodifiableEdgeSet == null) {
            this.unmodifiableEdgeSet = Collections.unmodifiableSet(this.edgeMap.keySet());
        }
        return this.unmodifiableEdgeSet;
    }

    @Override
    public Set<E> edgesOf(V vertex) {
        return this.specifics.edgesOf(vertex);
    }

    public Set<E> incomingEdgesOf(V vertex) {
        return this.specifics.incomingEdgesOf(vertex);
    }

    public Set<E> outgoingEdgesOf(V vertex) {
        return this.specifics.outgoingEdgesOf(vertex);
    }

    @Override
    public boolean removeEdge(E e) {
        if (this.containsEdge(e)) {
            this.specifics.removeEdgeFromTouchingVertices(e);
            this.edgeMap.remove(e);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeVertex(V v) {
        if (this.containsVertex(v)) {
            Set<E> touchingEdgesList = this.edgesOf(v);
            this.removeAllEdges(new ArrayList<E>(touchingEdgesList));
            this.specifics.getVertexSet().remove(v);
            return true;
        }
        return false;
    }

    @Override
    public Set<V> vertexSet() {
        if (this.unmodifiableVertexSet == null) {
            this.unmodifiableVertexSet = Collections.unmodifiableSet(this.specifics.getVertexSet());
        }
        return this.unmodifiableVertexSet;
    }

    @Override
    public double getEdgeWeight(E e) {
        if (e instanceof DefaultWeightedEdge) {
            return ((DefaultWeightedEdge)e).weight;
        }
        return 1.0;
    }

    private Specifics createSpecifics() {
        if (this instanceof DirectedGraph) {
            return new DirectedSpecifics();
        }
        if (this instanceof UndirectedGraph) {
            return new UndirectedSpecifics();
        }
        throw new IllegalArgumentException("must be instance of either DirectedGraph or UndirectedGraph");
    }

    private static class ArrayListFactory<VV, EE>
    implements EdgeSetFactory<VV, EE>,
    Serializable {
        private ArrayListFactory() {
        }

        @Override
        public Set<EE> createEdgeSet(VV vertex) {
            return new ArrayUnenforcedSet(1);
        }
    }

    private static class DirectedEdgeContainer<VV, EE>
    implements Serializable {
        Set<EE> incoming;
        Set<EE> outgoing;
        private transient Set<EE> unmodifiableIncoming = null;
        private transient Set<EE> unmodifiableOutgoing = null;

        DirectedEdgeContainer(EdgeSetFactory<VV, EE> edgeSetFactory, VV vertex) {
            this.incoming = edgeSetFactory.createEdgeSet(vertex);
            this.outgoing = edgeSetFactory.createEdgeSet(vertex);
        }

        public Set<EE> getUnmodifiableIncomingEdges() {
            if (this.unmodifiableIncoming == null) {
                this.unmodifiableIncoming = Collections.unmodifiableSet(this.incoming);
            }
            return this.unmodifiableIncoming;
        }

        public Set<EE> getUnmodifiableOutgoingEdges() {
            if (this.unmodifiableOutgoing == null) {
                this.unmodifiableOutgoing = Collections.unmodifiableSet(this.outgoing);
            }
            return this.unmodifiableOutgoing;
        }

        public void addIncomingEdge(EE e) {
            this.incoming.add(e);
        }

        public void addOutgoingEdge(EE e) {
            this.outgoing.add(e);
        }

        public void removeIncomingEdge(EE e) {
            this.incoming.remove(e);
        }

        public void removeOutgoingEdge(EE e) {
            this.outgoing.remove(e);
        }
    }

    private class DirectedSpecifics
    extends Specifics
    implements Serializable {
        private Map<V, DirectedEdgeContainer<V, E>> vertexMapDirected;

        private DirectedSpecifics() {
            this.vertexMapDirected = new LinkedHashMap();
        }

        @Override
        public void addVertex(V v) {
            this.vertexMapDirected.put(v, null);
        }

        @Override
        public Set<V> getVertexSet() {
            return this.vertexMapDirected.keySet();
        }

        @Override
        public Set<E> getAllEdges(V sourceVertex, V targetVertex) {
            ArrayUnenforcedSet edges = null;
            if (AbstractBaseGraph.this.containsVertex(sourceVertex) && AbstractBaseGraph.this.containsVertex(targetVertex)) {
                edges = new ArrayUnenforcedSet();
                DirectedEdgeContainer ec = this.getEdgeContainer(sourceVertex);
                for (Object e : ec.outgoing) {
                    if (!AbstractBaseGraph.this.getEdgeTarget(e).equals(targetVertex)) continue;
                    edges.add(e);
                }
            }
            return edges;
        }

        @Override
        public E getEdge(V sourceVertex, V targetVertex) {
            if (AbstractBaseGraph.this.containsVertex(sourceVertex) && AbstractBaseGraph.this.containsVertex(targetVertex)) {
                DirectedEdgeContainer ec = this.getEdgeContainer(sourceVertex);
                for (Object e : ec.outgoing) {
                    if (!AbstractBaseGraph.this.getEdgeTarget(e).equals(targetVertex)) continue;
                    return e;
                }
            }
            return null;
        }

        @Override
        public void addEdgeToTouchingVertices(E e) {
            Object source = AbstractBaseGraph.this.getEdgeSource(e);
            Object target = AbstractBaseGraph.this.getEdgeTarget(e);
            this.getEdgeContainer(source).addOutgoingEdge(e);
            this.getEdgeContainer(target).addIncomingEdge(e);
        }

        @Override
        public Set<E> edgesOf(V vertex) {
            ArrayUnenforcedSet inAndOut = new ArrayUnenforcedSet(this.getEdgeContainer(vertex).incoming);
            inAndOut.addAll(this.getEdgeContainer(vertex).outgoing);
            if (AbstractBaseGraph.this.allowingLoops) {
                Set loops = this.getAllEdges(vertex, vertex);
                int i = 0;
                while (i < inAndOut.size()) {
                    Object e = inAndOut.get(i);
                    if (loops.contains(e)) {
                        inAndOut.remove(i);
                        loops.remove(e);
                        continue;
                    }
                    ++i;
                }
            }
            return Collections.unmodifiableSet(inAndOut);
        }

        @Override
        public Set<E> incomingEdgesOf(V vertex) {
            return this.getEdgeContainer(vertex).getUnmodifiableIncomingEdges();
        }

        @Override
        public Set<E> outgoingEdgesOf(V vertex) {
            return this.getEdgeContainer(vertex).getUnmodifiableOutgoingEdges();
        }

        @Override
        public void removeEdgeFromTouchingVertices(E e) {
            Object source = AbstractBaseGraph.this.getEdgeSource(e);
            Object target = AbstractBaseGraph.this.getEdgeTarget(e);
            this.getEdgeContainer(source).removeOutgoingEdge(e);
            this.getEdgeContainer(target).removeIncomingEdge(e);
        }

        private DirectedEdgeContainer<V, E> getEdgeContainer(V vertex) {
            AbstractBaseGraph.this.assertVertexExist(vertex);
            DirectedEdgeContainer ec = this.vertexMapDirected.get(vertex);
            if (ec == null) {
                ec = new DirectedEdgeContainer(AbstractBaseGraph.this.edgeSetFactory, vertex);
                this.vertexMapDirected.put((DirectedEdgeContainer)vertex, (DirectedEdgeContainer)ec);
            }
            return ec;
        }
    }

    private abstract class Specifics
    implements Serializable {
        private Specifics() {
        }

        public abstract void addVertex(V var1);

        public abstract Set<V> getVertexSet();

        public abstract Set<E> getAllEdges(V var1, V var2);

        public abstract E getEdge(V var1, V var2);

        public abstract void addEdgeToTouchingVertices(E var1);

        public abstract Set<E> edgesOf(V var1);

        public abstract Set<E> incomingEdgesOf(V var1);

        public abstract Set<E> outgoingEdgesOf(V var1);

        public abstract void removeEdgeFromTouchingVertices(E var1);
    }

    private static class UndirectedEdgeContainer<VV, EE>
    implements Serializable {
        Set<EE> vertexEdges;
        private transient Set<EE> unmodifiableVertexEdges = null;

        UndirectedEdgeContainer(EdgeSetFactory<VV, EE> edgeSetFactory, VV vertex) {
            this.vertexEdges = edgeSetFactory.createEdgeSet(vertex);
        }

        public Set<EE> getUnmodifiableVertexEdges() {
            if (this.unmodifiableVertexEdges == null) {
                this.unmodifiableVertexEdges = Collections.unmodifiableSet(this.vertexEdges);
            }
            return this.unmodifiableVertexEdges;
        }

        public void addEdge(EE e) {
            this.vertexEdges.add(e);
        }

        public void removeEdge(EE e) {
            this.vertexEdges.remove(e);
        }
    }

    private class UndirectedSpecifics
    extends Specifics
    implements Serializable {
        private Map<V, UndirectedEdgeContainer<V, E>> vertexMapUndirected = new LinkedHashMap();

        private UndirectedSpecifics() {
        }

        @Override
        public void addVertex(V v) {
            this.vertexMapUndirected.put(v, null);
        }

        @Override
        public Set<V> getVertexSet() {
            return this.vertexMapUndirected.keySet();
        }

        @Override
        public Set<E> getAllEdges(V sourceVertex, V targetVertex) {
            ArrayUnenforcedSet edges = null;
            if (AbstractBaseGraph.this.containsVertex(sourceVertex) && AbstractBaseGraph.this.containsVertex(targetVertex)) {
                edges = new ArrayUnenforcedSet();
                for (Object e : this.getEdgeContainer(sourceVertex).vertexEdges) {
                    boolean equalInverted;
                    boolean equalStraight = sourceVertex.equals(AbstractBaseGraph.this.getEdgeSource(e)) && targetVertex.equals(AbstractBaseGraph.this.getEdgeTarget(e));
                    boolean bl = equalInverted = sourceVertex.equals(AbstractBaseGraph.this.getEdgeTarget(e)) && targetVertex.equals(AbstractBaseGraph.this.getEdgeSource(e));
                    if (!equalStraight && !equalInverted) continue;
                    edges.add(e);
                }
            }
            return edges;
        }

        @Override
        public E getEdge(V sourceVertex, V targetVertex) {
            if (AbstractBaseGraph.this.containsVertex(sourceVertex) && AbstractBaseGraph.this.containsVertex(targetVertex)) {
                for (Object e : this.getEdgeContainer(sourceVertex).vertexEdges) {
                    boolean equalInverted;
                    boolean equalStraight = sourceVertex.equals(AbstractBaseGraph.this.getEdgeSource(e)) && targetVertex.equals(AbstractBaseGraph.this.getEdgeTarget(e));
                    boolean bl = equalInverted = sourceVertex.equals(AbstractBaseGraph.this.getEdgeTarget(e)) && targetVertex.equals(AbstractBaseGraph.this.getEdgeSource(e));
                    if (!equalStraight && !equalInverted) continue;
                    return e;
                }
            }
            return null;
        }

        @Override
        public void addEdgeToTouchingVertices(E e) {
            Object source = AbstractBaseGraph.this.getEdgeSource(e);
            Object target = AbstractBaseGraph.this.getEdgeTarget(e);
            this.getEdgeContainer(source).addEdge(e);
            if (source != target) {
                this.getEdgeContainer(target).addEdge(e);
            }
        }

        @Override
        public Set<E> edgesOf(V vertex) {
            return this.getEdgeContainer(vertex).getUnmodifiableVertexEdges();
        }

        @Override
        public Set<E> incomingEdgesOf(V vertex) {
            throw new UnsupportedOperationException("no such operation in an undirected graph");
        }

        @Override
        public Set<E> outgoingEdgesOf(V vertex) {
            throw new UnsupportedOperationException("no such operation in an undirected graph");
        }

        @Override
        public void removeEdgeFromTouchingVertices(E e) {
            Object source = AbstractBaseGraph.this.getEdgeSource(e);
            Object target = AbstractBaseGraph.this.getEdgeTarget(e);
            this.getEdgeContainer(source).removeEdge(e);
            if (source != target) {
                this.getEdgeContainer(target).removeEdge(e);
            }
        }

        private UndirectedEdgeContainer<V, E> getEdgeContainer(V vertex) {
            AbstractBaseGraph.this.assertVertexExist(vertex);
            UndirectedEdgeContainer ec = this.vertexMapUndirected.get(vertex);
            if (ec == null) {
                ec = new UndirectedEdgeContainer(AbstractBaseGraph.this.edgeSetFactory, vertex);
                this.vertexMapUndirected.put((UndirectedEdgeContainer)vertex, (UndirectedEdgeContainer)ec);
            }
            return ec;
        }
    }
}

