/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import org.h2.message.DbException;
import org.h2.store.fs.FilePath;
import org.h2.util.IOUtils;
import org.h2.util.New;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils {
    public static boolean exists(String string) {
        return FilePath.get(string).exists();
    }

    public static void createDirectory(String string) {
        FilePath.get(string).createDirectory();
    }

    public static boolean createFile(String string) {
        return FilePath.get(string).createFile();
    }

    public static void delete(String string) {
        FilePath.get(string).delete();
    }

    public static String toRealPath(String string) {
        return FilePath.get(string).toRealPath().toString();
    }

    public static String getParent(String string) {
        FilePath filePath = FilePath.get(string).getParent();
        return filePath == null ? null : filePath.toString();
    }

    public static boolean isAbsolute(String string) {
        return FilePath.get(string).isAbsolute();
    }

    public static void moveTo(String string, String string2) {
        FilePath.get(string).moveTo(FilePath.get(string2));
    }

    public static String getName(String string) {
        return FilePath.get(string).getName();
    }

    public static List<String> newDirectoryStream(String string) {
        List<FilePath> list = FilePath.get(string).newDirectoryStream();
        int n = list.size();
        ArrayList<String> arrayList = New.arrayList(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(list.get(i).toString());
        }
        return arrayList;
    }

    public static long lastModified(String string) {
        return FilePath.get(string).lastModified();
    }

    public static long size(String string) {
        return FilePath.get(string).size();
    }

    public static boolean isDirectory(String string) {
        return FilePath.get(string).isDirectory();
    }

    public static FileChannel open(String string, String string2) throws IOException {
        return FilePath.get(string).open(string2);
    }

    public static InputStream newInputStream(String string) throws IOException {
        return FilePath.get(string).newInputStream();
    }

    public static OutputStream newOutputStream(String string, boolean bl) {
        return FilePath.get(string).newOutputStream(bl);
    }

    public static boolean canWrite(String string) {
        return FilePath.get(string).canWrite();
    }

    public static String unwrap(String string) {
        return FilePath.get(string).unwrap().toString();
    }

    public static void deleteRecursive(String string, boolean bl) {
        if (FileUtils.exists(string)) {
            if (FileUtils.isDirectory(string)) {
                for (String string2 : FileUtils.newDirectoryStream(string)) {
                    FileUtils.deleteRecursive(string2, bl);
                }
            }
            if (bl) {
                FileUtils.tryDelete(string);
            } else {
                FileUtils.delete(string);
            }
        }
    }

    public static void createDirectories(String string) {
        if (string != null) {
            if (FileUtils.exists(string)) {
                if (!FileUtils.isDirectory(string)) {
                    DbException.get(90062, "Could not create directory, because a file with the same name already exists: " + string);
                }
            } else {
                String string2 = FileUtils.getParent(string);
                FileUtils.createDirectories(string2);
                FileUtils.createDirectory(string);
            }
        }
    }

    public static void copy(String string, String string2) throws IOException {
        InputStream inputStream = FileUtils.newInputStream(string);
        OutputStream outputStream = FileUtils.newOutputStream(string2, false);
        IOUtils.copyAndClose(inputStream, outputStream);
    }

    public static boolean tryDelete(String string) {
        try {
            FilePath.get(string).delete();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String createTempFile(String string, String string2, boolean bl, boolean bl2) throws IOException {
        return FilePath.get(string).createTempFile(string2, bl, bl2).toString();
    }

    public static void readFully(FileChannel fileChannel, ByteBuffer byteBuffer) throws IOException {
        do {
            int n;
            if ((n = fileChannel.read(byteBuffer)) >= 0) continue;
            throw new EOFException();
        } while (byteBuffer.remaining() > 0);
    }

    public static void writeFully(FileChannel fileChannel, ByteBuffer byteBuffer) throws IOException {
        do {
            fileChannel.write(byteBuffer);
        } while (byteBuffer.remaining() > 0);
    }
}

