/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jpos.config.JposEntry;
import jpos.config.JposEntryRegistry;
import jpos.config.JposRegPopulator;
import jpos.util.tracing.Tracer;
import jpos.util.tracing.TracerFactory;

public class SimpleEntryRegistry
implements JposEntryRegistry {
    public Hashtable jposEntries = new Hashtable();
    private Vector listeners = new Vector();
    private JposRegPopulator regPopulator = null;
    private boolean loaded = false;
    private Tracer tracer = TracerFactory.getInstance().createTracer("SimpleEntryRegistry");

    public SimpleEntryRegistry() {
    }

    public SimpleEntryRegistry(JposRegPopulator jposRegPopulator) {
        this.regPopulator = jposRegPopulator;
    }

    public Enumeration getEntries() {
        Vector vector = new Vector();
        Enumeration enumeration = this.jposEntries.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector.elements();
    }

    public JposEntry getJposEntry(String string) {
        return (JposEntry)this.jposEntries.get(string);
    }

    public JposRegPopulator getRegPopulator() {
        return this.regPopulator;
    }

    public void load() {
        this.getRegPopulator().load();
        this.jposEntries.clear();
        Enumeration enumeration = this.getRegPopulator().getEntries();
        while (enumeration.hasMoreElements()) {
            try {
                JposEntry jposEntry = (JposEntry)enumeration.nextElement();
                this.jposEntries.put(jposEntry.getPropertyValue("logicalName"), jposEntry);
            }
            catch (Exception exception) {
                this.tracer.print(exception);
            }
        }
        this.loaded = true;
    }

    public int getSize() {
        return this.jposEntries.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<SimpleEntryRegistry>\n");
        stringBuffer.append("<size=\"" + this.getSize() + "\"\n/>");
        stringBuffer.append("<populatorUniqueId=\"" + this.getRegPopulator().getUniqueId() + "\"\n/>");
        stringBuffer.append("numberOfListeners=\"" + this.listeners.size() + "\"\n/>");
        stringBuffer.append("<entries>\n");
        Enumeration enumeration = this.getEntries();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("<entry" + n + ".LogicalName=\"" + ((JposEntry)enumeration.nextElement()).getLogicalName() + "\"\n/>");
            ++n;
        }
        stringBuffer.append("</entries>\n");
        stringBuffer.append("</SimpleEntryRegistry>\n");
        return stringBuffer.toString();
    }
}

