/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesCluster;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.RecursionType;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.ITransformer;

public final class TreesOfSQLRows {
    private final SQLElement elem;
    private final Map<SQLRow, SQLRowValues> trees;
    private CollectionMap<SQLField, SQLRow> externReferences;

    private static String createRestrictDesc(SQLElement refElem, SQLRowAccessor refVals, Link fk) {
        String rowDesc = refElem != null ? refElem.getDescription(refVals.asRow()) : refVals.asRow().toString();
        String fieldLabel = Configuration.getTranslator((SQLTable)fk.getSource()).getLabelFor(fk.getLabel());
        String fieldS = fieldLabel != null ? fieldLabel : fk.getLabel().getName();
        return String.valueOf(rowDesc) + " ne peut perdre son champ " + fieldS;
    }

    public TreesOfSQLRows(SQLElement elem, SQLRow row) {
        this(elem, Collections.singleton(row));
    }

    public TreesOfSQLRows(SQLElement elem, Collection<SQLRow> rows) {
        this.elem = elem;
        this.trees = new HashMap<SQLRow, SQLRowValues>(rows.size());
        for (SQLRow r : rows) {
            this.elem.check(r);
            this.trees.put(r, null);
        }
        this.externReferences = null;
    }

    public final SQLElement getElem() {
        return this.elem;
    }

    public final Set<SQLRow> getRows() {
        return this.trees.keySet();
    }

    public final Set<SQLRowValues> getTrees() throws SQLException {
        HashSet<SQLRowValues> res = new HashSet<SQLRowValues>();
        for (SQLRow r : this.getRows()) {
            res.add(this.getTree(r));
        }
        return res;
    }

    private final SQLRowValues getTree(SQLRow r) throws SQLException {
        if (!this.trees.containsKey(r)) {
            throw new IllegalArgumentException();
        }
        SQLRowValues res = this.trees.get(r);
        if (res == null) {
            Tuple2<SQLRowValues, CollectionMap<SQLField, SQLRow>> expand = this.expand(r);
            res = expand.get0();
            this.trees.put(r, res);
            if (this.externReferences == null) {
                this.externReferences = expand.get1();
            } else {
                this.externReferences.merge(expand.get1());
            }
        }
        return res;
    }

    private final Tuple2<SQLRowValues, CollectionMap<SQLField, SQLRow>> expand(SQLRow r) throws SQLException {
        SQLRowValues vals = r.createUpdateRow();
        HashSet<SQLRow> hasBeen = new HashSet<SQLRow>();
        hasBeen.add(r);
        CollectionMap<SQLField, SQLRow> toCut = new CollectionMap<SQLField, SQLRow>(new HashSet());
        this.expand(vals.getTable(), Collections.singletonMap(vals.getID(), vals), hasBeen, toCut);
        return Tuple2.create(vals, toCut);
    }

    private final void expand(SQLTable t, final Map<Integer, SQLRowValues> valsMap, Set<SQLRow> hasBeen, CollectionMap<SQLField, SQLRow> toCut) throws SQLException {
        if (valsMap.size() == 0) {
            return;
        }
        for (final Link link : t.getDBSystemRoot().getGraph().getReferentLinks(t)) {
            SQLElement.ReferenceAction action;
            String ffName = link.getLabel().getName();
            SQLElement refElem = this.elem.getElementLenient((SQLTable)link.getSource());
            SQLElement.ReferenceAction referenceAction = action = refElem != null ? refElem.getActions().get(ffName) : SQLElement.ReferenceAction.RESTRICT;
            if (action == null) {
                throw new IllegalStateException("Null action for " + refElem + " " + ffName);
            }
            HashMap<Integer, SQLRowValues> next = new HashMap<Integer, SQLRowValues>();
            SQLRowValuesListFetcher fetcher = new SQLRowValuesListFetcher(new SQLRowValues((SQLTable)link.getSource()).put(ffName, null));
            fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

                @Override
                public SQLSelect transformChecked(SQLSelect input) {
                    return input.andWhere(new Where(link.getLabel(), valsMap.keySet()));
                }
            });
            for (SQLRowValues newVals : fetcher.fetch()) {
                SQLRow r = newVals.asRow();
                switch (action) {
                    case RESTRICT: {
                        throw new SQLException(TreesOfSQLRows.createRestrictDesc(refElem, newVals, link));
                    }
                    case CASCADE: {
                        if (hasBeen.contains(r)) break;
                        newVals.put(ffName, valsMap.get(newVals.getInt(ffName)));
                        hasBeen.add(r);
                        next.put(newVals.getID(), newVals);
                        break;
                    }
                    case SET_EMPTY: {
                        if (hasBeen.contains(r)) break;
                        toCut.put((Object)link.getLabel(), (Object)r);
                    }
                }
            }
            this.expand(fetcher.getGraph().getTable(), next, hasBeen, toCut);
        }
        Iterator<Map.Entry<SQLField, Collection<SQLRow>>> iter = toCut.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<SQLField, Collection<SQLRow>> e = iter.next();
            e.getValue().removeAll(hasBeen);
            if (!e.getValue().isEmpty()) continue;
            iter.remove();
        }
    }

    public final List<SQLRowAccessor> getFlatDescendants() throws SQLException {
        final ArrayList<SQLRowAccessor> res = new ArrayList<SQLRowAccessor>();
        for (SQLRowValues graph : this.getTrees()) {
            graph.getGraph().walk(graph, null, new ITransformer<SQLRowValuesCluster.State<Object>, Object>(){

                @Override
                public Object transformChecked(SQLRowValuesCluster.State<Object> input) {
                    res.add(input.getCurrent());
                    return null;
                }
            }, RecursionType.DEPTH_FIRST, false);
        }
        return res;
    }

    public final CollectionMap<SQLField, SQLRow> getExternReferences() throws SQLException {
        this.getTrees();
        return this.externReferences;
    }
}

