/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import org.h2.constant.SysProperties;
import org.h2.message.DbException;
import org.h2.store.fs.FileDisk;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.New;
import org.h2.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilePathDisk
extends FilePath {
    @Override
    public FilePathDisk getPath(String string) {
        FilePathDisk filePathDisk = new FilePathDisk();
        filePathDisk.name = FilePathDisk.translateFileName(string);
        return filePathDisk;
    }

    @Override
    public long size() {
        return new File(this.name).length();
    }

    protected static String translateFileName(String string) {
        if ((string = string.replace('\\', '/')).startsWith("file:")) {
            string = string.substring("file:".length());
        }
        return FilePathDisk.expandUserHomeDirectory(string);
    }

    public static String expandUserHomeDirectory(String string) {
        if (string.startsWith("~") && (string.length() == 1 || string.startsWith("~/"))) {
            String string2 = SysProperties.USER_HOME;
            string = string2 + string.substring(1);
        }
        return string;
    }

    @Override
    public void moveTo(FilePath filePath) {
        File file = new File(this.name);
        File file2 = new File(filePath.name);
        if (file.getAbsolutePath().equals(file2.getAbsolutePath())) {
            return;
        }
        if (!file.exists()) {
            throw DbException.get(90024, this.name + " (not found)", filePath.name);
        }
        if (file2.exists()) {
            throw DbException.get(90024, this.name, filePath + " (exists)");
        }
        for (int i = 0; i < SysProperties.MAX_FILE_RETRY; ++i) {
            IOUtils.trace("rename", this.name + " >" + filePath, null);
            boolean bl = file.renameTo(file2);
            if (bl) {
                return;
            }
            FilePathDisk.wait(i);
        }
        throw DbException.get(90024, this.name, filePath.name);
    }

    private static void wait(int n) {
        if (n == 8) {
            System.gc();
        }
        try {
            long l = Math.min(256, n * n);
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public boolean createFile() {
        File file = new File(this.name);
        for (int i = 0; i < SysProperties.MAX_FILE_RETRY; ++i) {
            try {
                return file.createNewFile();
            }
            catch (IOException iOException) {
                FilePathDisk.wait(i);
                continue;
            }
        }
        return false;
    }

    @Override
    public boolean exists() {
        return new File(this.name).exists();
    }

    @Override
    public void delete() {
        File file = new File(this.name);
        for (int i = 0; i < SysProperties.MAX_FILE_RETRY; ++i) {
            IOUtils.trace("delete", this.name, null);
            boolean bl = file.delete();
            if (bl || !file.exists()) {
                return;
            }
            FilePathDisk.wait(i);
        }
        throw DbException.get(90025, this.name);
    }

    @Override
    public List<FilePath> newDirectoryStream() {
        ArrayList<FilePath> arrayList = New.arrayList();
        File file = new File(this.name);
        try {
            String[] stringArray = file.list();
            if (stringArray != null) {
                String string = file.getCanonicalPath();
                if (!string.endsWith(SysProperties.FILE_SEPARATOR)) {
                    string = string + SysProperties.FILE_SEPARATOR;
                }
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    arrayList.add(this.getPath(string + stringArray[i]));
                }
            }
            return arrayList;
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.name);
        }
    }

    @Override
    public boolean canWrite() {
        return FilePathDisk.canWriteInternal(new File(this.name));
    }

    @Override
    public FilePathDisk toRealPath() {
        try {
            String string = new File(this.name).getCanonicalPath();
            return this.getPath(string);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.name);
        }
    }

    @Override
    public FilePath getParent() {
        String string = new File(this.name).getParent();
        return string == null ? null : this.getPath(string);
    }

    @Override
    public boolean isDirectory() {
        return new File(this.name).isDirectory();
    }

    @Override
    public boolean isAbsolute() {
        return new File(this.name).isAbsolute();
    }

    @Override
    public long lastModified() {
        return new File(this.name).lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canWriteInternal(File file) {
        try {
            if (!file.canWrite()) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void createDirectory() {
        File file = new File(this.name);
        if (file.exists()) {
            if (file.isDirectory()) {
                return;
            }
            throw DbException.get(90062, this.name + " (a file with this name already exists)");
        }
        File file2 = new File(this.name);
        for (int i = 0; i < SysProperties.MAX_FILE_RETRY; ++i) {
            if (file2.exists() && file2.isDirectory() || file2.mkdir()) {
                return;
            }
            FilePathDisk.wait(i);
        }
        throw DbException.get(90062, this.name);
    }

    @Override
    public OutputStream newOutputStream(boolean bl) {
        try {
            File file = new File(this.name);
            File file2 = file.getParentFile();
            if (file2 != null) {
                FileUtils.createDirectories(file2.getAbsolutePath());
            }
            FileOutputStream fileOutputStream = new FileOutputStream(this.name, bl);
            IOUtils.trace("openFileOutputStream", this.name, fileOutputStream);
            return fileOutputStream;
        }
        catch (IOException iOException) {
            FilePathDisk.freeMemoryAndFinalize();
            try {
                return new FileOutputStream(this.name);
            }
            catch (IOException iOException2) {
                throw DbException.convertIOException(iOException, this.name);
            }
        }
    }

    @Override
    public InputStream newInputStream() throws IOException {
        int n = this.name.indexOf(58);
        if (n > 1 && n < 20) {
            if (this.name.startsWith("classpath:")) {
                InputStream inputStream;
                String string = this.name.substring("classpath:".length());
                if (!string.startsWith("/")) {
                    string = "/" + string;
                }
                if ((inputStream = this.getClass().getResourceAsStream(string)) == null) {
                    inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
                }
                if (inputStream == null) {
                    throw new FileNotFoundException("resource " + string);
                }
                return inputStream;
            }
            URL uRL = new URL(this.name);
            InputStream inputStream = uRL.openStream();
            return inputStream;
        }
        FileInputStream fileInputStream = new FileInputStream(this.name);
        IOUtils.trace("openFileInputStream", this.name, fileInputStream);
        return fileInputStream;
    }

    static void freeMemoryAndFinalize() {
        IOUtils.trace("freeMemoryAndFinalize", null, null);
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.freeMemory();
        for (int i = 0; i < 16; ++i) {
            runtime.gc();
            long l2 = runtime.freeMemory();
            runtime.runFinalization();
            if (l2 == l) break;
            l = l2;
        }
    }

    @Override
    public FileChannel open(String string) throws IOException {
        FileDisk fileDisk;
        try {
            fileDisk = new FileDisk(this.name, string);
            IOUtils.trace("open", this.name, fileDisk);
        }
        catch (IOException iOException) {
            FilePathDisk.freeMemoryAndFinalize();
            try {
                fileDisk = new FileDisk(this.name, string);
            }
            catch (IOException iOException2) {
                throw iOException;
            }
        }
        return fileDisk;
    }

    @Override
    public String getScheme() {
        return "file";
    }

    @Override
    public FilePath createTempFile(String string, boolean bl, boolean bl2) throws IOException {
        File file;
        String string2 = this.name + ".";
        String string3 = new File(string2).getName();
        File file2 = bl2 ? new File(Utils.getProperty("java.io.tmpdir", ".")) : new File(string2).getAbsoluteFile().getParentFile();
        FileUtils.createDirectories(file2.getAbsolutePath());
        while ((file = new File(file2, string3 + FilePathDisk.getNextTempFileNamePart(false) + string)).exists() || !file.createNewFile()) {
            FilePathDisk.getNextTempFileNamePart(true);
        }
        if (bl) {
            try {
                file.deleteOnExit();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return FilePathDisk.get(file.getCanonicalPath());
    }
}

