/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.h2.store.fs.FilePathDisk;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FilePath {
    private static final FilePath DEFAULT = new FilePathDisk();
    private static Map<String, FilePath> providers;
    private static String tempRandom;
    private static long tempSequence;
    protected String name;

    public static FilePath get(String string) {
        int n = (string = string.replace('\\', '/')).indexOf(58);
        if (n < 2) {
            return DEFAULT.getPath(string);
        }
        String string2 = string.substring(0, n);
        FilePath.registerDefaultProviders();
        FilePath filePath = providers.get(string2);
        if (filePath == null) {
            filePath = DEFAULT;
        }
        return filePath.getPath(string);
    }

    private static void registerDefaultProviders() {
        if (providers == null) {
            Map<String, FilePath> map = Collections.synchronizedMap(New.hashMap());
            for (String string : new String[]{"org.h2.store.fs.FilePathMem", "org.h2.store.fs.FilePathMemLZF", "org.h2.store.fs.FilePathSplit", "org.h2.store.fs.FilePathNio", "org.h2.store.fs.FilePathNioMapped", "org.h2.store.fs.FilePathZip"}) {
                try {
                    FilePath filePath = (FilePath)Class.forName(string).newInstance();
                    map.put(filePath.getScheme(), filePath);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            providers = map;
        }
    }

    public static void register(FilePath filePath) {
        FilePath.registerDefaultProviders();
        providers.put(filePath.getScheme(), filePath);
    }

    public abstract long size();

    public abstract void moveTo(FilePath var1);

    public abstract boolean createFile();

    public abstract boolean exists();

    public abstract void delete();

    public abstract List<FilePath> newDirectoryStream();

    public abstract FilePath toRealPath();

    public abstract FilePath getParent();

    public abstract boolean isDirectory();

    public abstract boolean isAbsolute();

    public abstract long lastModified();

    public abstract boolean canWrite();

    public abstract void createDirectory();

    public String getName() {
        int n = Math.max(this.name.indexOf(58), this.name.lastIndexOf(47));
        return n < 0 ? this.name : this.name.substring(n + 1);
    }

    public abstract OutputStream newOutputStream(boolean var1);

    public abstract FileChannel open(String var1) throws IOException;

    public abstract InputStream newInputStream() throws IOException;

    public FilePath createTempFile(String string, boolean bl, boolean bl2) throws IOException {
        FilePath filePath;
        while ((filePath = this.getPath(this.name + FilePath.getNextTempFileNamePart(false) + string)).exists() || !filePath.createFile()) {
            FilePath.getNextTempFileNamePart(true);
        }
        filePath.open("rw").close();
        return filePath;
    }

    protected static synchronized String getNextTempFileNamePart(boolean bl) {
        if (bl || tempRandom == null) {
            byte[] byArray = new byte[8];
            MathUtils.randomBytes(byArray);
            tempRandom = StringUtils.convertBytesToHex(byArray) + ".";
        }
        return tempRandom + tempSequence++;
    }

    public String toString() {
        return this.name;
    }

    public abstract String getScheme();

    public abstract FilePath getPath(String var1);

    public FilePath unwrap() {
        return this;
    }
}

