/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.valuewrapper.format;

import javax.swing.JComponent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import org.openconcerto.ui.component.text.TextComponentUtils;
import org.openconcerto.ui.filters.FormatFilter;
import org.openconcerto.ui.valuewrapper.BaseValueWrapper;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.ui.valuewrapper.format.FilterFormatValueWrapper;
import org.openconcerto.ui.valuewrapper.format.VWFormatValueWrapper;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.checks.ValidChangeSupport;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidObject;
import org.openconcerto.utils.checks.ValidObjectCombiner;
import org.openconcerto.utils.checks.ValidState;
import org.openconcerto.utils.convertor.NumberConvertor;
import org.openconcerto.utils.convertor.ValueConvertor;
import org.openconcerto.utils.convertor.ValueConvertorFactory;

public abstract class FormatValueWrapper<T>
extends BaseValueWrapper<T> {
    private final JComponent comp;
    private final FilterAndConvertor<? super T, T> formatFilter;
    private final ValidChangeSupport selfValidSupp;
    private final ValidObjectCombiner comb;
    private T value;

    public static <Z> FormatValueWrapper<Z> create(JComponent o, Class<Z> c) {
        Document doc = TextComponentUtils.getDocument(o);
        if (doc != null) {
            return new FilterFormatValueWrapper<Z>(o, (AbstractDocument)doc, c);
        }
        if (o instanceof ValueWrapper) {
            return new VWFormatValueWrapper<Z>((ValueWrapper)((Object)o), c);
        }
        throw new IllegalArgumentException("" + o);
    }

    private static boolean isNull(String text) {
        return text == null || text.length() == 0;
    }

    protected FormatValueWrapper(JComponent b, FormatFilter<? super T> f, Class<T> clazz) {
        ValidChangeSupport validSupp;
        this.comp = b;
        this.formatFilter = FilterAndConvertor.create(f, clazz);
        this.selfValidSupp = validSupp = new ValidChangeSupport(this);
        this.comb = ValidObjectCombiner.create(this, this.comp, new ValidObject(){

            @Override
            public void addValidListener(ValidListener l) {
                validSupp.addValidListener(l);
            }

            @Override
            public ValidState getValidState() {
                return validSupp.getValidState();
            }
        });
        this.comb.addValidListener(new ValidListener(){

            @Override
            public void validChange(ValidObject src, ValidState newValue) {
                FormatValueWrapper.this.supp.fireValidChange();
            }
        });
    }

    protected final void textChanged() {
        Tuple2<ValidState, T> newState = this.formatFilter.parseText(this.getText());
        this.selfValidSupp.fireValidChange(newState.get0());
        this.setSelfValue(newState.get1());
    }

    private final void setSelfValue(T val) {
        if (!CompareUtils.equals(this.value, val)) {
            this.value = val;
            this.supp.fireValueChange();
        }
    }

    @Override
    public final JComponent getComp() {
        return this.comp;
    }

    @Override
    public final T getValue() {
        return this.value;
    }

    @Override
    public final void setValue(T val) {
        this.setText(val == null ? "" : this.formatFilter.getFormatFilter().format(val));
    }

    protected abstract String getText();

    protected abstract void setText(String var1);

    @Override
    public ValidState getValidState() {
        return this.comb.getValidState();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " on " + this.getComp();
    }

    private static class FilterAndConvertor<F, T extends F> {
        private final Class<T> valueClass;
        private final FormatFilter<F> formatFilter;
        private final ValueConvertor<F, T> convertor;

        public static <U, T extends U> FilterAndConvertor<U, T> create(FormatFilter<U> formatFilter, Class<T> clazz) {
            return new FilterAndConvertor<U, T>(formatFilter, clazz);
        }

        public FilterAndConvertor(FormatFilter<F> formatFilter, Class<T> clazz) {
            this.valueClass = clazz;
            this.formatFilter = formatFilter;
            this.convertor = ValueConvertorFactory.find(formatFilter.getValueClass(), clazz);
            if (this.convertor == null) {
                throw new IllegalArgumentException("No convertor found between " + clazz + " and " + formatFilter.getValueClass());
            }
        }

        public final Class<T> getValueClass() {
            return this.valueClass;
        }

        public final FormatFilter<F> getFormatFilter() {
            return this.formatFilter;
        }

        public final Tuple2<ValidState, T> parseText(String text) {
            Object newValue;
            ValidState newState;
            if (FormatValueWrapper.isNull(text)) {
                newState = ValidState.getTrueInstance();
                newValue = null;
            } else {
                Tuple2<Boolean, F> res = this.getFormatFilter().parse(text);
                if (!res.get0().booleanValue()) {
                    newState = ValidState.create(false, this.getFormatFilter().getValidationText(text));
                    newValue = null;
                } else {
                    try {
                        newValue = this.convertor.convert(res.get1());
                        newState = ValidState.getTrueInstance();
                    }
                    catch (Exception e) {
                        String msg;
                        if (e instanceof NumberConvertor.OverflowException) {
                            msg = "Nombre trop grand";
                        } else if (e instanceof NumberConvertor.RoundingException) {
                            msg = "Entier attendu";
                        } else if (e instanceof ClassCastException) {
                            msg = "Mauvais type, attendu " + this.getValueClass();
                        } else {
                            e.printStackTrace();
                            msg = e.getLocalizedMessage();
                        }
                        newValue = null;
                        newState = ValidState.create(false, msg);
                    }
                }
            }
            return Tuple2.create(newState, newValue);
        }
    }
}

