/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.state;

import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import org.openconcerto.ui.ScreenUtils;
import org.openconcerto.ui.state.ListenerXMLStateManager;
import org.openconcerto.utils.ExceptionHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WindowStateManager
extends ListenerXMLStateManager<Window, WindowListener> {
    public WindowStateManager(Window w, File f) {
        this(w, f, true);
    }

    public WindowStateManager(Window w, File f, boolean autosave) {
        super(w, f, autosave);
    }

    @Override
    protected void addListener(WindowListener l) {
        ((Window)this.getSrc()).addWindowListener(l);
    }

    @Override
    protected WindowListener createListener() {
        return new WindowAdapter(){
            private WindowEvent evt = null;

            @Override
            public void windowClosed(WindowEvent e) {
                if (e != this.evt) {
                    WindowStateManager.this.save();
                }
            }

            @Override
            public void windowClosing(WindowEvent e) {
                WindowStateManager.this.save();
                this.evt = e;
            }
        };
    }

    @Override
    protected void rmListener(WindowListener l) {
        ((Window)this.getSrc()).removeWindowListener(l);
    }

    protected final void save() {
        try {
            this.saveState();
        }
        catch (IOException exn) {
            ExceptionHandler.handle(((Window)this.getSrc()).isDisplayable() ? (Window)this.getSrc() : null, "Impossible de sauvegarder la position de la fen\u00eatre.", exn);
        }
    }

    @Override
    protected void writeState(BufferedWriter out) throws IOException {
        out.write("<window>\n");
        out.write("<size");
        out.write(" width=\"" + ((Window)this.getSrc()).getSize().width + "\"");
        out.write(" height=\"" + ((Window)this.getSrc()).getSize().height + "\"");
        out.write("/>\n");
        out.write("<location");
        out.write(" x=\"" + ((Window)this.getSrc()).getLocation().x + "\"");
        out.write(" y=\"" + ((Window)this.getSrc()).getLocation().y + "\"");
        out.write("/>\n");
        out.write("</window>\n");
    }

    @Override
    protected boolean readState(Document doc) {
        Rectangle desiredBounds = this.getBounds(doc);
        Rectangle virtualBounds = ScreenUtils.getDisplayBounds();
        if (!virtualBounds.intersects(desiredBounds)) {
            desiredBounds.setLocation(0, 0);
            Rectangle maxWindowBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
            desiredBounds.setBounds(desiredBounds.intersection(maxWindowBounds));
        }
        ((Window)this.getSrc()).setBounds(desiredBounds);
        return true;
    }

    private Rectangle getBounds(Document doc) {
        Node size = doc.getElementsByTagName("size").item(0);
        String sWidth = size.getAttributes().getNamedItem("width").getNodeValue();
        int width = Math.max(Integer.parseInt(sWidth), 50);
        String sHeight = size.getAttributes().getNamedItem("height").getNodeValue();
        int height = Math.max(Integer.parseInt(sHeight), 50);
        Node location = doc.getElementsByTagName("location").item(0);
        String sX = location.getAttributes().getNamedItem("x").getNodeValue();
        String sY = location.getAttributes().getNamedItem("y").getNodeValue();
        return new Rectangle(Integer.parseInt(sX), Integer.parseInt(sY), width, height);
    }
}

