/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.state;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.openconcerto.ui.Log;
import org.openconcerto.ui.state.ListenerXMLStateManager;
import org.openconcerto.ui.table.XTableColumnModel;
import org.openconcerto.utils.ExceptionHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JTableStateManager
extends ListenerXMLStateManager<JTable, AncestorListener> {
    public JTableStateManager(JTable table) {
        this(table, null);
    }

    public JTableStateManager(JTable table, File f) {
        this(table, f, f != null);
    }

    public JTableStateManager(JTable table, File f, boolean autosave) {
        super(table, f, autosave);
    }

    @Override
    protected AncestorListener createListener() {
        return new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                try {
                    JTableStateManager.this.saveState();
                }
                catch (IOException e) {
                    ExceptionHandler.handle((Component)JTableStateManager.this.getSrc(), "Impossible de sauvegarder la taille des colonnes", e);
                }
            }
        };
    }

    @Override
    protected void addListener(AncestorListener l) {
        ((JTable)this.getSrc()).addAncestorListener(l);
    }

    @Override
    protected void rmListener(AncestorListener l) {
        ((JTable)this.getSrc()).removeAncestorListener(l);
    }

    @Override
    protected void writeState(File out) throws IOException {
        DocumentBuilder builder;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Couldn't create builder", e);
        }
        Document doc = builder.newDocument();
        Element elem = doc.createElement("liste");
        elem.setAttribute("version", "20100810");
        doc.appendChild(elem);
        TableColumnModel model = ((JTable)this.getSrc()).getColumnModel();
        if (model instanceof XTableColumnModel) {
            XTableColumnModel visibilityModel = (XTableColumnModel)model;
            for (TableColumn col : visibilityModel.getColumns(false)) {
                this.writeCol(elem, col).setAttribute("visible", String.valueOf(visibilityModel.isColumnVisible(col)));
            }
        } else {
            int nCol = ((JTable)this.getSrc()).getColumnCount();
            int i = 0;
            while (i < nCol) {
                TableColumn col = model.getColumn(i);
                this.writeCol(elem, col);
                ++i;
            }
        }
        TransformerFactory tFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = tFactory.newTransformer();
            transformer.transform(new DOMSource(elem), new StreamResult(out));
        }
        catch (TransformerException e) {
            throw new IOException("Couldn't output " + doc, e);
        }
    }

    private Element writeCol(Element elem, TableColumn col) {
        Element res = elem.getOwnerDocument().createElement("col");
        elem.appendChild(res);
        int min = col.getMinWidth();
        int max = col.getMaxWidth();
        int width = col.getWidth();
        res.setAttribute("min", String.valueOf(min));
        res.setAttribute("max", String.valueOf(max));
        res.setAttribute("width", String.valueOf(width));
        res.setAttribute("identifier", String.valueOf(col.getIdentifier()));
        res.setAttribute("modelIndex", String.valueOf(col.getModelIndex()));
        return res;
    }

    @Override
    protected boolean readState(Document doc) {
        NodeList listOfCol = doc.getElementsByTagName("col");
        TableColumnModel model = ((JTable)this.getSrc()).getColumnModel();
        XTableColumnModel visibilityModel = model instanceof XTableColumnModel ? (XTableColumnModel)model : null;
        List<TableColumn> uiCols = visibilityModel != null ? visibilityModel.getColumns(false) : Collections.list(model.getColumns());
        int modelColsCount = uiCols.size();
        int colsCount = listOfCol.getLength();
        String docVersion = doc.getDocumentElement().getAttribute("version");
        if (!"20100810".equals(docVersion)) {
            Log.get().info("wrong version :" + docVersion + " != " + "20100810");
        } else if (modelColsCount != colsCount) {
            Log.get().info("saved cols :" + colsCount + " != actual cols: " + modelColsCount);
        } else if (!this.checkIdentifiers(listOfCol, uiCols)) {
            Log.get().info("column identifiers differ");
        } else {
            if (visibilityModel != null) {
                int i = 0;
                while (i < colsCount) {
                    visibilityModel.setColumnVisible(visibilityModel.getColumn(i, false), true);
                    ++i;
                }
            }
            ArrayList<TableColumn> invisibleCols = new ArrayList<TableColumn>();
            int i = 0;
            while (i < colsCount) {
                NamedNodeMap attrs = listOfCol.item(i).getAttributes();
                int modelIndex = Integer.parseInt(attrs.getNamedItem("modelIndex").getNodeValue());
                model.moveColumn(((JTable)this.getSrc()).convertColumnIndexToView(modelIndex), i);
                TableColumn modelCol = model.getColumn(i);
                String smin = attrs.getNamedItem("min").getNodeValue();
                int min = Integer.parseInt(smin);
                if (min < 10) {
                    min = 10;
                }
                modelCol.setMinWidth(min);
                String smax = attrs.getNamedItem("max").getNodeValue();
                int max = Integer.parseInt(smax);
                modelCol.setMaxWidth(max);
                String ssize = attrs.getNamedItem("width").getNodeValue();
                int size = Integer.parseInt(ssize);
                if (size < 10) {
                    size = 15;
                }
                modelCol.setWidth(size);
                modelCol.setPreferredWidth(size);
                Node visible = attrs.getNamedItem("visible");
                if (visible != null && !Boolean.parseBoolean(visible.getNodeValue())) {
                    invisibleCols.add(modelCol);
                }
                ++i;
            }
            if (visibilityModel != null) {
                for (TableColumn toRm : invisibleCols) {
                    visibilityModel.setColumnVisible(toRm, false);
                }
            }
            return true;
        }
        return false;
    }

    private boolean checkIdentifiers(NodeList listOfCol, List<TableColumn> uiCols) {
        int colsCount = listOfCol.getLength();
        int i = 0;
        while (i < colsCount) {
            NamedNodeMap attrs = listOfCol.item(i).getAttributes();
            int modelIndex = Integer.parseInt(attrs.getNamedItem("modelIndex").getNodeValue());
            String xmlID = attrs.getNamedItem("identifier").getNodeValue();
            String uiID = String.valueOf(uiCols.get(modelIndex).getIdentifier());
            if (!uiID.equals(xmlID)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

