/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.Color;
import java.text.Format;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.text.JTextComponent;
import org.openconcerto.utils.FormatGroup;

public class FormatEditor
extends DefaultCellEditor {
    public FormatEditor(Format ... formats) {
        this(Arrays.asList(formats));
    }

    public FormatEditor(List<? extends Format> formats) {
        this(new FormatGroup(formats));
    }

    public FormatEditor(final FormatGroup formats) {
        super(new JTextField());
        this.delegate = new DefaultCellEditor.EditorDelegate(this){

            @Override
            public void setValue(Object newVal) {
                String txt = newVal == null ? "" : formats.format(newVal);
                ((JTextComponent)FormatEditor.this.getComponent()).setText(txt);
                ((JComponent)FormatEditor.this.getComponent()).setBorder(new LineBorder(Color.BLACK));
                super.setValue(newVal);
            }

            @Override
            public boolean stopCellEditing() {
                String s = ((JTextComponent)FormatEditor.this.getComponent()).getText();
                if (s.length() > 0) {
                    try {
                        this.value = formats.parseObject(s);
                    }
                    catch (ParseException e) {
                        ((JComponent)FormatEditor.this.getComponent()).setBorder(new LineBorder(Color.RED));
                        return false;
                    }
                    catch (Exception e) {
                        ((JComponent)FormatEditor.this.getComponent()).setBorder(new LineBorder(Color.YELLOW));
                        return false;
                    }
                } else {
                    this.value = null;
                }
                return super.stopCellEditing();
            }
        };
    }
}

