/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class EnhancedTableColumn
extends TableColumn {
    boolean blockEvent = false;
    protected int modelIndex;
    protected Object identifier;
    protected int width;
    protected int minWidth;
    private int preferredWidth;
    protected int maxWidth;
    protected TableCellRenderer headerRenderer;
    protected Object headerValue;
    protected TableCellRenderer cellRenderer;
    protected TableCellEditor cellEditor;
    protected boolean isResizable;
    protected transient int resizedPostingDisableCount;
    private SwingPropertyChangeSupport changeSupport;

    public void setBlockEvent(boolean blockEvent) {
        this.blockEvent = blockEvent;
    }

    public EnhancedTableColumn() {
        this(0);
    }

    public EnhancedTableColumn(int modelIndex) {
        this(modelIndex, 75, null, null);
    }

    public EnhancedTableColumn(int modelIndex, int width) {
        this(modelIndex, width, null, null);
    }

    public EnhancedTableColumn(int modelIndex, int width, TableCellRenderer cellRenderer, TableCellEditor cellEditor) {
        this.modelIndex = modelIndex;
        this.width = width;
        this.preferredWidth = width;
        this.cellRenderer = cellRenderer;
        this.cellEditor = cellEditor;
        this.minWidth = 15;
        this.maxWidth = Integer.MAX_VALUE;
        this.isResizable = true;
        this.resizedPostingDisableCount = 0;
        this.headerValue = null;
    }

    private void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport != null && !this.blockEvent) {
            this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    private void firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (oldValue != newValue) {
            this.firePropertyChange(propertyName, new Integer(oldValue), new Integer(newValue));
        }
    }

    private void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (oldValue != newValue) {
            this.firePropertyChange(propertyName, (Object)oldValue, (Object)newValue);
        }
    }

    @Override
    public void setModelIndex(int modelIndex) {
        int old = this.modelIndex;
        this.modelIndex = modelIndex;
        this.firePropertyChange("modelIndex", old, modelIndex);
    }

    @Override
    public int getModelIndex() {
        return this.modelIndex;
    }

    @Override
    public void setIdentifier(Object identifier) {
        Object old = this.identifier;
        this.identifier = identifier;
        this.firePropertyChange("identifier", old, identifier);
    }

    @Override
    public Object getIdentifier() {
        return this.identifier != null ? this.identifier : this.getHeaderValue();
    }

    @Override
    public void setHeaderValue(Object headerValue) {
        Object old = this.headerValue;
        this.headerValue = headerValue;
        this.firePropertyChange("headerValue", old, headerValue);
    }

    @Override
    public Object getHeaderValue() {
        return this.headerValue;
    }

    @Override
    public void setHeaderRenderer(TableCellRenderer headerRenderer) {
        TableCellRenderer old = this.headerRenderer;
        this.headerRenderer = headerRenderer;
        this.firePropertyChange("headerRenderer", old, headerRenderer);
    }

    @Override
    public TableCellRenderer getHeaderRenderer() {
        return this.headerRenderer;
    }

    @Override
    public void setCellRenderer(TableCellRenderer cellRenderer) {
        TableCellRenderer old = this.cellRenderer;
        this.cellRenderer = cellRenderer;
        this.firePropertyChange("cellRenderer", old, cellRenderer);
    }

    @Override
    public TableCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    @Override
    public void setCellEditor(TableCellEditor cellEditor) {
        TableCellEditor old = this.cellEditor;
        this.cellEditor = cellEditor;
        this.firePropertyChange("cellEditor", old, cellEditor);
    }

    @Override
    public TableCellEditor getCellEditor() {
        return this.cellEditor;
    }

    @Override
    public void setWidth(int width) {
        int old = this.width;
        this.width = Math.min(Math.max(width, this.minWidth), this.maxWidth);
        this.firePropertyChange("width", old, this.width);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setPreferredWidth(int preferredWidth) {
        int old = this.preferredWidth;
        this.preferredWidth = Math.min(Math.max(preferredWidth, this.minWidth), this.maxWidth);
        this.firePropertyChange("preferredWidth", old, this.preferredWidth);
    }

    @Override
    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    @Override
    public void setMinWidth(int minWidth) {
        int old = this.minWidth;
        this.minWidth = Math.max(minWidth, 0);
        if (this.width < minWidth) {
            this.setWidth(minWidth);
        }
        if (this.preferredWidth < minWidth) {
            this.setPreferredWidth(minWidth);
        }
        this.firePropertyChange("minWidth", old, this.minWidth);
    }

    @Override
    public int getMinWidth() {
        return this.minWidth;
    }

    @Override
    public void setMaxWidth(int maxWidth) {
        int old = this.maxWidth;
        this.maxWidth = Math.max(this.minWidth, maxWidth);
        if (this.width > maxWidth) {
            this.setWidth(maxWidth);
        }
        if (this.preferredWidth > maxWidth) {
            this.setPreferredWidth(maxWidth);
        }
        this.firePropertyChange("maxWidth", old, this.maxWidth);
    }

    @Override
    public int getMaxWidth() {
        return this.maxWidth;
    }

    @Override
    public void setResizable(boolean isResizable) {
        boolean old = this.isResizable;
        this.isResizable = isResizable;
        this.firePropertyChange("isResizable", old, this.isResizable);
    }

    @Override
    public boolean getResizable() {
        return this.isResizable;
    }

    @Override
    public void sizeWidthToFit() {
        if (this.headerRenderer == null) {
            return;
        }
        Component c = this.headerRenderer.getTableCellRendererComponent(null, this.getHeaderValue(), false, false, 0, 0);
        this.setMinWidth(c.getMinimumSize().width);
        this.setMaxWidth(c.getMaximumSize().width);
        this.setPreferredWidth(c.getPreferredSize().width);
        this.setWidth(this.getPreferredWidth());
    }

    @Override
    public void disableResizedPosting() {
        ++this.resizedPostingDisableCount;
    }

    @Override
    public void enableResizedPosting() {
        --this.resizedPostingDisableCount;
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(listener);
        }
    }

    @Override
    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    @Override
    protected TableCellRenderer createDefaultHeaderRenderer() {
        DefaultTableCellRenderer label = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JTableHeader header;
                if (table != null && (header = table.getTableHeader()) != null) {
                    this.setForeground(header.getForeground());
                    this.setBackground(header.getBackground());
                    this.setFont(header.getFont());
                }
                this.setText(value == null ? "" : value.toString());
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                return this;
            }
        };
        label.setHorizontalAlignment(0);
        return label;
    }
}

