/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.request.RowItemDesc;
import org.openconcerto.sql.request.SQLFieldTranslator;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.utils.CollectionUtils;

public class SQLTableModelColumnPath
extends SQLTableModelColumn {
    private final FieldPath p;
    private boolean editable;

    private static final RowItemDesc getDescFor(SQLField field) {
        Configuration conf = Configuration.getInstance();
        if (conf == null) {
            return SQLFieldTranslator.getDefaultDesc(field);
        }
        return conf.getTranslator().getDescFor(field.getTable(), field.getName());
    }

    private static final String getLabelFor(SQLField field) {
        return SQLTableModelColumnPath.getDescFor(field).getLabel();
    }

    public SQLTableModelColumnPath(Path p, String fieldName, String name) {
        this(new FieldPath(p, fieldName), name);
    }

    public SQLTableModelColumnPath(FieldPath fp) {
        this(fp, SQLTableModelColumnPath.getDescFor(fp.getField()).getTitleLabel());
    }

    public SQLTableModelColumnPath(FieldPath fp, String name) {
        super(name);
        this.p = fp;
        this.editable = true;
    }

    @Override
    public String getIdentifier() {
        return this.p.toString();
    }

    @Override
    public String getToolTip() {
        ArrayList<String> humanPath = new ArrayList<String>(this.p.getPath().length());
        for (SQLField f : this.p.getPath().getSingleSteps()) {
            humanPath.add(SQLTableModelColumnPath.getLabelFor(f));
        }
        humanPath.add(SQLTableModelColumnPath.getLabelFor(this.p.getField()));
        return CollectionUtils.join(humanPath, " \u25ba ");
    }

    public SQLField getField() {
        return this.p.getField();
    }

    @Override
    public Set<SQLField> getFields() {
        return Collections.singleton(this.getField());
    }

    @Override
    public Set<FieldPath> getPaths() {
        return Collections.singleton(this.p);
    }

    @Override
    public Set<String> getUsedCols() {
        return Collections.emptySet();
    }

    @Override
    protected Class<?> getValueClass_() {
        return this.getField().getType().getJavaType();
    }

    @Override
    public boolean isEditable() {
        return this.editable && this.p.getPath().length() == 0;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    protected Object show_(SQLRowAccessor r) {
        return this.p.getObject(r.asRowValues());
    }

    @Override
    protected void put_(ListSQLLine l, Object value) {
        if (value == null && this.getField().isNullable() != Boolean.TRUE) {
            value = SQLRowValues.SQL_DEFAULT;
        }
        SQLRowValues ourVals = l.getRow().assurePath(this.p.getPath());
        SQLRowValues vals = new SQLRowValues(ourVals.getTable()).put(this.p.getFieldName(), value);
        if (ourVals.getID() >= 0) {
            vals.setID(ourVals.getID());
        }
        try {
            l.getSrc().commit(l, this.p.getPath(), vals);
        }
        catch (SQLException e) {
            throw new IllegalStateException("unable to set " + this + " to " + value, e);
        }
    }
}

