/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSyntaxPG;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.TablesMap;
import org.openconcerto.utils.NetUtils;
import org.openconcerto.utils.Tuple2;

class SQLSyntaxH2
extends SQLSyntax {
    SQLSyntaxH2() {
        super(SQLSystem.H2);
        this.typeNames.putAll(Boolean.class, "boolean", "bool", "bit");
        this.typeNames.putAll(Integer.class, "integer", "int", "int4", "mediumint");
        this.typeNames.putAll(Byte.class, "tinyint");
        this.typeNames.putAll(Short.class, "smallint", "int2");
        this.typeNames.putAll(Long.class, "bigint", "int8");
        this.typeNames.putAll(BigDecimal.class, "decimal", "numeric", "number");
        this.typeNames.putAll(Float.class, "real");
        this.typeNames.putAll(Double.class, "double precision", "float", "float4", "float8");
        this.typeNames.putAll(Timestamp.class, "timestamp", "smalldatetime", "datetime");
        this.typeNames.putAll(Date.class, "date");
        this.typeNames.putAll(Blob.class, "blob", "tinyblob", "mediumblob", "longblob", "image", "bytea", "raw", "varbinary", "longvarbinary", "binary");
        this.typeNames.putAll(Clob.class, "clob", "text", "tinytext", "mediumtext", "longtext");
        this.typeNames.putAll(String.class, "varchar", "longvarchar", "char", "character", "CHARACTER VARYING");
    }

    @Override
    public String getIDType() {
        return " int";
    }

    @Override
    public boolean isAuto(SQLField f) {
        if (f.getDefaultValue() == null) {
            return false;
        }
        String def = ((String)f.getDefaultValue()).toUpperCase();
        return f.getType().getJavaType() == Long.class && def.contains("NEXT VALUE") && def.contains("SYSTEM_SEQUENCE");
    }

    @Override
    public String getAuto() {
        return " IDENTITY";
    }

    @Override
    public String disableFKChecks(DBRoot b) {
        return "SET REFERENTIAL_INTEGRITY FALSE ;";
    }

    @Override
    public String enableFKChecks(DBRoot b) {
        return "SET REFERENTIAL_INTEGRITY TRUE ;";
    }

    public Map<String, Object> normalizeIndexInfo(Map m) {
        return m;
    }

    protected String setNullable(SQLField f, boolean b) {
        return SQLSelect.quote("ALTER COLUMN %n SET " + (b ? "" : "NOT") + " NULL", f);
    }

    @Override
    public List<String> getAlterField(SQLField f, Set<SQLField.Properties> toAlter, String type, String defaultVal, Boolean nullable) {
        ArrayList<String> res = new ArrayList<String>();
        if (toAlter.contains((Object)SQLField.Properties.TYPE)) {
            String newDef = toAlter.contains((Object)SQLField.Properties.DEFAULT) ? defaultVal : this.getDefault(f, type);
            boolean newNullable = toAlter.contains((Object)SQLField.Properties.NULLABLE) ? nullable.booleanValue() : this.getNullable(f);
            res.add(SQLSelect.quote("ALTER COLUMN %n " + this.getFieldDecl(type, newDef, newNullable), f));
        } else if (toAlter.contains((Object)SQLField.Properties.DEFAULT)) {
            res.add(this.setDefault(f, defaultVal));
        }
        if (toAlter.contains((Object)SQLField.Properties.NULLABLE)) {
            res.add(this.setNullable(f, nullable));
        }
        return res;
    }

    @Override
    public String getDropRoot(String name) {
        return SQLSelect.quote("DROP SCHEMA IF EXISTS %i ;", name);
    }

    @Override
    public String getCreateRoot(String name) {
        return SQLSelect.quote("CREATE SCHEMA %i ;", name);
    }

    @Override
    public String transfDefaultJDBC2SQL(SQLField f) {
        String res = (String)f.getDefaultValue();
        if (res != null && f.getType().getJavaType() == String.class && res.trim().toUpperCase().startsWith("STRINGDECODE")) {
            res = (String)f.getTable().getBase().getDataSource().executeScalar("CALL " + res);
            res = SQLBase.quoteStringStd(res);
        }
        return res;
    }

    @Override
    protected Tuple2<Boolean, String> getCast() {
        return Tuple2.create(true, " ");
    }

    @Override
    public void _loadData(File f, SQLTable t) {
        this.checkServerLocalhost(t);
        t.getDBSystemRoot().getDataSource().execute(SQLSelect.quote("insert into %f select * from CSVREAD(%s, NULL, 'UTF8', ',', '\"', '\\', '\\N') ;", t, f.getAbsolutePath()));
    }

    @Override
    protected void _storeData(SQLTable t, File f) {
        this.checkServerLocalhost(t);
        SQLSelect sel = SQLSyntaxPG.selectAll(t);
        t.getBase().getDataSource().execute(SQLSelect.quote("CALL CSVWRITE(%s, %s, 'UTF8', ',', '\"', '\\', '\\N', '\n');", f.getAbsolutePath(), sel.asString()));
    }

    @Override
    protected boolean isServerLocalhost(SQLServer s) {
        return s.getName().startsWith("mem") || s.getName().startsWith("file") || NetUtils.isSelfAddr(this.getAddr(s));
    }

    private String getAddr(SQLServer s) {
        if (s.getName().startsWith("tcp") || s.getName().startsWith("ssl")) {
            int startIndex = "tcp://".length();
            int endIndex = s.getName().indexOf(47, startIndex);
            return s.getName().substring(startIndex, endIndex < 0 ? s.getName().length() : endIndex);
        }
        return null;
    }

    @Override
    public boolean supportMultiAlterClause() {
        return false;
    }

    @Override
    public String getFormatTimestamp(String sqlTS, boolean basic) {
        return "FORMATDATETIME(" + sqlTS + ", " + SQLBase.quoteStringStd(basic ? "yyyyMMdd'T'HHmmss.SSS000" : "yyyy-MM-dd'T'HH:mm:ss.SSS000") + ")";
    }

    @Override
    public String getConstantTable(List<List<String>> rows, String alias, List<String> columnsAlias) {
        StringBuilder sb = new StringBuilder();
        sb.append("( SELECT ");
        int colCount = columnsAlias.size();
        int i = 0;
        while (i < colCount) {
            sb.append(SQLBase.quoteIdentifier("C" + (i + 1)));
            sb.append(" as ");
            sb.append(SQLBase.quoteIdentifier(columnsAlias.get(i)));
            sb.append(", ");
            ++i;
        }
        sb.setLength(sb.length() - 2);
        sb.append(" FROM ");
        sb.append(this.getValues(rows, colCount));
        sb.append(" ) AS ");
        sb.append(SQLBase.quoteIdentifier(alias));
        return sb.toString();
    }

    @Override
    public String getFunctionQuery(SQLBase b, Set<String> schemas) {
        String src = "coalesce(\"SOURCE\", \"JAVA_CLASS\" || '.' || \"JAVA_METHOD\" ||' parameter(s): ' || \"COLUMN_COUNT\")";
        return "SELECT ALIAS_SCHEMA as \"schema\", ALIAS_NAME as \"name\", coalesce(\"SOURCE\", \"JAVA_CLASS\" || '.' || \"JAVA_METHOD\" ||' parameter(s): ' || \"COLUMN_COUNT\") as \"src\" FROM \"INFORMATION_SCHEMA\".FUNCTION_ALIASES where ALIAS_CATALOG=" + b.quoteString(b.getMDName()) + " and ALIAS_SCHEMA in (" + SQLSyntaxH2.quoteStrings(b, schemas) + ")";
    }

    @Override
    public String getTriggerQuery(SQLBase b, TablesMap tables) {
        return "SELECT \"TRIGGER_NAME\", \"TABLE_SCHEMA\", \"TABLE_NAME\", \"JAVA_CLASS\" as \"ACTION\", \"SQL\" from INFORMATION_SCHEMA.TRIGGERS " + this.getTablesMapJoin(b, tables) + " where " + this.getInfoSchemaWhere(b);
    }

    private String getTablesMapJoin(SQLBase b, TablesMap tables) {
        return this.getTablesMapJoin(b, tables, SQLBase.quoteIdentifier("TABLE_SCHEMA"), SQLBase.quoteIdentifier("TABLE_NAME"));
    }

    private final String getInfoSchemaWhere(SQLBase b) {
        return "\"TABLE_CATALOG\" = " + b.quoteString(b.getMDName());
    }

    @Override
    public String getColumnsQuery(SQLBase b, TablesMap tables) {
        return "SELECT \"" + (String)INFO_SCHEMA_NAMES_KEYS.get(0) + "\", \"" + (String)INFO_SCHEMA_NAMES_KEYS.get(1) + "\", \"" + (String)INFO_SCHEMA_NAMES_KEYS.get(2) + "\" , \"CHARACTER_SET_NAME\", \"COLLATION_NAME\" from INFORMATION_SCHEMA.\"COLUMNS\" " + this.getTablesMapJoin(b, tables) + " where " + this.getInfoSchemaWhere(b);
    }

    @Override
    public List<Map<String, Object>> getConstraints(SQLBase b, TablesMap tables) throws SQLException {
        String sel = "SELECT \"TABLE_SCHEMA\", \"TABLE_NAME\", \"CONSTRAINT_NAME\", \ncase \"CONSTRAINT_TYPE\"  when 'REFERENTIAL' then 'FOREIGN KEY' else \"CONSTRAINT_TYPE\" end as \"CONSTRAINT_TYPE\", \"COLUMN_LIST\"\nFROM INFORMATION_SCHEMA.CONSTRAINTS " + this.getTablesMapJoin(b, tables) + " where " + this.getInfoSchemaWhere(b);
        List res = (List)b.getDBSystemRoot().getDataSource().execute(sel, new IResultSetHandler(SQLDataSource.MAP_LIST_HANDLER, false));
        for (Map m : res) {
            m.put("COLUMN_NAMES", new ArrayList<String>(SQLRow.toList((String)m.remove("COLUMN_LIST"))));
        }
        return res;
    }
}

