/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.HashMap;
import java.util.Map;
import org.openconcerto.sql.model.SQLBackgroundTableCacheItem;
import org.openconcerto.sql.model.SQLTable;

public class SQLBackgroundTableCache {
    private static SQLBackgroundTableCache instance;
    private Map<SQLTable, SQLBackgroundTableCacheItem> list = new HashMap<SQLTable, SQLBackgroundTableCacheItem>();

    private SQLBackgroundTableCache() {
    }

    public static synchronized SQLBackgroundTableCache getInstance() {
        if (instance == null) {
            instance = new SQLBackgroundTableCache();
        }
        return instance;
    }

    public synchronized void add(SQLTable t, int second) {
        if (!this.isCached(t)) {
            SQLBackgroundTableCacheItem item = new SQLBackgroundTableCacheItem(t, second);
            this.list.put(t, item);
        }
    }

    public synchronized boolean isCached(SQLTable t) {
        return this.list.containsKey(t);
    }

    public synchronized SQLBackgroundTableCacheItem getCacheForTable(SQLTable t) {
        SQLBackgroundTableCacheItem item = this.list.get(t);
        if (item != null) {
            item.reloadFromDbIfNeeded();
        }
        return item;
    }
}

