/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.Connection;
import java.util.LinkedList;
import org.openconcerto.sql.model.ConnectionHandler;

class HandlersStack {
    private Connection conn;
    private final LinkedList<ConnectionHandler<?, ?>> stack;
    private boolean changeAllowed;

    HandlersStack(Connection conn, ConnectionHandler<?, ?> handler) {
        if (conn == null) {
            throw new NullPointerException("null connection");
        }
        this.changeAllowed = false;
        this.conn = conn;
        this.stack = new LinkedList();
        this.push(handler);
    }

    public final Connection getConnection() throws IllegalStateException {
        if (this.conn == null) {
            throw new IllegalStateException("connection was invalidated");
        }
        return this.conn;
    }

    final void invalidConnection() {
        this.conn = null;
    }

    final HandlersStack push(ConnectionHandler<?, ?> handler) {
        this.stack.addFirst(handler);
        return this;
    }

    final boolean pop() {
        this.stack.removeFirst();
        return this.stack.isEmpty();
    }

    public final boolean isChangeAllowed() {
        return this.changeAllowed;
    }

    final void setChangeAllowed(boolean b) {
        this.changeAllowed = b;
    }
}

