/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.changer.correct;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;

public class FixSerial
extends Changer<SQLTable> {
    private static final Pattern seqPattern = Pattern.compile("nextval\\('(.+)'.*\\)");

    public static String getPrimaryKeySeq(SQLTable t) throws IllegalStateException {
        if (!t.isRowable()) {
            return null;
        }
        return FixSerial.getSeq(t.getKey());
    }

    public static String getSeq(SQLField f) throws IllegalStateException {
        if (f == null) {
            return null;
        }
        String def = ((String)f.getDefaultValue()).trim();
        if (def.startsWith("nextval")) {
            Matcher matcher = seqPattern.matcher(def);
            if (matcher.matches()) {
                return matcher.group(1);
            }
            throw new IllegalStateException("could not parse: " + def + " with " + seqPattern.pattern());
        }
        return null;
    }
}

