/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.erp.generationDoc.provider.UserInitialsValueProvider;
import org.openconcerto.sql.model.SQLRowAccessor;

public class PrixUnitaireRemiseProvider
extends UserInitialsValueProvider {
    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLRowAccessor row = context.getRow();
        BigDecimal pv = row.getBigDecimal("PV_HT");
        BigDecimal remise = (BigDecimal)row.getObject("POURCENT_REMISE");
        BigDecimal acompte = BigDecimal.ONE;
        if (row.getTable().contains("POURCENT_ACOMPTE")) {
            acompte = ((BigDecimal)row.getObject("POURCENT_ACOMPTE")).movePointLeft(2);
        }
        BigDecimal result = BigDecimal.ONE.subtract(remise.movePointLeft(2)).multiply(pv, MathContext.DECIMAL128).multiply(acompte, MathContext.DECIMAL128);
        return result.setScale(2, RoundingMode.HALF_UP);
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("PrixUnitaireRemise", new PrixUnitaireRemiseProvider());
    }
}

