/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.erp.generationDoc.provider.AdresseClientProvider;
import org.openconcerto.map.model.Ville;
import org.openconcerto.sql.model.SQLRowAccessor;

public class AdresseVilleClientValueProvider
extends AdresseClientProvider {
    private int type;

    public AdresseVilleClientValueProvider(int type) {
        this.type = type;
    }

    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLRowAccessor r = this.getAdresse(context.getRow(), this.type);
        Ville v = Ville.getVilleFromVilleEtCode((String)r.getString("VILLE"));
        String result = null;
        if (v != null) {
            result = v.getCodepostal();
            result = String.valueOf(result) + " ";
            result = String.valueOf(result) + v.getName();
            if (r.getBoolean("HAS_CEDEX").booleanValue()) {
                result = String.valueOf(result) + " Cedex";
                String cedex = r.getString("CEDEX");
                if (cedex != null && cedex.trim().length() > 0) {
                    result = String.valueOf(result) + " " + cedex;
                }
            }
        }
        return result;
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("address.customer.invoice.country", new AdresseVilleClientValueProvider(ADRESSE_FACTURATION));
        SpreadSheetCellValueProviderManager.put("address.customer.shipment.country", new AdresseVilleClientValueProvider(ADRESSE_LIVRAISON));
    }
}

