/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jopendocument.link.Component;
import org.jopendocument.link.OOConnexion;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.generationDoc.DocumentLocalStorageManager;
import org.openconcerto.erp.generationDoc.SheetUtils;
import org.openconcerto.erp.generationDoc.TemplateManager;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.erp.preferences.TemplateNXProps;
import org.openconcerto.map.model.Ville;
import org.openconcerto.odtemplate.Template;
import org.openconcerto.odtemplate.TemplateException;
import org.openconcerto.odtemplate.engine.DataModel;
import org.openconcerto.odtemplate.engine.OGNLDataModel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.utils.ExceptionHandler;

public abstract class AbstractJOOReportsSheet {
    protected static final DateFormat dateFormat = new SimpleDateFormat("dd MMMM yyyy");
    protected static final DateFormat dateFormat2 = new SimpleDateFormat("dd/MM/yy");
    protected static final DateFormat yearFormat = new SimpleDateFormat("yyyy");
    private String year;
    protected String locationTemplate = TemplateNXProps.getInstance().getStringProperty("LocationTemplate");
    protected String templateId;
    private String printer;
    protected boolean askOverwriting = false;

    protected abstract Map createMap();

    protected abstract String getName();

    public String getFileName() {
        return AbstractJOOReportsSheet.getValidFileName(this.getName());
    }

    static String getValidFileName(String fileName) {
        StringBuffer result = new StringBuffer(fileName.length());
        int i = 0;
        while (i < fileName.length()) {
            char ch = fileName.charAt(i);
            if (Character.isLetterOrDigit(ch) || ch == '_' || ch == ' ') {
                result.append(ch);
            } else {
                result.append('-');
            }
            ++i;
        }
        return result.toString();
    }

    public abstract String getDefaultTemplateID();

    protected void init(String year, String templateId, String attributePrinter) {
        this.year = year;
        this.templateId = templateId;
        this.printer = PrinterNXProps.getInstance().getStringProperty(attributePrinter);
    }

    public final void generate(boolean print, boolean show, String printer) {
        this.generate(print, show, printer, false);
    }

    public void generate(boolean print, boolean show, String printer, boolean overwrite) {
        if (this.locationTemplate.trim().length() == 0) {
            this.locationTemplate = "/Configuration/Template/Default/";
        }
        try {
            String fileName = this.getFileName();
            InputStream fileTemplate = TemplateManager.getInstance().getTemplate(this.templateId);
            File outputDir = DocumentLocalStorageManager.getInstance().getDocumentOutputDirectory(this.getDefaultTemplateID());
            File fileOutOO = this.getDocumentFile();
            if (fileOutOO.exists() && overwrite) {
                if (this.askOverwriting) {
                    int answer = JOptionPane.showConfirmDialog(null, "Voulez vous \u00e9craser le document ?", "Remplacement d'un document", 0);
                    if (answer == 0) {
                        SheetUtils.convertToOldFile(((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete(), fileName, outputDir, fileOutOO, ".odt");
                    }
                } else {
                    SheetUtils.convertToOldFile(((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete(), fileName, outputDir, fileOutOO, ".odt");
                }
            }
            if (!fileOutOO.exists()) {
                fileOutOO.getParentFile().mkdirs();
                Template template = new Template((InputStream)new BufferedInputStream(fileTemplate));
                Map createMap = this.createMap();
                OGNLDataModel model = new OGNLDataModel((Object)createMap);
                model.putAll(createMap);
                template.createDocument((DataModel)model).saveToPackageAs(fileOutOO);
            }
            if (show || print) {
                try {
                    OOConnexion ooConnexion = ComptaPropsConfiguration.getOOConnexion();
                    if (ooConnexion == null) {
                        return;
                    }
                    Component doc = ooConnexion.loadDocument(fileOutOO, !show);
                    if (this.savePDF()) {
                        File pdfOutputDir = DocumentLocalStorageManager.getInstance().getPDFOutputDirectory(this.getDefaultTemplateID());
                        doc.saveToPDF(new File(pdfOutputDir, String.valueOf(fileName) + ".pdf"), "writer_pdf_Export");
                    }
                    if (print) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("Name", printer);
                        doc.printDocument(map);
                    }
                    doc.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ExceptionHandler.handle("Impossible de charger le document OpenOffice", e);
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            ExceptionHandler.handle("Impossible de trouver le mod\u00e9le.", e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
    }

    protected boolean savePDF() {
        return false;
    }

    public void showDocument() {
        File fileOutOO = this.getDocumentFile();
        if (fileOutOO.exists()) {
            try {
                OOConnexion ooConnexion = ComptaPropsConfiguration.getOOConnexion();
                if (ooConnexion == null) {
                    return;
                }
                ooConnexion.loadDocument(fileOutOO, false);
            }
            catch (Exception e) {
                e.printStackTrace();
                ExceptionHandler.handle("Impossible de charger le document OpenOffice", e);
            }
        } else {
            this.generate(false, true, "");
        }
    }

    private File getDocumentFile() {
        File outputDir = DocumentLocalStorageManager.getInstance().getDocumentOutputDirectory(this.getDefaultTemplateID());
        return new File(outputDir, String.valueOf(this.getFileName()) + ".odt");
    }

    protected static String getVille(final String name) {
        Ville ville = Ville.getVilleFromVilleEtCode((String)name);
        if (ville == null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, "La ville \"" + name + "\"" + " est introuvable! Veuillez corriger l'erreur!");
                }
            });
            return null;
        }
        return ville.getName();
    }

    protected static String getVilleCP(String name) {
        Ville ville = Ville.getVilleFromVilleEtCode((String)name);
        if (ville == null) {
            return null;
        }
        return ville.getCodepostal();
    }
}

