/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.quote.element;

import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.sales.invoice.component.SaisieVenteFactureSQLComponent;
import org.openconcerto.erp.core.sales.order.component.CommandeClientSQLComponent;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.sales.quote.component.DevisSQLComponent;
import org.openconcerto.erp.core.sales.quote.element.DevisItemSQLElement;
import org.openconcerto.erp.core.sales.quote.report.DevisXmlSheet;
import org.openconcerto.erp.core.supplychain.stock.element.MouvementStockSQLElement;
import org.openconcerto.erp.model.MouseSheetXmlListeListener;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.utils.CollectionMap;

public class DevisSQLElement
extends ComptaSQLConfElement {
    public DevisSQLElement() {
        super("DEVIS", "un devis", "devis");
        this.getRowActions().addAll(this.getDevisRowActions());
    }

    private List<RowAction> getDevisRowActions() {
        ArrayList<RowAction> rowsActions = new ArrayList<RowAction>();
        RowAction factureAction = this.getDevis2FactureAction();
        rowsActions.add(factureAction);
        RowAction actionTransfertCmd = this.getDevis2CmdFournAction();
        rowsActions.add(actionTransfertCmd);
        RowAction commandeAction = this.getDevis2CmdCliAction();
        rowsActions.add(commandeAction);
        RowAction accepteEtCmdAction = this.getAcceptAndCmdClientAction();
        rowsActions.add(accepteEtCmdAction);
        RowAction accepteAction = this.getAcceptAction();
        rowsActions.add(accepteAction);
        RowAction refuseAction = this.getRefuseAction();
        rowsActions.add(refuseAction);
        RowAction cloneAction = this.getCloneAction();
        rowsActions.add(cloneAction);
        MouseSheetXmlListeListener mouseSheetXmlListeListener = new MouseSheetXmlListeListener(DevisXmlSheet.class);
        mouseSheetXmlListeListener.setGenerateHeader(true);
        mouseSheetXmlListeListener.setShowHeader(true);
        rowsActions.addAll(mouseSheetXmlListeListener.getRowActions());
        return rowsActions;
    }

    public RowAction getCloneAction() {
        return new RowAction(new AbstractAction(){
            private EditFrame editFrame;

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRow selectedRow = IListe.get(e).getSelectedRow();
                if (this.editFrame == null) {
                    SQLElement eltFact = Configuration.getInstance().getDirectory().getElement("DEVIS");
                    this.editFrame = new EditFrame(eltFact, EditPanel.CREATION);
                }
                ((DevisSQLComponent)this.editFrame.getSQLComponent()).loadDevisExistant(selectedRow.getID());
                this.editFrame.setVisible(true);
            }
        }, true, "sales.quote.clone"){

            @Override
            public boolean enabledFor(List<SQLRowAccessor> selection) {
                return selection != null && selection.size() == 1;
            }
        };
    }

    public RowAction getRefuseAction() {
        return new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRowValues rowVals = IListe.get(e).getSelectedRow().createEmptyUpdateRow();
                rowVals.put("ID_ETAT_DEVIS", 3);
                try {
                    rowVals.update();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                IListe.get(e).getSelectedRow().getTable().fireTableModified(IListe.get(e).getSelectedId());
            }
        }, false, "sales.quote.refuse"){

            @Override
            public boolean enabledFor(List<SQLRowAccessor> selection) {
                return selection != null && selection.size() == 1 && selection.get(0).getInt("ID_ETAT_DEVIS") == 2;
            }
        };
    }

    public RowAction getAcceptAction() {
        return new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRow selectedRow = IListe.get(e).getSelectedRow();
                SQLRowValues rowVals = selectedRow.createEmptyUpdateRow();
                rowVals.put("ID_ETAT_DEVIS", 4);
                try {
                    rowVals.update();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                selectedRow.getTable().fireTableModified(IListe.get(e).getSelectedId());
            }
        }, false, "sales.quote.accept"){

            @Override
            public boolean enabledFor(List<SQLRowAccessor> selection) {
                return selection != null && selection.size() == 1 && selection.get(0).getInt("ID_ETAT_DEVIS") == 2;
            }
        };
    }

    public RowAction getDevis2FactureAction() {
        return new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DevisSQLElement elt = (DevisSQLElement)Configuration.getInstance().getDirectory().getElement("DEVIS");
                elt.transfertFacture(IListe.get(e).getSelectedRow().getID());
            }
        }, true, "sales.quote.create.invoice"){

            @Override
            public boolean enabledFor(List<SQLRowAccessor> selection) {
                return selection != null && selection.size() == 1 && selection.get(0).getInt("ID_ETAT_DEVIS") == 4;
            }
        };
    }

    public RowAction getDevis2CmdFournAction() {
        return new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DevisSQLElement.this.transfertCommande(IListe.get(e).getSelectedRow());
            }
        }, false, "sales.quote.create.supplier.order"){

            @Override
            public boolean enabledFor(List<SQLRowAccessor> selection) {
                return selection != null && selection.size() == 1 && selection.get(0).getInt("ID_ETAT_DEVIS") == 4;
            }
        };
    }

    public RowAction getDevis2CmdCliAction() {
        return new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DevisSQLElement elt = (DevisSQLElement)Configuration.getInstance().getDirectory().getElement("DEVIS");
                elt.transfertCommandeClient(IListe.get(e).getSelectedRow().getID());
            }
        }, true, "sales.quote.create.customer.order"){

            @Override
            public boolean enabledFor(List<SQLRowAccessor> selection) {
                return selection != null && selection.size() == 1 && selection.get(0).getInt("ID_ETAT_DEVIS") == 4;
            }
        };
    }

    public RowAction getAcceptAndCmdClientAction() {
        return new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRow selectedRow = IListe.get(e).getSelectedRow();
                SQLRowValues rowVals = selectedRow.createEmptyUpdateRow();
                rowVals.put("ID_ETAT_DEVIS", 4);
                try {
                    rowVals.update();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                selectedRow.getTable().fireTableModified(IListe.get(e).getSelectedId());
                DevisSQLElement elt = (DevisSQLElement)Configuration.getInstance().getDirectory().getElement("DEVIS");
                elt.transfertCommandeClient(selectedRow.getID());
            }
        }, false, "sales.quote.accept.create.customer.order"){

            @Override
            public boolean enabledFor(List<SQLRowAccessor> selection) {
                return selection != null && selection.size() == 1 && selection.get(0).getInt("ID_ETAT_DEVIS") == 2;
            }
        };
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        return l;
    }

    private void transfertCommande(SQLRow row) {
        DevisItemSQLElement elt = (DevisItemSQLElement)Configuration.getInstance().getDirectory().getElement("DEVIS_ELEMENT");
        SQLTable tableCmdElt = Configuration.getInstance().getDirectory().getElement("COMMANDE_ELEMENT").getTable();
        SQLElement eltArticle = Configuration.getInstance().getDirectory().getElement("ARTICLE");
        Collection rows = row.getReferentRows(elt.getTable());
        CollectionMap<SQLRow, List<SQLRowValues>> map = new CollectionMap<SQLRow, List<SQLRowValues>>();
        for (SQLRow sqlRow : rows) {
            SQLRowValues rowArticle = new SQLRowValues(eltArticle.getTable());
            for (SQLField field : eltArticle.getTable().getFields()) {
                if (!sqlRow.getTable().getFieldsName().contains(field.getName())) continue;
                rowArticle.put(field.getName(), sqlRow.getObject(field.getName()));
            }
            int idArticle = ReferenceArticleSQLElement.getIdForCNM(rowArticle, true);
            SQLRow rowArticleFind = eltArticle.getTable().getRow(idArticle);
            SQLInjector inj = SQLInjector.getInjector(rowArticle.getTable(), tableCmdElt);
            SQLRowValues rowValsElt = new SQLRowValues(inj.createRowValuesFrom(rowArticleFind));
            rowValsElt.put("ID_STYLE", sqlRow.getObject("ID_STYLE"));
            rowValsElt.put("QTE", sqlRow.getObject("QTE"));
            rowValsElt.put("T_POIDS", rowValsElt.getLong("POIDS") * (long)rowValsElt.getInt("QTE"));
            rowValsElt.put("T_PA_HT", ((BigDecimal)rowValsElt.getObject("PA_HT")).multiply(new BigDecimal(rowValsElt.getInt("QTE"), MathContext.DECIMAL128)));
            rowValsElt.put("T_PA_TTC", ((BigDecimal)rowValsElt.getObject("T_PA_HT")).multiply(new BigDecimal((double)rowValsElt.getForeign("ID_TAXE").getFloat("TAUX") / 100.0 + 1.0), MathContext.DECIMAL128));
            map.put((Object)rowArticleFind.getForeignRow("ID_FOURNISSEUR"), rowValsElt);
        }
        MouvementStockSQLElement.createCommandeF(map, row.getForeignRow("ID_TARIF").getForeignRow("ID_DEVISE"));
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        l.add("DATE");
        l.add("ID_CLIENT");
        l.add("OBJET");
        l.add("ID_COMMERCIAL");
        l.add("T_HT");
        l.add("T_TTC");
        l.add("INFOS");
        return l;
    }

    @Override
    public CollectionMap<String, String> getShowAs() {
        CollectionMap<String, String> map = new CollectionMap<String, String>();
        map.put(null, (Object)"NUMERO");
        return map;
    }

    @Override
    public synchronized ListSQLRequest createListRequest() {
        return new ListSQLRequest(this.getTable(), this.getListFields()){

            @Override
            protected void customizeToFetch(SQLRowValues graphToFetch) {
                super.customizeToFetch(graphToFetch);
                graphToFetch.put("ID_ETAT_DEVIS", null);
            }
        };
    }

    @Override
    protected Set<String> getChildren() {
        HashSet<String> set = new HashSet<String>();
        set.add("DEVIS_ELEMENT");
        return set;
    }

    @Override
    protected List<String> getPrivateFields() {
        ArrayList<String> s = new ArrayList<String>(1);
        s.add("ID_ADRESSE");
        return s;
    }

    @Override
    public SQLComponent createComponent() {
        return new DevisSQLComponent(this);
    }

    public void transfertFacture(int devisID) {
        SQLElement elt = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
        EditFrame editFactureFrame = new EditFrame(elt);
        editFactureFrame.setIconImage(new ImageIcon(Gestion.class.getResource("frameicon.png")).getImage());
        SaisieVenteFactureSQLComponent comp = (SaisieVenteFactureSQLComponent)editFactureFrame.getSQLComponent();
        comp.setDefaults();
        comp.loadDevis(devisID);
        editFactureFrame.pack();
        editFactureFrame.setState(0);
        editFactureFrame.setVisible(true);
    }

    public void transfertCommandeClient(int devisID) {
        SQLElement elt = Configuration.getInstance().getDirectory().getElement("COMMANDE_CLIENT");
        EditFrame editFactureFrame = new EditFrame(elt);
        editFactureFrame.setIconImage(new ImageIcon(Gestion.class.getResource("frameicon.png")).getImage());
        CommandeClientSQLComponent comp = (CommandeClientSQLComponent)editFactureFrame.getSQLComponent();
        comp.setDefaults();
        comp.loadDevis(devisID);
        editFactureFrame.pack();
        editFactureFrame.setState(0);
        editFactureFrame.setVisible(true);
    }
}

