/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import org.openconcerto.erp.core.sales.pos.Caisse;
import org.openconcerto.erp.core.sales.pos.io.BarcodeReader;
import org.openconcerto.erp.core.sales.pos.io.TicketPrinter;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.erp.core.sales.pos.model.Paiement;
import org.openconcerto.erp.core.sales.pos.model.Ticket;
import org.openconcerto.erp.core.sales.pos.ui.BarcodeListener;
import org.openconcerto.erp.core.sales.pos.ui.CaisseFrame;
import org.openconcerto.erp.core.sales.pos.ui.CaisseListener;
import org.openconcerto.utils.Pair;

public class CaisseControler
implements BarcodeListener {
    private Article articleSelected;
    private Paiement paiementSelected;
    private Ticket t;
    private List<CaisseListener> listeners = new ArrayList<CaisseListener>();
    private BarcodeReader r;
    private Paiement p1 = new Paiement(1);
    private Paiement p2 = new Paiement(3);
    private Paiement p3 = new Paiement(2);
    private CaisseFrame caisseFrame;

    public CaisseControler(CaisseFrame caisseFrame) {
        this.caisseFrame = caisseFrame;
        this.t = new Ticket(Caisse.getID());
        this.t.addPaiement(this.p1);
        this.t.addPaiement(this.p2);
        this.t.addPaiement(this.p3);
        this.r = new BarcodeReader();
        this.r.start();
        this.r.addBarcodeListener(this);
    }

    public Article getArticleSelected() {
        return this.articleSelected;
    }

    public Paiement getPaiementSelected() {
        return this.paiementSelected;
    }

    void setArticleSelected(Article a) {
        if (a != this.articleSelected) {
            this.articleSelected = a;
            this.paiementSelected = null;
            this.fire();
        }
    }

    void setPaiementSelected(Paiement p) {
        this.paiementSelected = p;
        this.articleSelected = null;
        this.fire();
    }

    private void fire() {
        int stop = this.listeners.size();
        int i = 0;
        while (i < stop) {
            this.listeners.get(i).caisseStateChanged();
            ++i;
        }
    }

    void addCaisseListener(CaisseListener l) {
        this.listeners.add(l);
    }

    void addArticle(Article a) {
        this.t.addArticle(a);
        this.fire();
    }

    void incrementArticle(Article a) {
        this.t.incrementArticle(a);
        this.fire();
    }

    public List<Paiement> getPaiements() {
        return this.t.getPaiements();
    }

    public void addPaiement(Paiement p) {
        this.t.addPaiement(p);
        this.fire();
    }

    public void clearPaiement(Paiement paiement) {
        if (this.p1.equals(paiement) || this.p2.equals(paiement) || this.p3.equals(paiement)) {
            paiement.setMontantInCents(0);
        }
        this.fire();
    }

    public void setPaiementValue(Paiement paiement, int v) {
        paiement.setMontantInCents(v);
        this.fire();
    }

    public int getTotal() {
        return this.t.getTotal();
    }

    public int getPaidTotal() {
        return this.t.getPaidTotal();
    }

    public List<Pair<Article, Integer>> getItems() {
        return this.t.getArticles();
    }

    public int getItemCount(Article article) {
        return this.t.getItemCount(article);
    }

    public void clearArticle(Article article) {
        this.t.clearArticle(article);
        this.setArticleSelected(null);
    }

    public void setArticleCount(Article article, int count) {
        this.t.setArticleCount(article, count);
        this.setArticleSelected(null);
    }

    @Override
    public void barcodeRead(String code) {
        if (code.equalsIgnoreCase("especes")) {
            this.autoFillPaiement(this.p1);
        } else if (code.equalsIgnoreCase("cb")) {
            this.autoFillPaiement(this.p2);
        } else if (code.equalsIgnoreCase("cheque")) {
            this.autoFillPaiement(this.p3);
        } else if (code.equalsIgnoreCase("annuler")) {
            if (this.articleSelected != null) {
                this.clearArticle(this.articleSelected);
            } else if (this.paiementSelected != null) {
                this.paiementSelected.setMontantInCents(0);
                this.fire();
            }
        } else if (!(code.equalsIgnoreCase("valider") || code.equalsIgnoreCase("facture") || code.equalsIgnoreCase("ticket"))) {
            Ticket t;
            Article a = Article.getArticleFromBarcode(code);
            if (a != null) {
                this.incrementArticle(a);
                this.setArticleSelected(a);
            }
            if ((t = Ticket.getTicketFromCode(code)) != null) {
                this.caisseFrame.showTickets(t);
            }
        }
    }

    void autoFillPaiement(Paiement p) {
        int montant = p.getMontantInCents();
        p.setMontantInCents(this.getTotal() - this.getPaidTotal() + montant);
        this.setPaiementSelected(p);
    }

    void addBarcodeListener(BarcodeListener l) {
        this.r.addBarcodeListener(l);
    }

    public boolean canAddPaiement(int type) {
        int paiementCount = this.t.getPaiements().size();
        if (paiementCount >= 6) {
            return false;
        }
        int i = 0;
        while (i < paiementCount) {
            Paiement p = this.t.getPaiements().get(i);
            if (p.getType() == type && p.getMontantInCents() <= 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void keyReceived(KeyEvent ee) {
    }

    public static String getCents(int cents) {
        String s = String.valueOf(cents % 100);
        if (s.length() < 2) {
            s = "0" + s;
        }
        return s;
    }

    public static String getEuros(int cents) {
        String s = String.valueOf(cents / 100);
        return s;
    }

    public void saveAndClearTicket() {
        if (this.t.getTotal() > 0 && this.getPaidTotal() >= this.getTotal()) {
            this.t.save();
            this.t = new Ticket(Caisse.getID());
            this.p1 = new Paiement(1);
            this.p2 = new Paiement(3);
            this.p3 = new Paiement(2);
            this.t.addPaiement(this.p1);
            this.t.addPaiement(this.p2);
            this.t.addPaiement(this.p3);
            this.setPaiementSelected(null);
            this.setArticleSelected(null);
        }
    }

    public int getTicketNumber() {
        return this.t.getNumber();
    }

    public void printTicket() {
        if (this.t.getTotal() > 0) {
            if (this.getPaidTotal() >= this.getTotal()) {
                TicketPrinter prt = Caisse.getTicketPrinter();
                this.t.print(prt);
            } else {
                System.err.println("Ticket not printed because not paid");
            }
        } else {
            System.err.println("Ticket not printed total <= 0");
        }
    }

    public void openDrawer() {
        try {
            TicketPrinter prt = Caisse.getTicketPrinter();
            prt.openDrawer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

