/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;

public class TotalCalculator {
    private static String FIELD_SERVICE = "SERVICE";
    private static String FIELD_POIDS = "POIDS";
    private final String fieldHT;
    private final String fieldHA;
    private final String fieldDevise;
    private SQLRowAccessor rowDefaultCptProduit;
    private SQLRowAccessor rowDefaultCptService;
    private SQLRowAccessor rowDefaultCptTVA;
    private static final SQLTable tablePrefCompte = Configuration.getInstance().getRoot().findTable("PREFS_COMPTE");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);
    double totalPoids;
    private BigDecimal totalDevise;
    private BigDecimal totalDeviseSel;
    private BigDecimal totalHA;
    private BigDecimal totalHASel;
    private BigDecimal totalService;
    private BigDecimal totalServiceSel;
    private BigDecimal totalTTC;
    private BigDecimal totalTTCSel;
    private long remiseHT;
    private long remiseRestante;
    private Map<SQLRowAccessor, BigDecimal> mapHt = new HashMap<SQLRowAccessor, BigDecimal>();
    private Map<SQLRowAccessor, BigDecimal> mapHtSel = new HashMap<SQLRowAccessor, BigDecimal>();
    private Map<SQLRowAccessor, BigDecimal> mapHtTVA = new HashMap<SQLRowAccessor, BigDecimal>();
    private Map<SQLRowAccessor, BigDecimal> mapHtTVASel = new HashMap<SQLRowAccessor, BigDecimal>();
    int[] selectedRows;
    private Boolean bServiceActive;
    private BigDecimal totalHTAvantRemise;
    private Map<Integer, SQLRowAccessor> mapTVA;
    final SQLTable tvaTable = Configuration.getInstance().getRoot().findTable("TAXE");
    final SQLTable compteTable = Configuration.getInstance().getRoot().findTable("COMPTE_PCE");

    public TotalCalculator(String fieldHA, String fieldHT, String fieldDeviseTotal) {
        this.initValues();
        this.fieldDevise = fieldDeviseTotal;
        this.fieldHA = fieldHA;
        this.fieldHT = fieldHT;
        this.rowDefaultCptService = rowPrefsCompte.getForeign("ID_COMPTE_PCE_VENTE_SERVICE");
        if (this.rowDefaultCptService == null || this.rowDefaultCptService.isUndefined()) {
            try {
                this.rowDefaultCptService = ComptePCESQLElement.getRowComptePceDefault("VentesServices");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.rowDefaultCptProduit = rowPrefsCompte.getForeign("ID_COMPTE_PCE_VENTE_PRODUIT");
        if (this.rowDefaultCptProduit == null || this.rowDefaultCptProduit.isUndefined()) {
            try {
                this.rowDefaultCptProduit = ComptePCESQLElement.getRowComptePceDefault("VentesProduits");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.rowDefaultCptTVA = rowPrefsCompte.getForeign("ID_COMPTE_PCE_TVA_VENTE");
        if (this.rowDefaultCptTVA == null || this.rowDefaultCptTVA.isUndefined()) {
            try {
                this.rowDefaultCptTVA = ComptePCESQLElement.getRowComptePceDefault("TVACollectee");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setRemise(long remiseHT, BigDecimal totalHTAvantRemise) {
        this.remiseHT = remiseHT;
        this.remiseRestante = remiseHT;
        this.totalHTAvantRemise = totalHTAvantRemise;
    }

    public void setServiceActive(boolean b) {
        this.bServiceActive = b;
    }

    public void initValues() {
        this.remiseHT = 0L;
        this.remiseRestante = 0L;
        this.totalHTAvantRemise = BigDecimal.ZERO;
        this.selectedRows = null;
        this.totalTTC = BigDecimal.ZERO;
        this.totalTTCSel = BigDecimal.ZERO;
        this.totalHA = BigDecimal.ZERO;
        this.totalHASel = BigDecimal.ZERO;
        this.totalService = BigDecimal.ZERO;
        this.totalServiceSel = BigDecimal.ZERO;
        this.totalDeviseSel = BigDecimal.ZERO;
        this.totalDevise = BigDecimal.ZERO;
        this.totalPoids = 0.0;
        this.mapHt.clear();
        this.mapHtSel.clear();
        this.mapHtTVA.clear();
        this.mapHtTVASel.clear();
    }

    public void setSelectedRows(int[] selectedRows) {
        this.selectedRows = selectedRows;
    }

    public void addEchantillon(BigDecimal ht, SQLRowAccessor tva) {
        this.addHT(ht, tva, this.rowDefaultCptProduit, false);
    }

    private void fetchTVA() {
        this.mapTVA = new HashMap<Integer, SQLRowAccessor>();
        SQLRowValues rowVals = new SQLRowValues(this.tvaTable);
        SQLRowValues rowValsC1 = new SQLRowValues(this.compteTable);
        rowValsC1.put("NUMERO", null);
        rowValsC1.put("ID", null);
        rowVals.put(this.tvaTable.getKey().getName(), null);
        rowVals.put("ID_COMPTE_PCE", rowValsC1);
        SQLRowValuesListFetcher fetch = SQLRowValuesListFetcher.create(rowVals);
        List<SQLRowValues> rowValsList = fetch.fetch();
        for (SQLRowValues sqlRowValues : rowValsList) {
            this.mapTVA.put(sqlRowValues.getID(), sqlRowValues);
        }
    }

    private void addHT(BigDecimal ht, SQLRowAccessor tva, SQLRowAccessor cptArticle, boolean selection) {
        BigDecimal l;
        BigDecimal totalTVA;
        BigDecimal ttc;
        if (tva == null || tva.isUndefined()) {
            ttc = ht;
            totalTVA = BigDecimal.ZERO;
        } else {
            BigDecimal tauxTVA = BigDecimal.valueOf(TaxeCache.getCache().getTauxFromId(tva.getID()).floatValue()).movePointLeft(2);
            ttc = tauxTVA.add(BigDecimal.ONE).multiply(ht, MathContext.DECIMAL128);
            totalTVA = ttc.subtract(ht);
        }
        if (tva != null && !tva.isUndefined()) {
            BigDecimal l2;
            SQLRowAccessor rowCptTva = tva.getForeign("ID_COMPTE_PCE");
            if (rowCptTva == null || rowCptTva.isUndefined()) {
                rowCptTva = this.rowDefaultCptTVA;
            }
            if (this.mapHtTVA.get(rowCptTva) == null) {
                this.mapHtTVA.put(rowCptTva, totalTVA);
            } else {
                l2 = this.mapHtTVA.get(rowCptTva);
                this.mapHtTVA.put(rowCptTva, l2.add(totalTVA));
            }
            if (selection) {
                if (this.mapHtTVASel.get(rowCptTva) == null) {
                    this.mapHtTVASel.put(rowCptTva, totalTVA);
                } else {
                    l2 = this.mapHtTVASel.get(rowCptTva);
                    this.mapHtTVASel.put(rowCptTva, l2.add(totalTVA));
                }
            }
        }
        if (this.mapHt.get(cptArticle) == null) {
            this.mapHt.put(cptArticle, ht);
        } else {
            l = this.mapHt.get(cptArticle);
            this.mapHt.put(cptArticle, l.add(ht));
        }
        this.totalTTC = this.totalTTC.add(ttc);
        if (selection) {
            if (this.mapHtSel.get(cptArticle) == null) {
                this.mapHtSel.put(cptArticle, ht);
            } else {
                l = this.mapHtSel.get(cptArticle);
                this.mapHtSel.put(cptArticle, l.add(ht));
            }
            this.totalTTCSel = this.totalTTCSel.add(ttc);
        }
    }

    private static boolean containsInt(int[] tab, int i) {
        if (tab == null) {
            return false;
        }
        int j = 0;
        while (j < tab.length) {
            if (tab[j] == i) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public void addLine(SQLRowAccessor rowAccessorLine, SQLRowAccessor article, int lineNumber, boolean last) {
        BigDecimal totalLineHT = rowAccessorLine.getObject(this.fieldHT) == null ? BigDecimal.ZERO : (BigDecimal)rowAccessorLine.getObject(this.fieldHT);
        BigDecimal totalHALigne = rowAccessorLine.getObject(this.fieldHA) == null ? BigDecimal.ZERO : (BigDecimal)rowAccessorLine.getObject(this.fieldHA);
        Boolean service = rowAccessorLine.getBoolean(FIELD_SERVICE);
        BigDecimal totalLineDevise = this.fieldDevise == null || rowAccessorLine.getObject(this.fieldDevise) == null ? BigDecimal.ZERO : (BigDecimal)rowAccessorLine.getObject(this.fieldDevise);
        Number nPoids = (Number)rowAccessorLine.getObject(FIELD_POIDS);
        if (this.remiseHT != 0L && this.remiseRestante > 0L) {
            if (last) {
                totalLineHT = totalLineHT.subtract(new BigDecimal(this.remiseRestante).movePointLeft(2));
                this.remiseRestante = 0L;
            } else {
                BigDecimal percent = totalLineHT.divide(this.totalHTAvantRemise, MathContext.DECIMAL128);
                BigDecimal remiseApply = percent.multiply(new BigDecimal(this.remiseHT), MathContext.DECIMAL128).setScale(0, RoundingMode.HALF_UP);
                totalLineHT = totalLineHT.subtract(remiseApply.movePointLeft(2));
                this.remiseRestante -= remiseApply.longValue();
            }
        }
        SQLRowAccessor cpt = this.rowDefaultCptProduit;
        if (article != null && !article.isUndefined()) {
            SQLRowAccessor compteArticle = article.getForeign("ID_COMPTE_PCE");
            if (compteArticle != null && !compteArticle.isUndefined()) {
                cpt = compteArticle;
            } else {
                SQLRowAccessor compteFamilleArticle;
                SQLRowAccessor familleArticle = article.getForeign("ID_FAMILLE_ARTICLE");
                if (familleArticle != null && !familleArticle.isUndefined() && (compteFamilleArticle = familleArticle.getForeign("ID_COMPTE_PCE")) != null && !compteFamilleArticle.isUndefined()) {
                    cpt = compteFamilleArticle;
                }
            }
        }
        if (this.bServiceActive != null && this.bServiceActive.booleanValue() && service != null && service.booleanValue()) {
            this.totalService = this.totalService.add(totalLineHT);
            cpt = this.rowDefaultCptService;
        }
        this.totalHA = this.totalHA.add(totalHALigne);
        if (totalLineDevise != null) {
            this.totalDevise = this.totalDevise.add(totalLineDevise);
        }
        this.totalPoids += nPoids == null ? 0.0 : nPoids.doubleValue();
        boolean selection = TotalCalculator.containsInt(this.selectedRows, lineNumber);
        if (selection) {
            this.totalHASel = this.totalHASel.add(totalHALigne);
            if (this.bServiceActive != null && this.bServiceActive.booleanValue() && service.booleanValue()) {
                this.totalServiceSel = this.totalServiceSel.add(totalLineHT);
            }
            if (totalLineDevise != null) {
                this.totalDeviseSel = this.totalDeviseSel.add(totalLineDevise);
            }
        }
        if (this.mapTVA == null) {
            this.fetchTVA();
        }
        this.addHT(totalLineHT, this.mapTVA.get(rowAccessorLine.getObject("ID_TAXE")), cpt, selection);
    }

    public void checkResult() {
        BigDecimal ht = this.getTotalHT();
        BigDecimal tva = this.getTotalTVA();
        BigDecimal totalTTC2 = this.getTotalTTC();
        BigDecimal reste = totalTTC2.subtract(ht.add(tva));
        if (reste.compareTo(BigDecimal.ZERO) != 0) {
            System.err.println("HT " + ht);
            System.err.println("TVA " + tva);
            System.err.println("TTC " + totalTTC2);
            Thread.dumpStack();
            SQLRow row = ComptePCESQLElement.getRow("758", "Ecarts arrondis");
            this.mapHt.put(row, reste);
        }
    }

    public BigDecimal getTotalDevise() {
        return this.totalDevise;
    }

    public BigDecimal getTotalDeviseSel() {
        return this.totalDeviseSel;
    }

    public BigDecimal getTotalHA() {
        return this.totalHA;
    }

    public BigDecimal getTotalHASel() {
        return this.totalHASel;
    }

    public double getTotalPoids() {
        return this.totalPoids;
    }

    public BigDecimal getTotalService() {
        return this.totalService;
    }

    public BigDecimal getTotalServiceSel() {
        return this.totalServiceSel;
    }

    public BigDecimal getTotalHT() {
        BigDecimal ht = BigDecimal.ZERO;
        for (SQLRowAccessor row : this.mapHt.keySet()) {
            ht = ht.add(this.mapHt.get(row).setScale(2, RoundingMode.HALF_UP));
        }
        return ht;
    }

    public BigDecimal getTotalTVA() {
        BigDecimal tva = BigDecimal.ZERO;
        for (SQLRowAccessor row : this.mapHtTVA.keySet()) {
            tva = tva.add(this.mapHtTVA.get(row).setScale(2, RoundingMode.HALF_UP));
        }
        return tva;
    }

    public BigDecimal getTotalTTC() {
        return this.totalTTC.setScale(2, RoundingMode.HALF_UP);
    }

    public BigDecimal getTotalHTSel() {
        BigDecimal ht = BigDecimal.ZERO;
        for (SQLRowAccessor row : this.mapHtSel.keySet()) {
            ht = ht.add(this.mapHtSel.get(row).setScale(2, RoundingMode.HALF_UP));
        }
        return ht;
    }

    public BigDecimal getTotalTVASel() {
        BigDecimal tva = BigDecimal.ZERO;
        for (SQLRowAccessor row : this.mapHtTVASel.keySet()) {
            tva = tva.add(this.mapHtTVASel.get(row).setScale(2, RoundingMode.HALF_UP));
        }
        return tva;
    }

    public BigDecimal getTotalTTCSel() {
        return this.totalTTCSel.setScale(2, RoundingMode.HALF_UP);
    }

    public Map<SQLRowAccessor, BigDecimal> getMapHt() {
        return this.mapHt;
    }

    public Map<SQLRowAccessor, BigDecimal> getMapHtTVA() {
        return this.mapHtTVA;
    }
}

