/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import org.openconcerto.sql.model.SQLField;

public class DeviseNumericCellEditor
extends AbstractCellEditor
implements MouseListener,
TableCellEditor {
    private JTextField textField = new JTextField();
    private float taxe = 19.6f;
    private int precision;

    public DeviseNumericCellEditor(SQLField field) {
        this.textField.setBorder(new LineBorder(Color.black));
        this.textField.setHorizontalAlignment(4);
        this.precision = field.getType().getDecimalDigits();
        this.textField.addKeyListener(new KeyAdapter(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void keyTyped(KeyEvent keyEvent) {
                char keychar = keyEvent.getKeyChar();
                if (keychar == '\b') {
                    return;
                }
                int pointPosition = DeviseNumericCellEditor.this.textField.getText().indexOf(46);
                if (Character.isDigit(keychar)) {
                    if (pointPosition <= -1) return;
                    if (DeviseNumericCellEditor.this.textField.getSelectedText() != null) return;
                    if (DeviseNumericCellEditor.this.textField.getCaretPosition() <= pointPosition) {
                        return;
                    }
                    if (DeviseNumericCellEditor.this.textField.getText().substring(pointPosition).length() <= DeviseNumericCellEditor.this.precision) {
                        return;
                    }
                }
                if (keychar == '.' && DeviseNumericCellEditor.this.textField.getText().indexOf(46) < 0) {
                    return;
                }
                if (keychar == '-' && DeviseNumericCellEditor.this.textField.getText().indexOf(45) < 0 && DeviseNumericCellEditor.this.textField.getCaretPosition() == 0) {
                    return;
                }
                keyEvent.consume();
            }
        });
        this.textField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DeviseNumericCellEditor.this.textField.selectAll();
            }
        });
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        if (e instanceof MouseEvent) {
            return ((MouseEvent)e).getClickCount() >= 2;
        }
        return super.isCellEditable(e);
    }

    @Override
    public Object getCellEditorValue() {
        if (this.textField.getText().trim().length() > 0) {
            return new BigDecimal(this.textField.getText());
        }
        return BigDecimal.ZERO;
    }

    public void setConvertToTTCEnable(boolean b) {
        if (b) {
            this.textField.addMouseListener(this);
        } else {
            this.textField.removeMouseListener(this);
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.textField.setText(value == null ? "0" : ((BigDecimal)value).toString());
        this.textField.selectAll();
        this.textField.grabFocus();
        return this.textField;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.textField.getText().trim().length() > 0 && e.getButton() == 3) {
            JPopupMenu menuDroit = new JPopupMenu();
            menuDroit.add(new AbstractAction("Convertir en HT (TVA " + this.taxe + ")"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String s = DeviseNumericCellEditor.this.textField.getText().trim();
                    if (s.length() > 0) {
                        BigDecimal taux = new BigDecimal(DeviseNumericCellEditor.this.taxe).movePointLeft(2).add(BigDecimal.ONE);
                        BigDecimal prixTTC = new BigDecimal(s);
                        BigDecimal divide = prixTTC.divide(taux, MathContext.DECIMAL128);
                        divide = divide.setScale(DeviseNumericCellEditor.this.precision, RoundingMode.HALF_UP);
                        DeviseNumericCellEditor.this.textField.setText(divide.toString());
                    }
                }
            });
            menuDroit.pack();
            menuDroit.show(e.getComponent(), e.getPoint().x, e.getPoint().y);
            menuDroit.setVisible(true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

