/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.collection.UnmodifiableCollection;

public class CollectionUtils {
    private static Integer INTEGER_ONE = new Integer(1);
    public static final Collection EMPTY_COLLECTION = UnmodifiableCollection.decorate(new ArrayList());

    public static Collection intersection(Collection a, Collection b) {
        ArrayList list = new ArrayList();
        Map mapa = CollectionUtils.getCardinalityMap(a);
        Map mapb = CollectionUtils.getCardinalityMap(b);
        HashSet elts = new HashSet(a);
        elts.addAll(b);
        Iterator it = elts.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            int i = 0;
            int m = Math.min(CollectionUtils.getFreq(obj, mapa), CollectionUtils.getFreq(obj, mapb));
            while (i < m) {
                list.add(obj);
                ++i;
            }
        }
        return list;
    }

    public static Collection subtract(Collection a, Collection b) {
        ArrayList list = new ArrayList(a);
        Iterator it = b.iterator();
        while (it.hasNext()) {
            ((AbstractCollection)list).remove(it.next());
        }
        return list;
    }

    public static boolean containsAny(Collection coll1, Collection coll2) {
        if (coll1.size() < coll2.size()) {
            Iterator it = coll1.iterator();
            while (it.hasNext()) {
                if (!coll2.contains(it.next())) continue;
                return true;
            }
        } else {
            Iterator it = coll2.iterator();
            while (it.hasNext()) {
                if (!coll1.contains(it.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static Map getCardinalityMap(Collection coll) {
        HashMap count = new HashMap();
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            Integer c = (Integer)count.get(obj);
            if (c == null) {
                count.put(obj, INTEGER_ONE);
                continue;
            }
            count.put(obj, new Integer(c + 1));
        }
        return count;
    }

    public static Object find(Collection collection, Predicate predicate) {
        if (collection != null && predicate != null) {
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                Object item = iter.next();
                if (!predicate.evaluate(item)) continue;
                return item;
            }
        }
        return null;
    }

    public static void filter(Collection collection, Predicate predicate) {
        if (collection != null && predicate != null) {
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                if (predicate.evaluate(it.next())) continue;
                it.remove();
            }
        }
    }

    public static Collection select(Collection inputCollection, Predicate predicate) {
        ArrayList answer = new ArrayList(inputCollection.size());
        CollectionUtils.select(inputCollection, predicate, answer);
        return answer;
    }

    public static void select(Collection inputCollection, Predicate predicate, Collection outputCollection) {
        if (inputCollection != null && predicate != null) {
            Iterator iter = inputCollection.iterator();
            while (iter.hasNext()) {
                Object item = iter.next();
                if (!predicate.evaluate(item)) continue;
                outputCollection.add(item);
            }
        }
    }

    private static final int getFreq(Object obj, Map freqMap) {
        Integer count = (Integer)freqMap.get(obj);
        if (count != null) {
            return count;
        }
        return 0;
    }
}

