/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import gnu.io.CommDriver;
import gnu.io.CommPort;
import gnu.io.CommPortOwnershipListener;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import java.util.Enumeration;
import java.util.Vector;

public class CommPortIdentifier {
    private String PortName;
    private boolean Available = true;
    private String Owner;
    private CommPort commport;
    private CommDriver RXTXDriver;
    static CommPortIdentifier CommPortIndex;
    CommPortIdentifier next;
    private int PortType;
    static Object Sync;
    Vector ownershipListener;

    CommPortIdentifier(String string, CommPort commPort, int n, CommDriver commDriver) {
        this.PortName = string;
        this.commport = commPort;
        this.PortType = n;
        this.next = null;
        this.RXTXDriver = commDriver;
    }

    public static void addPortName(String string, int n, CommDriver commDriver) {
        CommPortIdentifier.AddIdentifierToList(new CommPortIdentifier(string, null, n, commDriver));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void AddIdentifierToList(CommPortIdentifier commPortIdentifier) {
        Object object = Sync;
        synchronized (object) {
            if (CommPortIndex == null) {
                CommPortIndex = commPortIdentifier;
            } else {
                CommPortIdentifier commPortIdentifier2 = CommPortIndex;
                while (commPortIdentifier2.next != null) {
                    commPortIdentifier2 = commPortIdentifier2.next;
                }
                commPortIdentifier2.next = commPortIdentifier;
            }
        }
    }

    public String getCurrentOwner() {
        return this.Owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommPortIdentifier getPortIdentifier(String string) throws NoSuchPortException {
        CommPortIdentifier commPortIdentifier = CommPortIndex;
        Object object = Sync;
        synchronized (object) {
            while (commPortIdentifier != null && !commPortIdentifier.PortName.equals(string)) {
                commPortIdentifier = commPortIdentifier.next;
            }
        }
        if (commPortIdentifier != null) {
            return commPortIdentifier;
        }
        throw new NoSuchPortException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommPortIdentifier getPortIdentifier(CommPort commPort) throws NoSuchPortException {
        CommPortIdentifier commPortIdentifier = CommPortIndex;
        Object object = Sync;
        synchronized (object) {
            while (commPortIdentifier != null && commPortIdentifier.commport != commPort) {
                commPortIdentifier = commPortIdentifier.next;
            }
        }
        if (commPortIdentifier != null) {
            return commPortIdentifier;
        }
        throw new NoSuchPortException();
    }

    public synchronized boolean isCurrentlyOwned() {
        return !this.Available;
    }

    private native String native_psmisc_report_owner(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CommPort open(String string, int n) throws PortInUseException {
        if (!this.Available) {
            Object object = Sync;
            synchronized (object) {
                this.fireOwnershipEvent(3);
                try {
                    this.wait(n);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (!this.Available) {
            throw new PortInUseException(this.getCurrentOwner());
        }
        if (this.commport == null) {
            this.commport = this.RXTXDriver.getCommPort(this.PortName, this.PortType);
        }
        if (this.commport != null) {
            this.Owner = string;
            this.Available = false;
            this.fireOwnershipEvent(1);
            return this.commport;
        }
        throw new PortInUseException(this.native_psmisc_report_owner(this.PortName));
    }

    synchronized void internalClosePort() {
        this.Owner = null;
        this.Available = true;
        this.commport = null;
        this.notifyAll();
        this.fireOwnershipEvent(2);
    }

    void fireOwnershipEvent(int n) {
        if (this.ownershipListener != null) {
            Enumeration enumeration = this.ownershipListener.elements();
            while (enumeration.hasMoreElements()) {
                CommPortOwnershipListener commPortOwnershipListener = (CommPortOwnershipListener)enumeration.nextElement();
                commPortOwnershipListener.ownershipChange(n);
            }
        }
    }

    static {
        Object object;
        Sync = new Object();
        try {
            object = (CommDriver)Class.forName("gnu.io.RXTXCommDriver").newInstance();
            object.initialize();
        }
        catch (Throwable throwable) {
            System.err.println(throwable + " thrown while loading " + "gnu.io.RXTXCommDriver");
        }
        object = System.getProperty("os.name");
        if (((String)object).toLowerCase().indexOf("linux") == -1) {
            // empty if block
        }
        System.loadLibrary("rxtxSerial");
    }
}

