/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.cc;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.cc.TransformedSet;

public class TransformedMap<K, KT, V>
extends AbstractMap<KT, V> {
    private final Map<K, V> map;
    private final ITransformer<K, KT> transf;
    private final ITransformer<KT, K> invTransf;

    public TransformedMap(Map<K, V> map, ITransformer<K, KT> transf, ITransformer<KT, K> invTransf) {
        this.map = map;
        this.transf = transf;
        this.invTransf = invTransf;
    }

    @Override
    public final void clear() {
        this.map.clear();
    }

    @Override
    public final boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public final int size() {
        return this.map.size();
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.map.containsKey(this.invTransf.transformChecked(key));
    }

    @Override
    public final V get(Object key) {
        return this.map.get(this.invTransf.transformChecked(key));
    }

    @Override
    public final V remove(Object key) {
        return this.map.remove(this.invTransf.transformChecked(key));
    }

    @Override
    public final Set<KT> keySet() {
        return new TransformedSet<K, KT>(this.map.keySet(), this.transf, this.invTransf);
    }

    @Override
    public final Collection<V> values() {
        return this.map.values();
    }

    @Override
    public final boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<KT, V>> entrySet() {
        return new TransformedSet(this.map.entrySet(), new ITransformer<Map.Entry<K, V>, Map.Entry<KT, V>>(){

            public Map.Entry<KT, V> transformChecked(final Map.Entry<K, V> input) {
                return new Map.Entry<KT, V>(){

                    @Override
                    public final KT getKey() {
                        return TransformedMap.this.transf.transformChecked(input.getKey());
                    }

                    @Override
                    public final V getValue() {
                        return input.getValue();
                    }

                    @Override
                    public final V setValue(V value) {
                        return input.setValue(value);
                    }
                };
            }
        }, new ITransformer<Map.Entry<KT, V>, Map.Entry<K, V>>(){

            public Map.Entry<K, V> transformChecked(final Map.Entry<KT, V> input) {
                return new Map.Entry<K, V>(){

                    @Override
                    public final K getKey() {
                        return TransformedMap.this.invTransf.transformChecked(input.getKey());
                    }

                    @Override
                    public final V getValue() {
                        return input.getValue();
                    }

                    @Override
                    public final V setValue(V value) {
                        return input.setValue(value);
                    }
                };
            }
        });
    }

    @Override
    public final V put(KT key, V value) {
        return this.map.put(this.invTransf.transformChecked(key), value);
    }
}

