/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class PropertiesUtils {
    public static final Properties createFromMap(Map<String, String> map) {
        Properties res = new Properties();
        for (Map.Entry<String, String> e : map.entrySet()) {
            res.setProperty(e.getKey(), e.getValue());
        }
        return res;
    }

    public static final Properties createFromResource(Class<?> ctxt, String rsrc) throws IOException {
        return PropertiesUtils.create(ctxt.getResourceAsStream(rsrc));
    }

    protected static final Properties create(InputStream stream) throws IOException {
        return PropertiesUtils.create(stream, true);
    }

    public static final Properties create(InputStream stream, boolean close) throws IOException {
        if (stream != null) {
            try {
                Properties res = new Properties();
                res.load(stream);
                Properties properties = res;
                return properties;
            }
            finally {
                if (close) {
                    stream.close();
                }
            }
        }
        return null;
    }

    public static final void load(Properties props, Properties toLoad) {
        for (String key : toLoad.stringPropertyNames()) {
            String value = toLoad.getProperty(key);
            assert (value != null);
            props.setProperty(key, value);
        }
    }
}

