/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.openconcerto.utils.CollectionMap2;
import org.openconcerto.utils.CollectionMap2Itf;
import org.openconcerto.utils.ListAbstractMap;

public class ListMap<K, V>
extends ListAbstractMap<K, List<V>, V>
implements CollectionMap2Itf.ListMapItf<K, V> {
    private static ListMap EMPTY = new ListMap(Collections.emptyMap(), CollectionMap2.Mode.NULL_FORBIDDEN){

        @Override
        public ListMap clone() {
            return this;
        }
    };

    private static <K, V> ListMap<K, V> singleton(K key, List<V> values, boolean immutable) {
        List<V> coll = immutable ? values : Collections.unmodifiableList(values);
        return new ListMap<K, V>((Map)Collections.singletonMap(key, coll), DEFAULT_MODE){

            @Override
            public ListMap<K, V> clone() {
                return this;
            }
        };
    }

    public static <K, V> ListMap<K, V> singleton(K key, V value) {
        return ListMap.singleton(key, Collections.singletonList(value), true);
    }

    public ListMap() {
    }

    public ListMap(Map<K, List<V>> delegate, CollectionMap2.Mode mode) {
        super(delegate, mode);
    }

    @Override
    public List<V> createCollection(Collection<? extends V> v) {
        return new ArrayList<V>(v);
    }

    @Override
    public ListMap<K, V> clone() throws CloneNotSupportedException {
        return (ListMap)super.clone();
    }
}

