/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.ITransformer;

public abstract class SQLCreateTableBase<T extends SQLCreateTableBase<T>>
extends ChangeTable<T> {
    private List<String> pk;
    private boolean tmp;

    public SQLCreateTableBase(SQLSyntax syntax, String rootName, String name) {
        super(syntax, rootName, name);
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.pk = Collections.emptyList();
        this.tmp = false;
    }

    @Override
    protected String getConstraintPrefix() {
        return "";
    }

    @Override
    public final T addColumn(String name, String definition) {
        return (T)((SQLCreateTableBase)this.addClause(String.valueOf(SQLBase.quoteIdentifier(name)) + " " + definition, ChangeTable.ClauseType.ADD_COL));
    }

    public final T setPrimaryKey(String ... fields) {
        return this.setPrimaryKey(Arrays.asList(fields));
    }

    public final T setPrimaryKey(List<String> fields) {
        this.checkPK();
        this.pk = Collections.unmodifiableList(new ArrayList<String>(fields));
        return (T)((SQLCreateTableBase)this.thisAsT());
    }

    public List<String> getPrimaryKey() {
        return this.pk;
    }

    protected void checkPK() {
    }

    @Override
    public String asString(ChangeTable.NameTransformer transf) {
        return this.asString(transf, true);
    }

    public final String asString(ChangeTable.NameTransformer transf, boolean includeConstraint) {
        return this.asString(transf, includeConstraint ? EnumSet.allOf(ChangeTable.ClauseType.class) : EnumSet.complementOf(EnumSet.of(ChangeTable.ClauseType.ADD_CONSTRAINT)));
    }

    @Override
    protected final String asString(ChangeTable.NameTransformer transf, ChangeTable.ConcatStep step) {
        switch (step) {
            case ALTER_TABLE: {
                return this.asString(transf, step.getTypes());
            }
            case ADD_INDEX: 
            case ADD_FOREIGN: {
                return ((AlterTable)new AlterTable(this.getSyntax(), this.getRootName(), this.getName()).mutateTo(this)).asString(transf, step);
            }
        }
        return null;
    }

    private String asString(ChangeTable.NameTransformer transf, Set<ChangeTable.ClauseType> types) {
        StringBuffer res = new StringBuffer(512);
        SQLName transformedName = transf.transformTableName(new SQLName(this.getRootName(), this.getName()));
        SQLName tableName = this.tmp ? new SQLName(transformedName.getName()) : transformedName;
        ArrayList<String> genClauses = new ArrayList<String>(this.getClauses(tableName, types));
        this.modifyClauses(genClauses);
        if (this.pk.size() > 0 && types.contains((Object)ChangeTable.ClauseType.ADD_COL)) {
            genClauses.add("PRIMARY KEY (" + CollectionUtils.join(this.pk, ",", new ITransformer<String, String>(){

                public String transformChecked(String input) {
                    return SQLBase.quoteIdentifier(input);
                }
            }) + ")");
        }
        if (types.contains((Object)ChangeTable.ClauseType.ADD_CONSTRAINT)) {
            genClauses.addAll(this.getForeignConstraints(transf));
        }
        if (genClauses.size() > 0) {
            if (this.tmp) {
                res.append("CREATE TEMPORARY TABLE ");
            } else {
                res.append("CREATE TABLE ");
            }
            res.append(String.valueOf(tableName.quote()) + " (\n");
            res.append(CollectionUtils.join(genClauses, ",\n"));
            res.append(") ");
            res.append(this.getSyntax().getCreateTableSuffix());
            res.append(";");
        }
        this.outClausesAsString(res, tableName, types);
        return res.toString();
    }

    protected void modifyClauses(List<String> genClauses) {
    }
}

