/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSyntaxMySQL;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.TablesMap;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.Tuple2;

class SQLSyntaxMS
extends SQLSyntax {
    private static final Pattern nullPatrn = Pattern.compile("\\N", 16);
    private static final Pattern backSlashPatrn = Pattern.compile("\\\"", 16);
    private static final Pattern newlinePatrn = Pattern.compile("\n");
    private static final Pattern newlineAndIDPatrn = Pattern.compile("\n(?=\\p{Digit}+\\|)");
    private static final Pattern commaSepPatrn = Pattern.compile("(?<!\\\\)\",\"");
    private static final Pattern firstLastQuotePatrn = Pattern.compile("(^\")|(\"$)", 8);
    private static final Pattern boolTPatrn = Pattern.compile("(?<=\\|)t\\|");
    private static final Pattern boolFPatrn = Pattern.compile("(?<=\\|)f\\|");
    private static final Pattern boolTEndPatrn = Pattern.compile("\\|t$", 8);
    private static final Pattern boolFEndPatrn = Pattern.compile("\\|f$", 8);
    private static final Pattern dateWithOffsetPatrn = Pattern.compile("(\\|\\p{Digit}{4}-\\p{Digit}{2}-\\p{Digit}{2} \\p{Digit}{2}:\\p{Digit}{2}:\\p{Digit}{2}(.\\p{Digit}{1,3})?)\\+\\p{Digit}{2}");

    SQLSyntaxMS() {
        super(SQLSystem.MSSQL);
        this.typeNames.addAll(Boolean.class, "bit");
        this.typeNames.addAll(Short.class, "smallint");
        this.typeNames.addAll(Integer.class, "unsigned smallint", "int");
        this.typeNames.addAll(Long.class, "unsigned int", "bigint");
        this.typeNames.addAll(BigDecimal.class, "unsigned bigint", "decimal", "numeric", "smallmoney", "money");
        this.typeNames.addAll(Float.class, "real");
        this.typeNames.addAll(Double.class, "float");
        this.typeNames.addAll(Timestamp.class, "smalldatetime", "datetime");
        this.typeNames.addAll(Date.class, "date");
        this.typeNames.addAll(Time.class, "time");
        this.typeNames.addAll(Blob.class, "image", "varbinary", "binary");
        this.typeNames.addAll(Clob.class, "text", "ntext", "unitext");
        this.typeNames.addAll(String.class, "char", "varchar", "nchar", "nvarchar", "unichar", "univarchar");
    }

    @Override
    public String getAuto() {
        return " int IDENTITY";
    }

    @Override
    public String getDateAndTimeType() {
        return "datetime2";
    }

    @Override
    public String getBooleanType() {
        return "bit";
    }

    @Override
    public String transfDefaultJDBC2SQL(SQLField f) {
        Object def = f.getDefaultValue();
        if (def == null) {
            return null;
        }
        String stringDef = def.toString();
        while (stringDef.charAt(0) == '(' && stringDef.charAt(stringDef.length() - 1) == ')') {
            stringDef = stringDef.substring(1, stringDef.length() - 1);
        }
        if (f.getType().getJavaType() == Boolean.class) {
            return stringDef.equals("'true'") ? "true" : "false";
        }
        return stringDef;
    }

    @Override
    protected String transfDefault(SQLField f, String castless) {
        if (castless != null && f.getType().getJavaType() == Boolean.class) {
            return castless.equals("TRUE") ? "'true'" : "'false'";
        }
        return castless;
    }

    public Map<String, Object> normalizeIndexInfo(Map m) {
        if (this.getSystem().getJDBCName().equals("sqlserver")) {
            m.put("NON_UNIQUE", ((Number)m.get("NON_UNIQUE")).intValue() != 0);
        }
        return m;
    }

    protected String setNullable(SQLField f, boolean b) {
        return "ALTER COLUMN " + f.getQuotedName() + " SET " + (b ? "" : "NOT") + " NULL";
    }

    @Override
    public List<String> getAlterField(SQLField f, Set<SQLField.Properties> toAlter, String type, String defaultVal, Boolean nullable) {
        ArrayList<String> res = new ArrayList<String>();
        if (toAlter.contains((Object)SQLField.Properties.TYPE)) {
            String newDef = toAlter.contains((Object)SQLField.Properties.DEFAULT) ? defaultVal : this.getDefault(f, type);
            boolean newNullable = toAlter.contains((Object)SQLField.Properties.NULLABLE) ? nullable.booleanValue() : this.getNullable(f);
            res.add("ALTER COLUMN " + f.getQuotedName() + " " + this.getFieldDecl(type, newDef, newNullable));
        } else {
            if (toAlter.contains((Object)SQLField.Properties.NULLABLE)) {
                res.add(this.setNullable(f, nullable));
            }
            if (toAlter.contains((Object)SQLField.Properties.DEFAULT)) {
                res.add(this.setDefault(f, defaultVal));
            }
        }
        return res;
    }

    @Override
    protected Tuple2<Boolean, String> getCast() {
        return null;
    }

    @Override
    public void _loadData(File f, SQLTable t) throws IOException {
        String winNL;
        String sansNull;
        String data = FileUtils.read(f, "UTF-8");
        String tmp = sansNull = nullPatrn.matcher(data).replaceAll("\"\"");
        tmp = tmp.substring(tmp.indexOf(10) + 1, tmp.length());
        tmp = tmp.replace('|', ' ');
        tmp = commaSepPatrn.matcher(tmp).replaceAll("|");
        tmp = firstLastQuotePatrn.matcher(tmp).replaceAll("");
        tmp = backSlashPatrn.matcher(tmp).replaceAll(String.valueOf('\"'));
        tmp = boolTPatrn.matcher(tmp).replaceAll("1|");
        tmp = boolFPatrn.matcher(tmp).replaceAll("0|");
        tmp = boolTEndPatrn.matcher(tmp).replaceAll("|1");
        tmp = boolFEndPatrn.matcher(tmp).replaceAll("|0");
        tmp = dateWithOffsetPatrn.matcher(tmp).replaceAll("$1");
        if (t.isRowable() && t.getOrderedFields().get(0) != t.getKey()) {
            throw new IllegalArgumentException("MS needs ID first for " + t + " " + t.getOrderedFields());
        }
        if (t.isRowable()) {
            winNL = newlineAndIDPatrn.matcher(tmp).replaceAll("\r\n");
            winNL = String.valueOf(winNL.substring(0, winNL.length() - 1)) + "\r\n";
        } else {
            winNL = newlinePatrn.matcher(tmp).replaceAll("\r\n");
        }
        if (t.getName().equals("RIGHT")) {
            System.err.println("SQLSyntaxMS._loadData()\n\n" + tmp);
        }
        File temp = File.createTempFile("mssql_loadData", ".txt", new File("."));
        FileUtils.write(winNL, temp, "UTF-16", false);
        this.checkServerLocalhost(t);
        t.getDBSystemRoot().getDataSource().execute(t.getBase().quote("bulk insert %f from %s with ( DATAFILETYPE='widechar', FIELDTERMINATOR = '|', FIRSTROW=1, KEEPIDENTITY ) ;", t, temp.getAbsolutePath()));
        temp.delete();
    }

    @Override
    public boolean supportMultiAlterClause() {
        return false;
    }

    @Override
    public String getNullIsDataComparison(String x, boolean eq, String y) {
        String nullSafe = String.valueOf(x) + " = " + y + " or ( " + x + " is null and " + y + " is null)";
        if (eq) {
            return nullSafe;
        }
        return String.valueOf(x) + " <> " + y + " or (" + x + " is null and " + y + " is not null) " + " or (" + x + " is not null and " + y + " is null) ";
    }

    @Override
    public String getFunctionQuery(SQLBase b, Set<String> schemas) {
        return "  select name, schema_name(schema_id) as \"schema\", cast(OBJECT_DEFINITION(object_id) as varchar(4096)) as \"src\"\n  FROM " + new SQLName(b.getName(), "sys", "objects") + "\n" + "  where type IN ('FN', 'IF', 'TF') and SCHEMA_NAME( schema_id ) in (" + SQLSyntaxMS.quoteStrings(b, schemas) + ") ";
    }

    @Override
    public String getTriggerQuery(SQLBase b, TablesMap tables) {
        return "SELECT  trig.name as \"TRIGGER_NAME\", SCHEMA_NAME( tabl.schema_id ) as \"TABLE_SCHEMA\", tabl.name as \"TABLE_NAME\",  null as \"ACTION\", cast(OBJECT_DEFINITION(trig.object_id) as varchar(4096)) as \"SQL\"\nFROM " + new SQLName(b.getName(), "sys", "triggers") + " trig\n" + "join " + new SQLName(b.getName(), "sys", "objects") + " tabl on trig.parent_id = tabl.object_id\n" + this.getTablesMapJoin(b, tables, "SCHEMA_NAME( tabl.schema_id )", "tabl.name");
    }

    @Override
    public String getColumnsQuery(SQLBase b, TablesMap tables) {
        return null;
    }

    @Override
    public List<Map<String, Object>> getConstraints(SQLBase b, TablesMap tables) throws SQLException {
        String where = this.getTablesMapJoin(b, tables, "SCHEMA_NAME(t.schema_id)", "t.name");
        String sel = "SELECT SCHEMA_NAME(t.schema_id) AS \"TABLE_SCHEMA\", t.name AS \"TABLE_NAME\", k.name AS \"CONSTRAINT_NAME\", case k.type when 'UQ' then 'UNIQUE' when 'PK' then 'PRIMARY KEY' end as \"CONSTRAINT_TYPE\", col_name(c.object_id, c.column_id) AS \"COLUMN_NAME\", c.key_ordinal AS \"ORDINAL_POSITION\"\nFROM sys.key_constraints k\nJOIN sys.index_columns c ON c.object_id = k.parent_object_id AND c.index_id = k.unique_index_id\nJOIN sys.tables t ON t.object_id = k.parent_object_id\n" + where + "\nUNION ALL\n" + "SELECT SCHEMA_NAME(t.schema_id) AS \"TABLE_SCHEMA\", t.name AS \"TABLE_NAME\", k.name AS \"CONSTRAINT_NAME\", 'CHECK' as \"CONSTRAINT_TYPE\", col.name AS \"COLUMN_NAME\", 1 AS \"ORDINAL_POSITION\"\n" + "FROM sys.check_constraints k\n" + "join sys.tables t on k.parent_object_id = t.object_id\n" + "left join sys.columns col on k.parent_column_id = col.column_id and col.object_id = t.object_id\n" + where;
        List res = (List)b.getDBSystemRoot().getDataSource().execute(sel, new IResultSetHandler(SQLDataSource.MAP_LIST_HANDLER, false));
        SQLSyntaxMySQL.mergeColumnNames(res);
        return res;
    }

    @Override
    public String getFormatTimestamp(String sqlTS, boolean basic) {
        String extended = "CONVERT(nvarchar(30), " + sqlTS + ", 126) + '000'";
        if (basic) {
            return "replace( replace( " + extended + ", '-', ''), ':' , '' )";
        }
        return extended;
    }
}

