/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.sql.model.AliasedField;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesCluster;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.model.graph.Step;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.RecursionType;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.ITransformer;

public class SQLRowValuesListFetcher {
    private final SQLRowValues graph;
    private final Path descendantPath;
    private ITransformer<SQLSelect, SQLSelect> selTransf;
    private Integer selID;
    private Set<Path> ordered;
    private boolean descendantsOrdered;
    private SQLRowValues minGraph;
    private boolean includeForeignUndef;
    private SQLSelect frozen;
    private final Map<Path, Map<Path, SQLRowValuesListFetcher>> grafts;
    private static final ExecutorService exec = new ThreadPoolExecutor(0, 2, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());

    private static Path computePath(SQLRowValues graph) {
        final AtomicReference<Object> res = new AtomicReference<Object>(null);
        graph.getGraph().walk(graph, null, new ITransformer<SQLRowValuesCluster.State<Path>, Path>(){

            public Path transformChecked(SQLRowValuesCluster.State<Path> input) {
                Collection<SQLRowValues> referentRows = input.getCurrent().getReferentRows();
                int size = referentRows.size();
                if (size > 1) {
                    List<SQLRowValues> toPrint = SQLRowValues.trim(referentRows);
                    throw new IllegalArgumentException(input.getCurrent() + " is referenced by " + toPrint + "\nat " + input.getPath());
                }
                if (size == 0) {
                    if (res.get() == null) {
                        res.set(input.getPath());
                    } else {
                        throw new IllegalStateException();
                    }
                }
                return input.getAcc();
            }
        }, RecursionType.BREADTH_FIRST, Link.Direction.REFERENT, true);
        assert (res.get() != null);
        return res.get();
    }

    private static final ListMap<Tuple2<Path, Number>, SQLRowValues> createCollectionMap() {
        return new ListMap<Tuple2<Path, Number>, SQLRowValues>(){

            @Override
            public List<SQLRowValues> createCollection(Collection<? extends SQLRowValues> v) {
                ArrayList<SQLRowValues> res = new ArrayList<SQLRowValues>(8);
                res.addAll(v);
                return res;
            }
        };
    }

    public SQLRowValuesListFetcher(SQLRowValues graph) {
        this(graph, false);
    }

    public SQLRowValuesListFetcher(SQLRowValues graph, boolean referents) {
        this(graph, referents ? SQLRowValuesListFetcher.computePath(graph) : null);
    }

    public SQLRowValuesListFetcher(SQLRowValues graph, Path referentPath) {
        this(graph, referentPath, true);
    }

    SQLRowValuesListFetcher(SQLRowValues graph, Path referentPath, boolean prune) {
        this.graph = graph.deepCopy();
        Path path = this.descendantPath = referentPath == null ? Path.get(graph.getTable()) : referentPath;
        if (!this.descendantPath.isDirection(Link.Direction.REFERENT)) {
            throw new IllegalArgumentException("path is not (exclusively) referent : " + this.descendantPath);
        }
        SQLRowValues descRow = this.graph.followPath(this.descendantPath);
        if (descRow == null) {
            throw new IllegalArgumentException("path is not contained in the passed rowValues : " + referentPath + "\n" + this.graph.printTree());
        }
        assert (this.descendantPath.getFirst() == this.graph.getTable() && this.descendantPath.isSingleLink());
        if (prune) {
            this.graph.getGraph().walk(descRow, null, new ITransformer<SQLRowValuesCluster.State<Object>, Object>(){

                public Object transformChecked(SQLRowValuesCluster.State<Object> input) {
                    if (input.getFrom() == null) {
                        input.getCurrent().clearReferents();
                    } else {
                        input.getCurrent().retainReferent(input.getPrevious());
                    }
                    return null;
                }
            }, RecursionType.BREADTH_FIRST, Link.Direction.FOREIGN);
        }
        for (SQLRowValues curr : this.getGraph().getGraph().getItems()) {
            if (curr.hasID()) continue;
            curr.setID(null);
        }
        this.selTransf = null;
        this.selID = null;
        this.ordered = Collections.emptySet();
        this.descendantsOrdered = false;
        this.minGraph = null;
        this.includeForeignUndef = false;
        this.frozen = null;
        this.grafts = new HashMap<Path, Map<Path, SQLRowValuesListFetcher>>(4);
    }

    public final boolean isFrozen() {
        return this.frozen != null;
    }

    private final void checkFrozen() {
        if (this.isFrozen()) {
            throw new IllegalStateException("this has been frozen: " + this);
        }
    }

    public SQLRowValues getGraph() {
        return this.graph;
    }

    private final boolean isPathRequired(Path p) {
        return this.minGraph != null && this.minGraph.followPath(p) != null;
    }

    private boolean fetchReferents() {
        return this.descendantPath.length() > 0;
    }

    public void setSelTransf(ITransformer<SQLSelect, SQLSelect> selTransf) {
        this.checkFrozen();
        this.selTransf = selTransf;
    }

    public final ITransformer<SQLSelect, SQLSelect> getSelTransf() {
        return this.selTransf;
    }

    public final Integer getSelID() {
        return this.selID;
    }

    public final SQLRowValuesListFetcher setOrdered(boolean b) {
        this.setOrder(b ? Collections.singleton(Path.get(this.getGraph().getTable())) : Collections.emptySet(), true);
        this.setReferentsOrdered(b, false);
        return this;
    }

    private final SQLRowValuesListFetcher setOrder(Collection<Path> order, boolean safeVal) {
        this.checkFrozen();
        for (Path p : order) {
            if (this.getGraph().followPath(p) != null) continue;
            throw new IllegalArgumentException("Path not in this " + p);
        }
        this.ordered = safeVal ? (Set<Path>)order : Collections.unmodifiableSet(new LinkedHashSet<Path>(order));
        return this;
    }

    public final Set<Path> getOrder() {
        return this.ordered;
    }

    public final SQLRowValuesListFetcher setReferentsOrdered(boolean b, boolean rec) {
        this.descendantsOrdered = b;
        if (rec) {
            for (Map<Path, SQLRowValuesListFetcher> m : this.grafts.values()) {
                for (SQLRowValuesListFetcher f : m.values()) {
                    f.setReferentsOrdered(b, rec);
                }
            }
        }
        return this;
    }

    public final boolean areReferentsOrdered() {
        return this.descendantsOrdered;
    }

    private final void addFields(SQLSelect sel, SQLRowValues vals, String alias) {
        for (String fieldName : vals.getFields()) {
            sel.addSelect(new AliasedField(vals.getTable().getField(fieldName), alias));
        }
    }

    public final SQLSelect getReq() {
        if (this.isFrozen()) {
            return this.frozen;
        }
        final SQLTable t = this.getGraph().getTable();
        SQLSelect sel = new SQLSelect();
        if (this.includeForeignUndef) {
            sel.setExcludeUndefined(false);
            sel.setExcludeUndefined(true, t);
        }
        this.walk(sel, new ITransformer<SQLRowValuesCluster.State<SQLSelect>, SQLSelect>(){

            public SQLSelect transformChecked(SQLRowValuesCluster.State<SQLSelect> input) {
                String alias;
                if (input.getFrom() != null) {
                    String joinType;
                    alias = SQLRowValuesListFetcher.getAlias(input.getAcc(), input.getPath());
                    String aliasPrev = input.getPath().length() == 1 ? null : input.getAcc().followPath(t.getName(), input.getPath().subPath(0, -1)).getAlias();
                    String string = joinType = SQLRowValuesListFetcher.this.isPathRequired(input.getPath()) ? "INNER" : "LEFT";
                    if (input.isBackwards()) {
                        input.getAcc().addBackwardJoin(joinType, alias, input.getFrom(), aliasPrev);
                    } else {
                        input.getAcc().addJoin(joinType, new AliasedField(input.getFrom(), aliasPrev), alias);
                    }
                } else {
                    alias = null;
                }
                SQLRowValuesListFetcher.this.addFields(input.getAcc(), input.getCurrent(), alias);
                return input.getAcc();
            }
        });
        for (Path p : this.getOrder()) {
            sel.addOrder(sel.followPath(t.getName(), p), false);
        }
        if (this.areReferentsOrdered()) {
            int descSize = this.descendantPath.length();
            int i = 1;
            while (i <= descSize) {
                sel.addOrder(sel.followPath(t.getName(), this.descendantPath.subPath(0, i)), false);
                ++i;
            }
        }
        if (this.selID != null) {
            sel.andWhere(new Where((FieldRef)t.getKey(), "=", (Object)this.selID));
        }
        return this.getSelTransf() == null ? sel : (SQLSelect)this.getSelTransf().transformChecked(sel);
    }

    static String getAlias(SQLSelect sel, Path path) {
        String res = "tAlias";
        int stop = path.length();
        int i = 0;
        while (i < stop) {
            res = String.valueOf(res) + "__" + path.getSingleStep(i).getName();
            ++i;
        }
        res = String.valueOf(res) + "__" + path.getTable(stop).getName();
        return sel.getUniqueAlias(res);
    }

    private <S> void walk(S sel, final ITransformer<SQLRowValuesCluster.State<S>, S> transf) {
        this.getGraph().getGraph().walk(this.getGraph(), sel, transf, RecursionType.BREADTH_FIRST, Link.Direction.FOREIGN);
        this.getGraph().getGraph().walk(this.getGraph(), sel, new ITransformer<SQLRowValuesCluster.State<S>, S>(){

            public S transformChecked(SQLRowValuesCluster.State<S> input) {
                Path p = input.getPath();
                if (p.getStep(0).isForeign().booleanValue()) {
                    throw new SQLRowValuesCluster.StopRecurseException().setCompletely(false);
                }
                Step lastStep = p.getStep(p.length() - 1);
                if (!lastStep.isForeign().booleanValue() && p.getDirection() != Link.Direction.REFERENT) {
                    throw new SQLRowValuesCluster.StopRecurseException().setCompletely(false);
                }
                return transf.transformChecked(input);
            }
        }, RecursionType.BREADTH_FIRST, Link.Direction.ANY, false);
    }

    public final List<SQLRowValues> fetch() {
        return this.fetch(true);
    }

    private final List<SQLRowValues> fetch(boolean merge) {
        List<SQLRowValues> merged;
        SQLSelect req = this.getReq();
        ArrayList<String> selectFields = new ArrayList<String>(req.getSelectFields().size());
        for (FieldRef f : req.getSelectFields()) {
            selectFields.add(f.getField().getName());
        }
        SQLTable table = this.getGraph().getTable();
        int graphSize = this.getGraph().getGraph().size();
        final ArrayList l = new ArrayList(graphSize);
        this.walk(0, new ITransformer<SQLRowValuesCluster.State<Integer>, Integer>(){

            public Integer transformChecked(SQLRowValuesCluster.State<Integer> input) {
                int index = l.size();
                l.add(new GraphNode(input));
                return index;
            }
        });
        assert (l.size() == graphSize) : "All nodes weren't explored once : " + l.size() + " != " + graphSize + "\n" + this.getGraph().printGraph();
        IResultSetHandler rsh = new IResultSetHandler(new RSH(selectFields, l), false);
        List<SQLRowValues> res = (List<SQLRowValues>)table.getBase().getDataSource().execute(req.asString(), (ResultSetHandler)rsh, false);
        List<SQLRowValues> list = merged = merge && this.fetchReferents() ? this.merge(res) : res;
        if (this.grafts.size() > 0) {
            for (Map.Entry<Path, Map<Path, SQLRowValuesListFetcher>> graftPlaceEntry : this.grafts.entrySet()) {
                Path graftPlace = graftPlaceEntry.getKey();
                Path mapPath = Path.get(graftPlace.getLast());
                HashSet<Number> ids = new HashSet<Number>();
                ListMap<Tuple2<Path, Number>, SQLRowValues> byRows = SQLRowValuesListFetcher.createCollectionMap();
                for (SQLRowValues sQLRowValues : merged) {
                    for (SQLRowValues graftPlaceVals : sQLRowValues.followPath(graftPlace, SQLRowValues.CreateMode.CREATE_NONE, false)) {
                        ids.add(graftPlaceVals.getIDNumber());
                        byRows.add(Tuple2.create(mapPath, graftPlaceVals.getIDNumber()), graftPlaceVals);
                    }
                }
                assert (ids.size() == byRows.size());
                for (Map.Entry entry : graftPlaceEntry.getValue().entrySet()) {
                    Path descendantPath = (Path)entry.getKey();
                    assert (descendantPath.getFirst() == graftPlace.getLast()) : descendantPath + " != " + graftPlace;
                    SQLRowValuesListFetcher graft = (SQLRowValuesListFetcher)entry.getValue();
                    SQLSelect toRestore = graft.frozen;
                    graft.frozen = new SQLSelect(graft.getReq()).andWhere(new Where(graft.getGraph().getTable().getKey(), ids));
                    List<SQLRowValues> referentVals = graft.fetch(false);
                    graft.frozen = toRestore;
                    this.merge(merged, referentVals, byRows, descendantPath);
                }
            }
        }
        return merged;
    }

    private static void link(List<GraphNode> l, List<List<SQLRowValues>> rows, int start, int stop) {
        int graphSize = l.size();
        int nodeIndex = 1;
        while (nodeIndex < graphSize) {
            GraphNode node = l.get(nodeIndex);
            String fromName = node.getFromName();
            int linkIndex = node.getLinkIndex();
            boolean backwards = node.isBackwards();
            int i = start;
            while (i < stop) {
                List<SQLRowValues> row = rows.get(i);
                SQLRowValues creatingVals = row.get(nodeIndex);
                if (creatingVals.hasID()) {
                    SQLRowValues valsToPut;
                    SQLRowValues valsToFill;
                    if (backwards) {
                        valsToFill = creatingVals;
                        valsToPut = row.get(linkIndex);
                    } else {
                        valsToFill = row.get(linkIndex);
                        valsToPut = creatingVals;
                    }
                    valsToFill.put(fromName, valsToPut, false);
                }
                ++i;
            }
            ++nodeIndex;
        }
    }

    private final List<SQLRowValues> merge(List<SQLRowValues> l) {
        return this.merge(l, l, null, this.descendantPath);
    }

    private final List<SQLRowValues> merge(List<SQLRowValues> tree, List<SQLRowValues> graft, ListMap<Tuple2<Path, Number>, SQLRowValues> graftPlaceRows, Path descendantPath) {
        boolean isGraft;
        boolean bl = isGraft = graftPlaceRows != null;
        assert (tree != graft == isGraft) : "Trying to graft onto itself";
        ArrayList<SQLRowValues> res = isGraft ? tree : new ArrayList<SQLRowValues>();
        ListMap<Tuple2<Path, Number>, SQLRowValues> map = isGraft ? graftPlaceRows : SQLRowValuesListFetcher.createCollectionMap();
        int stop = descendantPath.length();
        for (SQLRowValues v : graft) {
            boolean doAdd = true;
            SQLRowValues previous = null;
            int i = stop;
            while (i >= 0 && doAdd) {
                Path subPath = descendantPath.subPath(0, i);
                SQLRowValues desc = v.followPath(subPath);
                if (desc != null) {
                    Tuple2<Path, Number> row = Tuple2.create(subPath, desc.getIDNumber());
                    if (map.containsKey(row)) {
                        doAdd = false;
                        assert (((SQLRowValues)((List)map.get(row)).get(0)).getFields().containsAll(desc.getFields())) : "Discarding an SQLRowValues with more fields : " + desc;
                        if (previous != null) {
                            List destinationRows = (List)map.get(row);
                            int destinationSize = destinationRows.size();
                            assert (destinationSize > 0) : "Map contains row but have no corresponding value: " + row;
                            String ffName = descendantPath.getSingleStep(i).getName();
                            int j = 1;
                            while (j < destinationSize) {
                                SQLRowValues previousCopy = previous.deepCopy().put(ffName, destinationRows.get(j));
                                int k = stop;
                                while (k >= i + 1) {
                                    SQLRowValues descCopy = previousCopy.followPath(descendantPath.subPath(i + 1, k));
                                    if (descCopy != null) {
                                        Tuple2<Path, Number> rowCopy = Tuple2.create(descendantPath.subPath(0, k), descCopy.getIDNumber());
                                        assert (map.containsKey(rowCopy)) : "Since we already iterated with i";
                                        map.add(rowCopy, descCopy);
                                    }
                                    --k;
                                }
                                ++j;
                            }
                            previous.put(ffName, destinationRows.get(0));
                        }
                    } else {
                        map.add(row, desc);
                    }
                    previous = desc;
                }
                --i;
            }
            if (!doAdd) continue;
            assert (!isGraft) : "Adding graft values as tree values";
            res.add(v);
        }
        return res;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " for " + this.getGraph() + " with " + this.getSelID() + " and " + this.getSelTransf();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SQLRowValuesListFetcher) {
            SQLRowValuesListFetcher o = (SQLRowValuesListFetcher)obj;
            return this.getReq().equals(o.getReq()) && CompareUtils.equals(this.descendantPath, o.descendantPath) && this.grafts.equals(o.grafts);
        }
        return false;
    }

    public int hashCode() {
        return this.getReq().hashCode();
    }

    private static final class GraphNode {
        private final SQLTable t;
        private final int fieldCount;
        private final int linkIndex;
        private final Step from;

        private GraphNode(SQLRowValuesCluster.State<Integer> input) {
            this.t = input.getCurrent().getTable();
            this.fieldCount = input.getCurrent().size();
            this.linkIndex = input.getAcc();
            int length = input.getPath().length();
            this.from = length == 0 ? null : input.getPath().getStep(length - 1);
        }

        public final SQLTable getTable() {
            return this.t;
        }

        public final int getFieldCount() {
            return this.fieldCount;
        }

        public final int getLinkIndex() {
            return this.linkIndex;
        }

        public final String getFromName() {
            return this.from.getSingleField().getName();
        }

        public final boolean isBackwards() {
            return this.from.isForeign() == false;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.fieldCount;
            result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
            result = 31 * result + this.linkIndex;
            result = 31 * result + this.t.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GraphNode other = (GraphNode)obj;
            return this.fieldCount == other.fieldCount && this.linkIndex == other.linkIndex && this.t.equals(other.t) && CompareUtils.equals(this.from, other.from);
        }

        public String toString() {
            String link = this.from == null ? "" : " linked to " + this.getLinkIndex() + " by " + this.getFromName() + (this.isBackwards() ? " backwards" : " forewards");
            return String.valueOf(this.getFieldCount()) + " fields of " + this.getTable() + link;
        }
    }

    private static final class Linker
    implements Callable<Object> {
        private final List<GraphNode> l;
        private final List<List<SQLRowValues>> rows;
        private final int fromIndex;
        private final int toIndex;

        public Linker(List<GraphNode> l, List<List<SQLRowValues>> rows, int first, int last) {
            this.l = l;
            this.rows = rows;
            this.fromIndex = first;
            this.toIndex = last;
        }

        @Override
        public Object call() throws Exception {
            SQLRowValuesListFetcher.link(this.l, this.rows, this.fromIndex, this.toIndex);
            return null;
        }
    }

    private static final class RSH
    implements ResultSetHandler {
        private final List<String> selectFields;
        private final List<GraphNode> graphNodes;

        private RSH(List<String> selectFields, List<GraphNode> l) {
            this.selectFields = selectFields;
            this.graphNodes = l;
        }

        @Override
        public Object handle(ResultSet rs) throws SQLException {
            int i;
            List<GraphNode> l = this.graphNodes;
            int graphSize = l.size();
            int nextToLink = 0;
            ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
            ArrayList<SQLRowValues> res = new ArrayList<SQLRowValues>(64);
            List<List<SQLRowValues>> rows = Collections.synchronizedList(new ArrayList(64));
            while (rs.next()) {
                int rsIndex = 1;
                if (Thread.currentThread().isInterrupted()) {
                    throw new RTInterruptedException("interrupted while fetching");
                }
                ArrayList<SQLRowValues> arrayList = new ArrayList<SQLRowValues>(graphSize);
                i = 0;
                while (i < graphSize) {
                    GraphNode node = l.get(i);
                    SQLRowValues creatingVals = new SQLRowValues(node.getTable());
                    if (i == 0) {
                        res.add(creatingVals);
                    }
                    int stop = rsIndex + node.getFieldCount();
                    while (rsIndex < stop) {
                        try {
                            creatingVals.put(this.selectFields.get(rsIndex - 1), rs.getObject(rsIndex), false);
                        }
                        catch (SQLException e) {
                            throw new IllegalStateException("unable to fill " + creatingVals, e);
                        }
                        ++rsIndex;
                    }
                    arrayList.add(creatingVals);
                    ++i;
                }
                rows.add(arrayList);
                int currentCount = rows.size();
                if (currentCount % 1000 != 0) continue;
                futures.add(exec.submit(new Linker(l, rows, nextToLink, currentCount)));
                nextToLink = currentCount;
            }
            int rowSize = rows.size();
            assert (nextToLink > 0 == futures.size() > 0);
            if (nextToLink > 0) {
                futures.add(exec.submit(new Linker(l, rows, nextToLink, rowSize)));
            }
            if (rowSize > 0) {
                List list = (List)rows.get(0);
                i = 0;
                while (i < graphSize) {
                    SQLRowValues vals = (SQLRowValues)list.get(i);
                    if (!vals.getTable().getFieldsName().containsAll(vals.getFields())) {
                        throw new IllegalStateException("field name error : " + vals.getFields() + " not in " + vals.getTable().getFieldsName());
                    }
                    ++i;
                }
            }
            if (nextToLink == 0) {
                SQLRowValuesListFetcher.link(l, rows, 0, rowSize);
            } else {
                try {
                    for (Future future : futures) {
                        future.get();
                    }
                }
                catch (Exception exception) {
                    throw new IllegalStateException("couldn't link", exception);
                }
            }
            return res;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.graphNodes.hashCode();
            result = 31 * result + this.selectFields.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RSH other = (RSH)obj;
            return this.graphNodes.equals(other.graphNodes) && this.selectFields.equals(other.selectFields);
        }
    }
}

