/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLDataListener;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableListenerData;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.model.Where;

public class SQLRow
extends SQLRowAccessor {
    private final int ID;
    private final Number idNumber;
    private Map<String, Object> values;
    private boolean fetched = false;

    private static final List<String> getFieldNames(SQLTable table, ResultSetMetaData rsmd, boolean tableOnly) throws SQLException {
        int colCount = rsmd.getColumnCount();
        ArrayList<String> names = new ArrayList<String>(colCount);
        int i = 1;
        while (i <= colCount) {
            if (tableOnly || rsmd.getTableName(i).equals(table.getName())) {
                names.add(rsmd.getColumnName(i));
            } else {
                names.add(null);
            }
            ++i;
        }
        return names;
    }

    static final SQLRow createFromRS(SQLTable table, ResultSet rs, List<String> names) throws SQLException {
        int indexCount = names.size();
        HashMap<String, Object> m = new HashMap<String, Object>(indexCount);
        int i = 0;
        while (i < indexCount) {
            String colName = names.get(i);
            if (colName != null) {
                m.put(colName, rs.getObject(i + 1));
            }
            ++i;
        }
        Number id = SQLRow.getID(m, table, true);
        if (id == null) {
            return null;
        }
        return new SQLRow(table, id, m);
    }

    public static final List<SQLRow> createListFromRS(SQLTable table, ResultSet rs, boolean tableOnly) throws SQLException {
        return SQLRow.createListFromRS(table, rs, SQLRow.getFieldNames(table, rs.getMetaData(), tableOnly));
    }

    static final List<SQLRow> createListFromRS(SQLTable table, ResultSet rs, List<String> names) throws SQLException {
        ArrayList<SQLRow> res = new ArrayList<SQLRow>();
        while (rs.next()) {
            SQLRow row = SQLRow.createFromRS(table, rs, names);
            if (row == null) continue;
            res.add(row);
        }
        return res;
    }

    private SQLRow(SQLTable table, Number id) {
        super(table);
        this.ID = id.intValue();
        this.idNumber = id;
        this.checkTable();
    }

    public SQLRow(SQLTable table, int ID) {
        this(table, table.getKey().getType().getJavaType() == Integer.class ? (Number)ID : (Number)Long.valueOf(ID));
    }

    private void checkTable() {
        if (!this.getTable().isRowable()) {
            throw new IllegalArgumentException(this.getTable() + " is not rowable");
        }
    }

    public SQLRow(SQLTable table, Map<String, ?> values) {
        this(table, null, values);
    }

    private SQLRow(SQLTable table, Number id, Map<String, ?> values) {
        this(table, id == null ? (Number)SQLRow.getID(values, table, false) : (Number)id);
        this.setValues(new HashMap<String, Object>(values));
    }

    private static Number getID(Map<String, ?> values, SQLTable table, boolean nullAllowed) {
        String keyName = table.getKey().getName();
        if (!values.containsKey(keyName)) {
            throw new IllegalArgumentException(values + " does not contain the key of " + table);
        }
        Object keyValue = values.get(keyName);
        if (keyValue instanceof Number) {
            return (Number)keyValue;
        }
        if (nullAllowed && keyValue == null) {
            return null;
        }
        String valS = keyValue == null ? "' is null" : "' isn't a Number : " + keyValue.getClass() + " " + keyValue;
        throw new IllegalArgumentException("The value of '" + keyName + valS);
    }

    private Map<String, Object> getValues() {
        if (!this.fetched) {
            this.fetchValues();
        }
        return this.values;
    }

    public void fetchValues() {
        this.fetchValues(true);
    }

    SQLRow fetchValues(boolean useCache) {
        return this.fetchValues(useCache, useCache);
    }

    SQLRow fetchValues(final boolean readCache, final boolean writeCache) {
        IResultSetHandler handler = new IResultSetHandler(SQLDataSource.MAP_HANDLER){

            @Override
            public boolean readCache() {
                return readCache;
            }

            @Override
            public boolean writeCache() {
                return writeCache;
            }

            public Set<SQLRow> getCacheModifiers() {
                return Collections.singleton(SQLRow.this);
            }
        };
        this.setValues((Map)this.getTable().getBase().getDataSource().execute(this.getQuery(), (ResultSetHandler)handler, false));
        return this;
    }

    private final void setValues(Map<String, Object> values) {
        this.values = values;
        if (!this.fetched) {
            this.fetched = true;
        }
    }

    private String getQuery() {
        return "SELECT * FROM " + this.getTable().getSQLName().quote() + " WHERE " + this.getWhere().getClause();
    }

    public Where getWhere() {
        return new Where((FieldRef)this.getTable().getKey(), "=", this.getID());
    }

    public boolean exists() {
        return this.getValues() != null;
    }

    public boolean isArchived() {
        if (!this.getTable().isArchivable()) {
            return false;
        }
        if (this.getTable().getArchiveField().getType().getJavaType().equals(Boolean.class)) {
            return this.getBoolean(this.getTable().getArchiveField().getName()) == Boolean.TRUE;
        }
        return this.getInt(this.getTable().getArchiveField().getName()) == 1;
    }

    public boolean isValid() {
        return this.exists() && this.getID() >= 0 && !this.isArchived();
    }

    @Override
    public final Object getObject(String field) {
        if (!this.exists()) {
            throw new IllegalStateException("The row " + this + "does not exist.");
        }
        if (!this.getTable().contains(field)) {
            throw new IllegalArgumentException("The table of the row " + this + " doesn't contain the field '" + field + "'.");
        }
        if (!this.getValues().containsKey(field)) {
            this.fetchValues();
            String msg = "The row " + this.simpleToString() + " doesn't contain the field '" + field + "' ; refetching.";
            Log.get().warning(msg);
        }
        return this.getValues().get(field);
    }

    public String toString() {
        String res = this.simpleToString();
        if (!this.exists()) {
            res = "?" + res + "?";
        } else if (this.isArchived()) {
            res = "(" + res + ")";
        }
        return res;
    }

    public String simpleToString() {
        return String.valueOf(this.getTable().getName()) + "[" + this.ID + "]";
    }

    @Override
    public Map<String, Object> getAbsolutelyAll() {
        return Collections.unmodifiableMap(this.getValues());
    }

    public SQLRowValues createUpdateRow() {
        SQLRowValues res = new SQLRowValues(this.getTable());
        res.loadAbsolutelyAll(this);
        return res;
    }

    public SQLRowValues createEmptyUpdateRow() {
        SQLRowValues res = new SQLRowValues(this.getTable());
        res.put(this.getTable().getKey().getName(), this.getIDNumber());
        return res;
    }

    @Override
    public int getID() {
        return this.ID;
    }

    public Number getIDNumber() {
        return this.idNumber;
    }

    public final SQLRowValues asRowValues() {
        return this.createUpdateRow();
    }

    public boolean equals(Object other) {
        if (!(other instanceof SQLRow)) {
            return false;
        }
        SQLRow o = (SQLRow)other;
        return this.equalsAsRow(o);
    }

    public int hashCode() {
        return this.hashCodeAsRow();
    }

    public static List<String> toList(String path) {
        return Arrays.asList(SQLRow.toArray(path));
    }

    private static String[] toArray(String path) {
        if (path.length() == 0) {
            return new String[0];
        }
        return path.split(",");
    }

    @Override
    public SQLTableModifiedListener createTableListener(SQLDataListener l) {
        return new SQLTableListenerData<SQLRow>(this, l);
    }
}

