/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBFileCache;
import org.openconcerto.sql.model.DBItemFileCache;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBStructureItem;
import org.openconcerto.sql.model.DBStructureItemJDBC;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.JDBCStructureSource;
import org.openconcerto.sql.model.LoadingListener;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLIdentifier;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSchema;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLType;
import org.openconcerto.sql.model.StructureSource;
import org.openconcerto.sql.model.XMLStructureSource;
import org.openconcerto.sql.model.graph.DatabaseGraph;
import org.openconcerto.sql.model.graph.TablesMap;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.cc.CopyOnWriteMap;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.change.CollectionChangeEventCreator;

public class SQLBase
extends SQLIdentifier {
    private final CopyOnWriteMap<String, SQLSchema> schemas;
    private int[] dbVersion;
    private static final Pattern percent = Pattern.compile("%.");
    private static final Pattern singleQuote = Pattern.compile("'", 16);
    private static final Pattern quotedPatrn = Pattern.compile("^'(('')|[^'])*'$");
    private static final Pattern twoSingleQuote = Pattern.compile("''", 16);
    private static final Pattern doubleQuote = Pattern.compile("\"");

    public static final void logCacheError(DBItemFileCache dir, Exception e) {
        Logger logger = Log.get();
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "invalid files in " + dir, e);
        } else {
            logger.info("invalid files in " + dir + "\n" + e.getMessage());
        }
    }

    SQLBase(SQLServer server, String name, IClosure<? super DBSystemRoot> systemRootInit, String login, String pass, IClosure<? super SQLDataSource> dsInit) {
        super(server, name);
        if (name == null) {
            throw new NullPointerException("null base");
        }
        this.schemas = new CopyOnWriteMap();
        this.dbVersion = null;
        DBSystemRoot sysRoot = this.getDBSystemRoot();
        if (sysRoot.getJDBC() == this) {
            sysRoot.setDS(systemRootInit, login, pass, dsInit);
        }
    }

    final TablesMap init(boolean readCache) {
        try {
            return this.refresh(null, readCache, true);
        }
        catch (SQLException e) {
            throw new IllegalStateException("could not init " + this, e);
        }
    }

    @Override
    protected synchronized void onDrop() {
        this.schemas.clear();
        SQLType.remove(this);
        super.onDrop();
    }

    TablesMap refresh(TablesMap namesToRefresh, boolean readCache) throws SQLException {
        return this.refresh(namesToRefresh, readCache, false);
    }

    private TablesMap refresh(TablesMap namesToRefresh, boolean readCache, boolean inCtor) throws SQLException {
        if (readCache) {
            return this.loadTables(namesToRefresh, inCtor);
        }
        return this.fetchTables(namesToRefresh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TablesMap loadTables(TablesMap childrenNames, boolean inCtor) throws SQLException {
        this.checkDropped();
        if (childrenNames != null && childrenNames.size() == 0) {
            return childrenNames;
        }
        childrenNames = this.assureAllTables(childrenNames);
        DBItemFileCache dir = this.getFileCache();
        Object object = this.getTreeMutex();
        synchronized (object) {
            long t1;
            XMLStructureSource xmlStructSrc = null;
            if (dir != null) {
                try {
                    Log.get().config("for mapping " + this + " trying xmls in " + dir);
                    t1 = System.currentTimeMillis();
                    xmlStructSrc = new XMLStructureSource(this, childrenNames, dir);
                    assert (xmlStructSrc.isPreVerify());
                    xmlStructSrc.init();
                    long t2 = System.currentTimeMillis();
                    Log.get().config("XML took " + (t2 - t1) + "ms for mapping " + this.getName() + "." + xmlStructSrc.getSchemas());
                }
                catch (Exception e) {
                    SQLBase.logCacheError(dir, e);
                    xmlStructSrc = null;
                }
            }
            t1 = System.currentTimeMillis();
            JDBCStructureSource jdbcStructSrc = this.fetchTablesP(childrenNames, xmlStructSrc);
            long t2 = System.currentTimeMillis();
            Log.get().config("JDBC took " + (t2 - t1) + "ms for mapping " + this.getName() + "." + jdbcStructSrc.getSchemas());
            return jdbcStructSrc.getTablesMap();
        }
    }

    private final TablesMap assureAllTables(TablesMap childrenNames) {
        TablesMap res;
        if (childrenNames == null) {
            res = childrenNames;
        } else {
            res = TablesMap.create(childrenNames);
            for (Map.Entry e : childrenNames.entrySet()) {
                String schemaName = (String)e.getKey();
                if (e.getValue() == null || this.contains(schemaName)) continue;
                res.put(schemaName, null);
            }
        }
        return res;
    }

    TablesMap fetchTables(TablesMap childrenNames) throws SQLException {
        if (childrenNames != null && childrenNames.size() == 0) {
            return childrenNames;
        }
        return this.fetchTablesP(this.assureAllTables(childrenNames), null).getTablesMap();
    }

    private JDBCStructureSource fetchTablesP(TablesMap childrenNames, StructureSource<?> external) throws SQLException {
        LoadingListener.StructureLoadingEvent evt = new LoadingListener.StructureLoadingEvent(this, childrenNames == null ? null : childrenNames.keySet());
        DBSystemRoot sysRoot = this.getDBSystemRoot();
        try {
            sysRoot.fireLoading(evt);
            JDBCStructureSource jDBCStructureSource = this.refreshTables(new JDBCStructureSource(this, childrenNames, external == null ? null : external.getNewStructure(), external == null ? null : external.getOutOfDateSchemas()));
            return jDBCStructureSource;
        }
        finally {
            sysRoot.fireLoading(((LoadingListener.LoadingEvent)evt).createFinishingEvent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T extends Exception, S extends StructureSource<T>> S refreshTables(final S src) throws T {
        this.checkDropped();
        Object object = this.getTreeMutex();
        synchronized (object) {
            DBRoot root;
            SQLSchema s;
            src.init();
            final Set<String> newSchemas = src.getTotalSchemas();
            Set<String> currentSchemas = src.getExistingSchemasToRefresh();
            SQLBase.mustContain(this, newSchemas, currentSchemas, "schemas");
            CollectionChangeEventCreator c = this.createChildrenCreator();
            for (String schema : CollectionUtils.substract(currentSchemas, newSchemas)) {
                this.schemas.remove(schema).dropped();
            }
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    for (DBItemFileCache savedSchema : SQLBase.this.getSavedCaches(false)) {
                        if (!src.isInTotalScope(savedSchema.getName()) || newSchemas.contains(savedSchema.getName())) continue;
                        savedSchema.delete();
                    }
                    return null;
                }
            });
            for (String schema : CollectionUtils.inter(currentSchemas, newSchemas)) {
                this.getSchema(schema).clearNonPersistent();
            }
            for (String schema : newSchemas) {
                this.createAndGetSchema(schema);
            }
            Set<SQLName> newTableNames = src.getTotalTablesNames();
            Set<SQLName> currentTables = src.getExistingTablesToRefresh();
            SQLBase.mustContain(this, newTableNames, currentTables, "tables");
            for (SQLName tableName : CollectionUtils.substract(currentTables, newTableNames)) {
                s = this.getSchema(tableName.getItemLenient(-2));
                s.rmTable(tableName.getName());
            }
            for (SQLName tableName : CollectionUtils.inter(newTableNames, currentTables)) {
                s = this.getSchema(tableName.getItemLenient(-2));
                s.getTable(tableName.getName()).clearNonPersistent();
            }
            for (SQLName tableName : CollectionUtils.substract(newTableNames, currentTables)) {
                s = this.getSchema(tableName.getItemLenient(-2));
                s.addTable(tableName.getName());
            }
            src.fillTables();
            this.fireChildrenChanged(c);
            assert (this.getServer().getBase(this.getName()) == this);
            TablesMap toRefresh = src.getToRefresh();
            TablesMap byRoot = toRefresh == null ? TablesMap.createByRootFromChildren(this, null) : ((root = this.getDBRoot()) != null ? TablesMap.createFromTables(root.getName(), (Collection)toRefresh.get(null)) : toRefresh);
            this.getDBSystemRoot().descendantsChanged(byRoot, src.hasExternalStruct());
        }
        src.save();
        return src;
    }

    static <T> void mustContain(DBStructureItemJDBC c, Set<T> newC, Set<T> oldC, String name) {
        if (Boolean.getBoolean("org.openconcerto.sql.identifier.allowRemoval")) {
            return;
        }
        Set<T> diff = CollectionUtils.contains(newC, oldC);
        if (diff != null) {
            throw new IllegalStateException("some " + name + " were removed in " + c + ": " + diff);
        }
    }

    public final String getURL() {
        return this.getServer().getURL(this.getName());
    }

    public Set<SQLName> getAllTableNames() {
        HashSet<SQLName> res = new HashSet<SQLName>();
        for (SQLTable t : this.getAllTables()) {
            res.add(t.getSQLName(this, false));
        }
        return res;
    }

    public Set<SQLTable> getAllTables() {
        HashSet<SQLTable> res = new HashSet<SQLTable>();
        for (SQLSchema s : this.getSchemas()) {
            res.addAll(s.getTables());
        }
        return res;
    }

    @Override
    public Map<String, SQLSchema> getChildrenMap() {
        return this.schemas.getImmutable();
    }

    public final Set<SQLSchema> getSchemas() {
        return new HashSet<SQLSchema>(this.schemas.values());
    }

    public final SQLSchema getSchema(String name) {
        return this.schemas.get(name);
    }

    private SQLSchema createAndGetSchema(String name) {
        SQLSchema res = this.getSchema(name);
        if (res == null) {
            res = new SQLSchema(this, name);
            this.schemas.put(name, res);
        }
        return res;
    }

    public DatabaseGraph getGraph() {
        if (this.getDBRoot() == null) {
            return this.getDBSystemRoot().getGraph();
        }
        return this.getDBRoot().getGraph();
    }

    public SQLDataSource getDataSource() {
        return this.getDBSystemRoot().getDataSource();
    }

    public String toString() {
        return this.getName();
    }

    String getFwkMetadata(String schema, String name, boolean shouldTestForTable) {
        return this.getFwkMetadata(Collections.singletonList(schema), name, shouldTestForTable).get(schema);
    }

    private final String getSel(String schema, String name, boolean selSchema) {
        SQLName tableName = new SQLName(this.getName(), schema, "FWK_SCHEMA_METADATA");
        return "SELECT " + (selSchema ? String.valueOf(this.quoteString(schema)) + ", " : "") + "\"VALUE\" FROM " + tableName.quote() + " WHERE \"NAME\"= " + this.quoteString(name);
    }

    /*
     * Unable to fully structure code
     */
    Map<String, String> getFwkMetadata(Collection<String> schemas, final String name, boolean shouldTestForTable) {
        block11: {
            if (schemas.isEmpty()) {
                return Collections.emptyMap();
            }
            res = new LinkedHashMap<String, String>();
            CollectionUtils.fillMap(res, schemas);
            system = this.getServer().getSQLSystem();
            if (shouldTestForTable && system == SQLSystem.POSTGRESQL) {
                stringDel = "$sel$";
                funcName = "pg_temp.ifExistText";
                query = "create or replace function pg_temp.ifExistText(schemaName text, tableName text, doesExist text, doesNotExist text) returns text as $BODY$\ndeclare res text;\nbegin\n    if EXISTS (SELECT 1 FROM information_schema.tables WHERE table_schema = schemaName and table_name = tableName) then\n        execute doesExist into res; else execute doesNotExist into res;\n    end if;\n    return res;\nend;\n$BODY$ LANGUAGE plpgsql;\n" + CollectionUtils.join(res.keySet(), "\nUNION ALL ", new ITransformer<String, String>(){

                    public String transformChecked(String schema) {
                        String sel = SQLBase.this.getSel(schema, name, false);
                        if (sel.contains("$sel$")) {
                            throw new IllegalStateException(String.valueOf(sel) + " contains string delimiter : " + "$sel$");
                        }
                        return "select pg_temp.ifExistText(" + SQLBase.this.quoteString(schema) + ", " + SQLBase.this.quoteString("FWK_SCHEMA_METADATA") + ", " + "$sel$" + sel + "$sel$" + ", 'SELECT NULL')";
                    }
                });
                try {
                    this.getDataSource().useConnection(new ConnectionHandlerNoSetup<Object, SQLException>(){

                        @Override
                        public Object handle(SQLDataSource ds) throws SQLException, SQLException {
                            Statement stmt = ds.getConnection().createStatement();
                            stmt.execute(query);
                            if (!stmt.getMoreResults()) {
                                throw new IllegalStateException("No result");
                            }
                            ResultSet rs = stmt.getResultSet();
                            Iterator iter = res.keySet().iterator();
                            while (rs.next()) {
                                res.put((String)iter.next(), rs.getString(1));
                            }
                            if (!$assertionsDisabled && iter.hasNext()) {
                                throw new AssertionError();
                            }
                            stmt.close();
                            return null;
                        }
                    });
                }
                catch (SQLException e) {
                    throw new IllegalStateException(e);
                }
            }
            rsh = new ResultSetHandler(){

                @Override
                public Object handle(ResultSet rs) throws SQLException {
                    while (rs.next()) {
                        res.put(rs.getString(1), rs.getString(2));
                    }
                    return null;
                }
            };
            try {
                this.getDataSource().execute(CollectionUtils.join(schemas, "\nUNION ALL ", new ITransformer<String, String>(){

                    public String transformChecked(String schema) {
                        return SQLBase.this.getSel(schema, name, true);
                    }
                }), new IResultSetHandler(rsh, false));
                break block11;
            }
            catch (RuntimeException rtExn) {
                try {
                    if (system == SQLSystem.POSTGRESQL && this.getDataSource().handlingConnection() && !this.getDataSource().getConnection().getAutoCommit()) {
                        throw rtExn;
                    }
                }
                catch (SQLException e) {
                    throw new IllegalStateException("Couldn't get auto commit : " + e.getMessage() + " " + e.getSQLState(), rtExn);
                }
                sqlExn = SQLUtils.findWithSQLState(rtExn);
                v0 = tableNotFound = sqlExn != null && (sqlExn.getSQLState().equals("42S02") != false || sqlExn.getSQLState().equals("42P01") != false);
                if (!tableNotFound) {
                    throw rtExn;
                }
                if (schemas.size() <= 1) break block11;
                ** for (schema : schemas)
            }
lbl-1000:
            // 1 sources

            {
                res.put(schema, this.getFwkMetadata(schema, name, shouldTestForTable));
                continue;
            }
        }
        return res;
    }

    public final String getMDName() {
        return this.getServer().getSQLSystem().getMDName(this.getName());
    }

    public synchronized int[] getVersion() throws SQLException {
        if (this.dbVersion == null) {
            this.dbVersion = this.getDataSource().useConnection(new ConnectionHandlerNoSetup<int[], SQLException>(){

                @Override
                public int[] handle(SQLDataSource ds) throws SQLException, SQLException {
                    DatabaseMetaData md = ds.getConnection().getMetaData();
                    return new int[]{md.getDatabaseMajorVersion(), md.getDatabaseMinorVersion()};
                }
            });
        }
        return this.dbVersion;
    }

    private final DBItemFileCache getFileCache() {
        boolean useXML = this.getDBSystemRoot().useCache();
        DBFileCache fileCache = this.getServer().getFileCache();
        if (!useXML || fileCache == null) {
            return null;
        }
        return fileCache.getChild(this.getName());
    }

    private final DBItemFileCache getSchemaFileCache(String schema) {
        DBItemFileCache item = this.getFileCache();
        if (item == null) {
            return null;
        }
        return item.getChild(schema);
    }

    private final List<DBItemFileCache> getSavedCaches(boolean withStruct) {
        DBItemFileCache item = this.getFileCache();
        if (item == null) {
            return Collections.emptyList();
        }
        return item.getSavedDesc(SQLSchema.class, withStruct ? "structure.xml" : null);
    }

    boolean save(final String schemaName) {
        DBItemFileCache schemaFileCache = this.getSchemaFileCache(schemaName);
        if (schemaFileCache == null) {
            return false;
        }
        final File schemaFile = schemaFileCache.getFile("structure.xml");
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean run() {
                Writer pWriter = null;
                try {
                    String schema = SQLBase.this.getSchema(schemaName).toXML();
                    if (schema == null) {
                        Boolean bl = false;
                        return bl;
                    }
                    FileUtils.mkdir_p(schemaFile.getParentFile());
                    7 var3_11 = this;
                    synchronized (var3_11) {
                        pWriter = FileUtils.createXMLWriter(schemaFile);
                        pWriter.write("<root codecVersion=\"20140513-0957\" >\n" + schema + "\n</root>\n");
                    }
                    Boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    Log.get().log(Level.WARNING, "unable to save files in " + schemaFile, e);
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    if (pWriter != null) {
                        try {
                            pWriter.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    public final String quote(String pattern, Object ... params) {
        return SQLBase.quote(this, pattern, params);
    }

    @Deprecated
    public static final String quoteStd(String pattern, Object ... params) {
        return SQLBase.quote(null, pattern, params);
    }

    private static final String quote(SQLBase b, String pattern, Object ... params) {
        Matcher m = percent.matcher(pattern);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int lastAppendPosition = 0;
        while (m.find()) {
            String replacement;
            char modifier = m.group().charAt(m.group().length() - 1);
            if (modifier == '%') {
                replacement = "%";
            } else {
                Object param = params[i++];
                if (modifier == 's') {
                    replacement = SQLBase.quoteString(b, param.toString());
                } else if (modifier == 'i') {
                    replacement = param instanceof SQLName ? ((SQLName)param).quote() : SQLBase.quoteIdentifier(param.toString());
                } else {
                    SQLIdentifier ident = (SQLIdentifier)((DBStructureItem)param).getJDBC();
                    if (modifier == 'f') {
                        replacement = ident.getSQLName().quote();
                    } else if (modifier == 'n') {
                        replacement = SQLBase.quoteIdentifier(ident.getName());
                    } else {
                        throw new IllegalArgumentException("unknown modifier: " + modifier);
                    }
                }
            }
            sb.append(pattern.subSequence(lastAppendPosition, m.start()));
            sb.append(replacement);
            lastAppendPosition = m.end();
        }
        sb.append(pattern.substring(lastAppendPosition));
        return sb.toString();
    }

    public String quoteString(String s) {
        return SQLBase.quoteStringStd(s);
    }

    public static final String quoteStringStd(String s) {
        return s == null ? "NULL" : "'" + singleQuote.matcher(s).replaceAll("''") + "'";
    }

    public static final String quoteString(SQLBase b, String s) {
        return b == null ? SQLBase.quoteStringStd(s) : b.quoteString(s);
    }

    public static final String quoteIdentifier(String identifier) {
        return String.valueOf('\"') + doubleQuote.matcher(identifier).replaceAll("\"\"") + '\"';
    }
}

