/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.apache.commons.collections.Predicate;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.ShowAs;
import org.openconcerto.sql.TM;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.HierarchyLevel;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLFilter;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.request.SQLFieldTranslator;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.LogUtils;
import org.openconcerto.utils.MultipleOutputStream;
import org.openconcerto.utils.NetUtils;
import org.openconcerto.utils.ProductInfo;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.StreamUtils;
import org.openconcerto.utils.Value;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.i18n.TranslationManager;

public class PropsConfiguration
extends Configuration {
    public static final String EMPTY_PROP_VALUE;
    private static final DateFormat DATE_FORMAT;
    public static final Properties DEFAULTS;
    private final Properties props;
    private SQLServer server;
    private DBSystemRoot sysRoot;
    private DBRoot root;
    private UserRightsManager urMngr;
    private ProductInfo productInfo;
    private final Addable<ShowAs> showAs;
    private SQLFilter filter;
    private final Addable<SQLFieldTranslator> translator;
    private final Addable<SQLElementDirectory> directory;
    private File wd;
    private File logDir;
    private final Object treeLock = new String("treeLock");
    private final Object restLock = new String("everythingElseLock");
    private Session conn;
    private boolean isUsingSSH;
    private boolean destroyed;

    static {
        DATE_FORMAT = new SimpleDateFormat("yyyy-MM/dd_EEEE");
        DEFAULTS = new Properties();
        File wd = new File(System.getProperty("user.dir"));
        DEFAULTS.setProperty("wd", wd.getPath());
        DEFAULTS.setProperty("customer", "test");
        DEFAULTS.setProperty("server.ip", "127.0.0.1");
        DEFAULTS.setProperty("server.login", "root");
        EMPTY_PROP_VALUE = "";
        assert (EMPTY_PROP_VALUE != null);
    }

    public static String getHostname() {
        InetAddress addr;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return "local";
        }
        return addr.getHostName();
    }

    protected static Properties create(InputStream f, Properties defaults) throws IOException {
        Properties props = new Properties(defaults);
        if (f != null) {
            props.load(f);
            f.close();
        }
        return props;
    }

    public PropsConfiguration() throws IOException {
        this(new File("fwk_SQL.properties"), DEFAULTS);
    }

    public PropsConfiguration(File f, Properties defaults) throws IOException {
        this(new FileInputStream(f), defaults);
    }

    public PropsConfiguration(InputStream f, Properties defaults) throws IOException {
        this(PropsConfiguration.create(f, defaults));
    }

    public PropsConfiguration(Properties props) {
        this.props = props;
        this.showAs = new Addable<ShowAs>(){
            private SQLElementDirectory.DirectoryListener directoryListener;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected ShowAs create() {
                final ShowAs res = PropsConfiguration.this.createShowAs();
                SQLElementDirectory dir = PropsConfiguration.this.getDirectory();
                1 var3_3 = this;
                synchronized (var3_3) {
                    if (!$assertionsDisabled && this.directoryListener != null) {
                        throw new AssertionError();
                    }
                    this.directoryListener = new SQLElementDirectory.DirectoryListener(){

                        @Override
                        public void elementRemoved(SQLElement elem) {
                            res.removeTable(elem.getTable());
                        }

                        @Override
                        public void elementAdded(SQLElement elem) {
                            CollectionMap<String, String> sa = elem.getShowAs();
                            if (sa != null) {
                                for (Map.Entry<String, Collection<String>> e : sa.entrySet()) {
                                    try {
                                        if (e.getKey() == null) {
                                            res.show(elem.getTable(), (List<String>)((List)e.getValue()));
                                            continue;
                                        }
                                        res.show(elem.getTable().getField(e.getKey()), (List<String>)((List)e.getValue()));
                                    }
                                    catch (RuntimeException exn) {
                                        throw new IllegalStateException("Couldn't add showAs for " + elem + " : " + e, exn);
                                    }
                                }
                            }
                        }
                    };
                    SQLElementDirectory sQLElementDirectory = dir;
                    synchronized (sQLElementDirectory) {
                        for (SQLElement elem : dir.getElements()) {
                            this.directoryListener.elementAdded(elem);
                        }
                        dir.addListener(this.directoryListener);
                    }
                }
                return res;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void destroy(Future<ShowAs> future) {
                SQLElementDirectory.DirectoryListener l;
                try {
                    future.get();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!$assertionsDisabled && !future.isDone()) {
                    throw new AssertionError();
                }
                1 var3_4 = this;
                synchronized (var3_4) {
                    l = this.directoryListener;
                }
                if (l != null) {
                    PropsConfiguration.this.getDirectory().removeListener(l);
                }
                super.destroy(future);
            }

            @Override
            protected void add(ShowAs obj, Configuration conf) {
                obj.putAll(conf.getShowAs());
            }
        };
        this.directory = new Addable<SQLElementDirectory>(){

            @Override
            protected SQLElementDirectory create() {
                return PropsConfiguration.this.createDirectory();
            }

            @Override
            protected void add(SQLElementDirectory obj, Configuration conf) {
                obj.putAll(conf.getDirectory());
            }
        };
        this.translator = new Addable<SQLFieldTranslator>(){

            @Override
            protected SQLFieldTranslator create() {
                return PropsConfiguration.this.createTranslator();
            }

            @Override
            protected void add(SQLFieldTranslator obj, Configuration conf) {
                obj.putAll(conf.getTranslator());
            }
        };
        this.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.treeLock;
        synchronized (object) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
            if (this.server != null) {
                this.server.destroy();
            }
            this.closeSSLConnection();
            if (this.urMngr != null) {
                UserRightsManager.clearInstanceIfSame(this.urMngr);
            }
        }
        this.showAs.destroy();
        this.translator.destroy();
        this.directory.destroy();
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isDestroyed() {
        Object object = this.treeLock;
        synchronized (object) {
            return this.destroyed;
        }
    }

    private final void checkDestroyed() {
        PropsConfiguration.checkDestroyed(this.isDestroyed());
    }

    private static final void checkDestroyed(boolean d) {
        if (d) {
            throw new IllegalStateException("Destroyed");
        }
    }

    public final String getProperty(String name) {
        return this.props.getProperty(name);
    }

    public final String getProperty(String name, String def) {
        return this.props.getProperty(name, def);
    }

    protected final void setProperty(String name, String val) {
        if (val == null) {
            this.props.remove(name);
        } else {
            this.props.setProperty(name, val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setProductInfo(ProductInfo productInfo) {
        Object object = this.restLock;
        synchronized (object) {
            this.productInfo = productInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUp() {
        Object object = this.treeLock;
        synchronized (object) {
            this.destroyed = false;
            this.server = null;
            this.sysRoot = null;
            this.root = null;
        }
        object = this.restLock;
        synchronized (object) {
            this.setProductInfo(ProductInfo.getInstance());
            this.setFilter(null);
        }
    }

    public final SQLSystem getSystem() {
        return SQLSystem.get(this.getProperty("server.driver"));
    }

    protected String getLogin() {
        return this.getProperty("server.login");
    }

    protected String getPassword() {
        return this.getProperty("server.password");
    }

    public final InputStream getStream(String name) {
        File f = this.getFile(name);
        if (this.mustUseClassloader(f)) {
            return this.getClass().getResourceAsStream(name);
        }
        try {
            return new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    private File getFile(String name) {
        return new File(name.startsWith("/") ? name.substring(1) : name);
    }

    private boolean mustUseClassloader(File f) {
        return this.getFileMode() == FileMode.IN_JAR || !f.exists();
    }

    public final String getResource(String name) {
        File f = this.getFile(name);
        if (this.mustUseClassloader(f)) {
            return this.getClass().getResource(name).toExternalForm();
        }
        return f.getAbsolutePath();
    }

    protected FileMode getFileMode() {
        return FileMode.IN_JAR;
    }

    protected final DBRoot createRoot() {
        Value<String> rootName = this.getRootNameValue();
        if (rootName.hasValue()) {
            return this.getSystemRoot().getRoot(rootName.getValue());
        }
        throw new NullPointerException("no rootname");
    }

    protected UserRightsManager createUserRightsManager(DBRoot root) {
        return UserRightsManager.setInstanceIfNone(root);
    }

    public String getRootName() {
        return this.getProperty("base.root", EMPTY_PROP_VALUE);
    }

    public final Value<String> getRootNameValue() {
        String res = this.getRootName();
        return res == null || EMPTY_PROP_VALUE.equals(res) ? Value.getNone() : Value.getSome(res);
    }

    private final boolean hasWANProperties(String wanAddr, String wanPort) {
        return wanAddr != null && wanPort != null;
    }

    protected SQLServer createServer() {
        RuntimeException origExn;
        Logger log;
        String serverID;
        String wanPort;
        String wanAddr;
        block8: {
            wanAddr = this.getProperty("server.wan.addr");
            if (!this.hasWANProperties(wanAddr, wanPort = this.getProperty("server.wan.port"))) {
                return this.doCreateServer();
            }
            serverID = "tunnel to " + wanAddr + ":" + wanPort + " then " + this.getProperty("server.ip");
            log = Log.get();
            origExn = null;
            if (!"true".equals(this.getProperty("server.wan.only"))) {
                try {
                    SQLServer defaultServer = this.doCreateServer(serverID);
                    defaultServer.getSystemRoot(this.getSystemRootName());
                    log.config("using " + defaultServer);
                    return defaultServer;
                }
                catch (RuntimeException e) {
                    origExn = e;
                    log.config(e.getLocalizedMessage());
                    if ($assertionsDisabled || origExn != null) break block8;
                    throw new AssertionError();
                }
            }
        }
        this.openSSLConnection(wanAddr, Integer.valueOf(wanPort));
        this.isUsingSSH = true;
        log.info("ssl connection to " + this.conn.getHost() + ":" + this.conn.getPort());
        int localPort = NetUtils.findFreePort(5436);
        try {
            String[] serverAndPort = this.getProperty("server.ip").split(":");
            log.info("ssl tunnel from local port " + localPort + " to remote " + serverAndPort[0] + ":" + serverAndPort[1]);
            this.conn.setPortForwardingL(localPort, serverAndPort[0], Integer.valueOf(serverAndPort[1]));
        }
        catch (Exception e1) {
            throw new IllegalStateException("Impossible de cr\u00e9er la liaison s\u00e9curis\u00e9e. V\u00e9rifier que le logiciel n'est pas d\u00e9j\u00e0 lanc\u00e9.", e1);
        }
        SQLServer serverThruSSL = this.doCreateServer("localhost:" + localPort, null, serverID);
        try {
            serverThruSSL.getSystemRoot(this.getSystemRootName());
        }
        catch (Exception e) {
            this.closeSSLConnection();
            throw new IllegalStateException("Couldn't connect through SSL : " + e.getLocalizedMessage(), origExn);
        }
        return serverThruSSL;
    }

    private SQLServer doCreateServer() {
        return this.doCreateServer(null);
    }

    private SQLServer doCreateServer(String id) {
        return this.doCreateServer(this.getProperty("server.ip"), null, id);
    }

    private SQLServer doCreateServer(String host, String port, String id) {
        SQLServer res = new SQLServer(this.getSystem(), host, port, this.getLogin(), this.getPassword(), (IClosure<? super DBSystemRoot>)new IClosure<DBSystemRoot>(){

            public void executeChecked(DBSystemRoot input) {
                input.setRootsToMap(PropsConfiguration.this.getRootsToMap());
                PropsConfiguration.this.initSystemRoot(input);
            }
        }, (IClosure<? super SQLDataSource>)new IClosure<SQLDataSource>(){

            public void executeChecked(SQLDataSource input) {
                PropsConfiguration.this.initDS(input);
            }
        });
        if (id != null) {
            res.setID(id);
        }
        return res;
    }

    private void openSSLConnection(String addr, int port) {
        this.checkDestroyed();
        String username = this.getSSLUserName();
        String pass = this.getSSLPassword();
        boolean isAuthenticated = false;
        JSch jsch = new JSch();
        try {
            if (pass == null) {
                ByteArrayOutputStream out = new ByteArrayOutputStream(700);
                String name = String.valueOf(username) + "_dsa";
                InputStream in = this.getClass().getResourceAsStream(name);
                if (in == null) {
                    throw new IllegalStateException("Missing private key " + this.getClass().getCanonicalName() + "/" + name);
                }
                StreamUtils.copy(in, out);
                in.close();
                jsch.addIdentity(username, out.toByteArray(), null, null);
            }
            this.conn = jsch.getSession(username, addr, port);
            if (pass != null) {
                this.conn.setPassword(pass);
            }
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            config.put("compression.s2c", "zlib@openssh.com,zlib,none");
            config.put("compression.c2s", "zlib@openssh.com,zlib,none");
            this.conn.setConfig(config);
            this.conn.connect(6000);
            this.afterSSLConnect(this.conn);
            isAuthenticated = true;
        }
        catch (Exception e) {
            throw new IllegalStateException("Connection failed", e);
        }
        if (!isAuthenticated) {
            throw new IllegalStateException("Authentication failed.");
        }
    }

    protected void afterSSLConnect(Session conn) {
    }

    public String getSSLUserName() {
        return this.getProperty("server.wan.user");
    }

    protected String getSSLPassword() {
        return this.getProperty("server.wan.password");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSSLConnection() {
        Object object = this.treeLock;
        synchronized (object) {
            if (this.conn != null) {
                this.conn.disconnect();
                this.conn = null;
            }
        }
    }

    protected Collection<String> getRootsToMap() {
        String rootsToMap = this.getProperty("systemRoot.rootsToMap");
        if ("*".equals(rootsToMap)) {
            return null;
        }
        HashSet<String> res = new HashSet<String>();
        Value<String> rootName = this.getRootNameValue();
        if (rootName.hasValue()) {
            res.add(rootName.getValue());
        }
        if (rootsToMap != null) {
            res.addAll(SQLRow.toList(rootsToMap));
        }
        return res;
    }

    protected List<String> getRootPath() {
        return new ArrayList<String>(SQLRow.toList(this.getProperty("systemRoot.rootPath", "")));
    }

    public String getSystemRootName() {
        return this.getProperty("systemRoot");
    }

    protected DBSystemRoot createSystemRoot() {
        DBSystemRoot res = this.getServer(false).getSystemRoot(this.getSystemRootName());
        this.setupSystemRoot(res, true);
        return res;
    }

    protected final void setupSystemRoot(DBSystemRoot res) {
        this.setupSystemRoot(res, false);
    }

    private void setupSystemRoot(DBSystemRoot res, boolean brandNew) {
        if (!brandNew) {
            res.unsetRootPath();
        }
        if (res.getChildrenNames().contains(this.getRootName())) {
            res.setDefaultRoot(this.getRootName());
        }
        for (String root : this.getRootPath()) {
            if (!res.getChildrenNames().contains(root)) continue;
            res.appendToRootPath(root);
        }
    }

    protected void initSystemRoot(DBSystemRoot input) {
    }

    protected void initDS(final SQLDataSource ds) {
        ds.setCacheEnabled(true);
        String appID = this.getAppID();
        if (appID != null) {
            ds.addConnectionProperty("ApplicationName", appID);
        }
        this.propIterate(new IClosure<String>(){

            public void executeChecked(String propName) {
                String jdbcName = propName.substring("jdbc.connection.".length());
                ds.addConnectionProperty(jdbcName, PropsConfiguration.this.getProperty(propName));
            }
        }, "jdbc.connection.");
    }

    public final void propIterate(IClosure<String> cl, final String startsWith) {
        this.propIterate(cl, new Predicate(){

            @Override
            public boolean evaluate(Object propName) {
                return ((String)propName).startsWith(startsWith);
            }
        });
    }

    public final void propIterate(IClosure<String> cl, Predicate filter) {
        for (String propName : this.props.stringPropertyNames()) {
            if (!filter.evaluate(propName)) continue;
            cl.executeChecked(propName);
        }
    }

    public final void setLoggersLevel() {
        this.propIterate(new IClosure<String>(){

            public void executeChecked(String propName) {
                String logName = propName.substring("log.level.".length());
                LogUtils.getLogger(logName).setLevel(Level.parse(PropsConfiguration.this.getProperty(propName)));
            }
        }, "log.level.");
    }

    public void setupLogging() {
        this.setupLogging("logs");
    }

    public void setupLogging(String dirName) {
        this.setupLogging(dirName, Boolean.getBoolean("redirectToFile"));
    }

    protected boolean keepStandardStreamsWhenRedirectingToFile() {
        return true;
    }

    protected DateFormat getLogDateFormat() {
        return DATE_FORMAT;
    }

    private final File getValidLogDir(String dirName) {
        File logDir;
        try {
            File softLogDir = new File(this.getWD() + "/" + dirName + "/" + PropsConfiguration.getHostname() + "-" + System.getProperty("user.name"));
            softLogDir.mkdirs();
            if (softLogDir.canWrite()) {
                logDir = softLogDir;
            } else {
                File homeLogDir = new File(String.valueOf(System.getProperty("user.home")) + "/." + this.getAppName() + "/" + dirName);
                FileUtils.mkdir_p(homeLogDir);
                if (homeLogDir.canWrite()) {
                    logDir = homeLogDir;
                } else {
                    throw new IOException("Home log directory not writeable : " + homeLogDir);
                }
            }
            assert (logDir.exists() && logDir.canWrite());
            System.out.println("Log directory: " + logDir.getAbsolutePath());
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to create log dir", e);
        }
        return logDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupLogging(String dirName, boolean redirectToFile) {
        File logFile;
        File logDir;
        Object object = this.restLock;
        synchronized (object) {
            if (this.logDir != null) {
                throw new IllegalStateException("Already set to " + this.logDir);
            }
            this.logDir = logDir = this.getValidLogDir(dirName);
        }
        String logNameBase = String.valueOf(this.getAppName()) + "_" + this.getLogDateFormat().format(new Date());
        if (redirectToFile) {
            logFile = new File(logDir, String.valueOf(logNameBase) + ".txt");
            try {
                OutputStream err;
                OutputStream out;
                FileUtils.mkdir_p(logFile.getParentFile());
                System.out.println("Log file: " + logFile.getAbsolutePath());
                FileOutputStream fileOut = new FileOutputStream(logFile, true);
                System.out.println("Java System console:" + System.console());
                boolean launchedFromEclipse = new File(".classpath").exists();
                if (launchedFromEclipse) {
                    System.out.println("Launched from eclipse");
                }
                if ((System.console() != null || launchedFromEclipse) && this.keepStandardStreamsWhenRedirectingToFile()) {
                    System.out.println("Redirecting standard output to file and console");
                    out = new MultipleOutputStream(fileOut, new FileOutputStream(FileDescriptor.out));
                    System.out.println("Redirecting error output to file and console");
                    err = new MultipleOutputStream(fileOut, new FileOutputStream(FileDescriptor.err));
                } else {
                    out = fileOut;
                    err = fileOut;
                }
                System.setErr(new PrintStream(new BufferedOutputStream(err, 128), true));
                System.setOut(new PrintStream(new BufferedOutputStream(out, 128), true));
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            FileUtils.ln(logFile, new File(logDir, "last.log"));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }).start();
            }
            catch (Exception e) {
                ExceptionHandler.handle("Redirection des sorties standards impossible", e);
            }
        } else {
            System.out.println("Standard streams not redirected to file");
        }
        LogUtils.rmRootHandlers();
        LogUtils.setUpConsoleHandler();
        try {
            logFile = new File(logDir, String.valueOf(this.getAppName()) + "-%u-age%g.log");
            FileUtils.mkdir_p(logFile.getParentFile());
            System.out.println("Logger logs: " + logFile.getAbsolutePath());
            FileHandler fh = new FileHandler(logFile.getPath(), 0x500000, 2, true);
            fh.setFormatter(new SimpleFormatter());
            Logger.getLogger("").addHandler(fh);
        }
        catch (Exception e) {
            ExceptionHandler.handle("Enregistrement du Logger d\u00e9sactiv\u00e9", e);
        }
        this.setLoggersLevel();
    }

    public void tearDownLogging(boolean redirectToFile) {
        LogUtils.rmRootHandlers();
        if (redirectToFile) {
            System.out.close();
            System.err.close();
        }
    }

    protected ShowAs createShowAs() {
        return new ShowAs(this.getRoot());
    }

    protected SQLElementDirectory createDirectory() {
        return new SQLElementDirectory();
    }

    protected List<String> getMappings() {
        return Arrays.asList("mapping", "mapping-" + this.getProperty("customer"));
    }

    protected SQLFieldTranslator createTranslator() {
        List<String> mappings = this.getMappings();
        if (mappings.size() == 0) {
            throw new IllegalStateException("empty mappings");
        }
        SQLFieldTranslator trns = new SQLFieldTranslator(this.getRoot(), null, this.getDirectory());
        return this.loadTranslations(trns, this.getRoot(), mappings);
    }

    protected final SQLFieldTranslator loadTranslations(SQLFieldTranslator trns, DBRoot root, List<String> mappings) {
        Locale locale = TM.getInstance().getTranslationsLocale();
        ResourceBundle.Control cntrl = TranslationManager.getControl();
        boolean found = false;
        String fakeBaseName = "";
        Locale targetLocale = locale;
        while (targetLocale != null && !found) {
            List<Locale> langs = cntrl.getCandidateLocales("", targetLocale);
            ListIterator<Locale> listIterator = CollectionUtils.getListIterator(langs, true);
            while (listIterator.hasNext()) {
                Locale lang = listIterator.next();
                found |= this.loadTranslations(trns, PropsConfiguration.class.getResourceAsStream(String.valueOf(cntrl.toBundleName("mapping", lang)) + ".xml"), root);
                for (String m : mappings) {
                    found |= this.loadTranslations(trns, this.getStream(String.valueOf(cntrl.toBundleName(m, lang)) + ".xml"), root);
                }
            }
            targetLocale = cntrl.getFallbackLocale("", targetLocale);
        }
        return trns;
    }

    private final boolean loadTranslations(SQLFieldTranslator trns, InputStream in, DBRoot root) {
        boolean res;
        boolean bl = res = in != null;
        if (res) {
            trns.load(root, in);
        }
        return res;
    }

    protected File createWD() {
        return new File(this.getProperty("wd"));
    }

    @Override
    public final ShowAs getShowAs() {
        return this.showAs.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final DBRoot getRoot() {
        Object object = this.treeLock;
        synchronized (object) {
            this.checkDestroyed();
            if (this.root == null) {
                this.setRoot(this.createRoot());
            }
            return this.root;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final DBSystemRoot getSystemRoot() {
        Object object = this.treeLock;
        synchronized (object) {
            this.checkDestroyed();
            if (this.sysRoot == null) {
                this.sysRoot = this.createSystemRoot();
            }
            return this.sysRoot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SQLServer getServer(boolean initSysRoot) {
        Object object = this.treeLock;
        synchronized (object) {
            this.checkDestroyed();
            if (this.server == null) {
                this.setServer(this.createServer());
                if (initSysRoot && this.server.getSQLSystem().getLevel(DBSystemRoot.class) == HierarchyLevel.SQLSERVER) {
                    this.getSystemRoot();
                }
            }
            return this.server;
        }
    }

    @Override
    public final SQLFieldTranslator getTranslator() {
        return this.translator.get();
    }

    @Override
    public final SQLElementDirectory getDirectory() {
        return this.directory.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ProductInfo getProductInfo() {
        Object object = this.restLock;
        synchronized (object) {
            return this.productInfo;
        }
    }

    @Override
    public final String getAppName() {
        ProductInfo productInfo = this.getProductInfo();
        if (productInfo != null) {
            return productInfo.getName();
        }
        return this.getProperty("app.name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final File getWD() {
        Object object = this.restLock;
        synchronized (object) {
            if (this.wd == null) {
                this.setWD(this.createWD());
            }
            return this.wd;
        }
    }

    private final void setFilter(SQLFilter filter) {
        this.filter = filter;
    }

    private void setServer(SQLServer server) {
        this.server = server;
    }

    private final void setRoot(DBRoot root) {
        this.root = root;
        this.checkDestroyed();
        this.urMngr = this.createUserRightsManager(root);
    }

    private final void setWD(File dir) {
        this.wd = dir;
    }

    private abstract class Addable<T> {
        private boolean destroyed;
        private final List<Configuration> toAdd;
        private Future<T> f;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Addable() {
            Addable addable = this;
            synchronized (addable) {
                this.toAdd = new ArrayList<Configuration>();
                this.f = null;
                this.destroyed = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final T get() {
            Future<T> future;
            FutureTask<T> futureTask;
            Addable addable = this;
            synchronized (addable) {
                PropsConfiguration.checkDestroyed(this.destroyed);
                if (this.f == null) {
                    final ArrayList<Configuration> l = new ArrayList<Configuration>(this.toAdd);
                    this.toAdd.clear();
                    futureTask = new FutureTask<T>(new Callable<T>(){

                        @Override
                        public T call() throws Exception {
                            Object res = Addable.this.create();
                            if (!$assertionsDisabled && Thread.holdsLock(Addable.this)) {
                                throw new AssertionError();
                            }
                            for (Configuration s : l) {
                                Addable.this.add(res, s);
                            }
                            return res;
                        }
                    });
                    this.f = futureTask;
                    future = futureTask;
                } else {
                    futureTask = null;
                    future = this.f;
                }
            }
            if (futureTask != null) {
                futureTask.run();
            }
            try {
                return future.get();
            }
            catch (InterruptedException e) {
                throw new RTInterruptedException(e);
            }
            catch (ExecutionException e) {
                throw new IllegalStateException(e);
            }
        }

        protected abstract T create();

        protected abstract void add(T var1, Configuration var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void destroy() {
            Future<T> future;
            Addable addable = this;
            synchronized (addable) {
                this.destroyed = true;
                future = this.f;
            }
            if (future != null) {
                this.destroy(future);
            }
        }

        protected void destroy(Future<T> future) {
        }
    }

    protected static enum FileMode {
        IN_JAR,
        NORMAL_FILE;

    }
}

